package com.bcxin.rest.web.apis.controllers.salarycal;

import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.validation.constraints.NotNull;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.bcxin.api.interfaces.rbacs.ISalaryGroupService;
import com.bcxin.api.interfaces.salary.req.DeptEmployeeReq;
import com.bcxin.api.interfaces.salary.req.GroupCreateNextReq;
import com.bcxin.api.interfaces.salary.req.GroupLockReq;
import com.bcxin.api.interfaces.salary.req.GroupPageQueryReq;
import com.bcxin.api.interfaces.salary.req.GroupStatisticsReq;
import com.bcxin.api.interfaces.salary.req.ItemGroupReq;
import com.bcxin.api.interfaces.salary.req.SalaryGroupEmployeeVO;
import com.bcxin.api.interfaces.salary.req.SalaryGroupSaveReq;
import com.bcxin.api.interfaces.salary.res.GroupPageQueryRes;
import com.bcxin.api.interfaces.salary.res.GroupStatisticsRes;
import com.bcxin.rest.web.apis.ResponseBuilder;
import com.bcxin.rest.web.apis.controllers.ControllerAbstract;

import cn.hutool.json.JSONObject;

/**
 * @description 薪资组
 */
@RestController
@RequestMapping("/{organizationId}")
public class SalaryGroupController extends ControllerAbstract{

    @Autowired
    private ISalaryGroupService salaryGroupService;

    /**
    * 新增或编辑薪资组  第一步
    */
    @PostMapping("/group/save")
    public ResponseEntity save(@RequestBody SalaryGroupSaveReq salaryGroup){
    	try {
    		salaryGroupService.save(salaryGroup);
		} catch (Exception e) {
			e.printStackTrace();
			return ResponseBuilder.build(HttpStatus.EXPECTATION_FAILED, e.getLocalizedMessage());
		}
    
        return this.ok();
    }
    /**
     * 薪资组明细 
     */
    @RequestMapping("/group/detail")
    public ResponseEntity detail(Long groupId){
    	GroupPageQueryRes res = salaryGroupService.getById(groupId);
    	return this.ok(res);
    }
    

    /**
    * 删除
    */
    @PostMapping("/group/delete")
    public ResponseEntity delete(@NotNull Long id){
    	salaryGroupService.deleteById(id);
    	   return this.ok();
    }

    /**
    * 查询项目的分组列表
    */
    @PostMapping("/group/itemgroup")
    public ResponseEntity find(){
    	
        return this.ok(salaryGroupService.findItemGroup());
    }

    
    /**
    * 保存项目的分组
    */
    @PostMapping("/itemgroup/save")
    public ResponseEntity itemGroupSave(@RequestBody ItemGroupReq req){
    	salaryGroupService.itemGroupSave(req);
        return this.ok();
    }
    
    /**
    * 删除项目的分组
    */
    @PostMapping("/itemgroup/del")
    public ResponseEntity itemGroupSave(@NotNull Integer id){
    	salaryGroupService.itemGroupDel(id);
        return this.ok();
    }
    
    
    /**
    * 分页查询
    */
    @PostMapping("/group/list")
    public Object pageList(@RequestBody GroupPageQueryReq req) {

     return this.ok(salaryGroupService.pageQuery(req));
    }
    /**
     * 条件查询
     */
    @PostMapping("/group/listEmployee")
    public Object list(@RequestBody SalaryGroupEmployeeVO req) {
    	
    	return this.ok(salaryGroupService.list(req));
    }
    /**
     * 组织机构查询
     */
    @PostMapping("/group/orgTree")
    public Object listOrgTree() {
    	return this.ok(salaryGroupService.selectSalaryOrgList());
    }
    /**
     * 校验自定义公式
     * @throws ScriptException 
     */
    @PostMapping("/group/validate")
    @Deprecated
    public Object validate(@RequestBody JSONObject object ) throws ScriptException {
    	ScriptEngine jse = new ScriptEngineManager().getEngineByName("JavaScript");
    	jse.eval(object.getStr("formula"));
    	return this.ok();
    }
    @PostMapping("/listDeptEmployee")
    public Object listDeptEmployee(@RequestBody DeptEmployeeReq req )  {
    	return this.ok(salaryGroupService.listDeptEmployee(req));
    }
    /***
     * 当前计薪统计
     * @param req
     * @return
     * @throws ScriptException
     */
    @PostMapping("/group/Statistics")
    public Object Statistics(@RequestBody GroupStatisticsReq req ) {
    	GroupStatisticsRes res = salaryGroupService.statistics(req);
    	return this.ok(res);
    }
   /**
    * 薪资组锁定与解锁
    * @param req
    * @return
    */
    @PostMapping("/group/lock")
    public Object lock(@RequestBody GroupLockReq req ) {
    	salaryGroupService.lock(req);
    	return this.ok();
    }
    /**
     * 创建下月工资表  当前计薪月+1
     * @param req
     * @return
     */
    @PostMapping("/group/createNext")
    public Object createNext(@RequestBody GroupCreateNextReq req ) {
    	salaryGroupService.createNext(req);
    	return this.ok();
    }

}
