package com.bcxin.rest.web.apis.controllers.salarycal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.util.ListUtils;
import com.alibaba.fastjson.JSON;
import com.bcxin.Infrastructures.components.ExcelProvider;
import com.bcxin.api.interfaces.rbacs.ISalaryCurrentService;
import com.bcxin.api.interfaces.salary.req.ImportSaveFloatReq;
import com.bcxin.api.interfaces.salary.req.SalaryAttendanceHead;
import com.bcxin.api.interfaces.salary.req.SalaryGroupEmployeeVO;
import com.bcxin.api.interfaces.salary.req.SalaryTaxHead;
import com.bcxin.rest.web.apis.constants.RestConstants;
import com.bcxin.rest.web.apis.controllers.ControllerAbstract;
import com.bcxin.rest.web.apis.utils.SalaryExcelUtil;

import lombok.extern.slf4j.Slf4j;
@Slf4j
@RestController
@RequestMapping("/{organizationId}")
public class SalaryExcelController extends ControllerAbstract{


	@Autowired
	private ExcelProvider excelProvider;
	
	private Object rst;

	@Autowired
	private  ISalaryCurrentService salaryCurrentService ;
	
	@PostMapping("/download/next")
	public ResponseEntity downloadNext(HttpServletResponse  response ) throws IOException {
		response.setContentType("application/octet-stream");
		response.setCharacterEncoding("utf-8");
		response.setHeader("Content-disposition", "attachment;filename=demo.xlsx");
		return this.ok();

	}
	/**
	 * 考勤模板下载
	 * @param response
	 * @return
	 * @throws IOException
	 */
	@RequestMapping("/download/attendance")
	public ResponseEntity downloadAttendance(HttpServletResponse  response,Long groupId ) throws IOException {
		response.setContentType("application/octet-stream");
		response.setCharacterEncoding("utf-8");
		// 这里URLEncoder.encode可以防止中文乱码 
		String fileName = URLEncoder.encode("月度考勤汇总数据导入模板", "UTF-8").replaceAll("\\+", "%20");
		response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
		InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(RestConstants.ATTENDANCE_TEMPLATE);
		List<SalaryGroupEmployeeVO> lst = salaryCurrentService.listGroupUser(groupId);
		EasyExcel.write(response.getOutputStream())
				.withTemplate(inputStream).sheet().doFill(lst);

		response.flushBuffer();
		return this.ok();
		
	}
	/**
	 * 个税模板下载
	 * @param response
	 * @param groupId
	 * @return
	 * @throws IOException
	 */
	@RequestMapping("/download/tax")
	public ResponseEntity downloadTax(HttpServletResponse  response,Long groupId ) throws IOException {
		response.setContentType("application/octet-stream");
		response.setCharacterEncoding("utf-8");
		// 这里URLEncoder.encode可以防止中文乱码 
		String fileName = URLEncoder.encode("个税模板", "UTF-8").replaceAll("\\+", "%20");
		response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
		InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(RestConstants.TAX_TEMPLATE);
		List<SalaryGroupEmployeeVO> lst = salaryCurrentService.listGroupUser(groupId);
		String ts = "D:\\test\\t.xlsx"; // response.getOutputStream()
		EasyExcel.write(response.getOutputStream())
		.withTemplate(inputStream).sheet().doFill(lst);
		
		response.flushBuffer();
		return this.ok();
		
	}

	/**
	 * 薪资计算-当前工资-导入下月工资单 # 83
	 * @param employeeNos
	 * @param response
	 * @return
	 * @throws IOException
	 */
	@PostMapping("/import/next")
	public ResponseEntity importNext(@RequestBody List<String>employeeNos,HttpServletResponse  response ) throws IOException {
		response.setContentType("application/octet-stream");
		response.setCharacterEncoding("utf-8");
		response.setHeader("Content-disposition", "attachment;filename=demo.xlsx");
		return this.ok();

	}
	/**
	 * 解析考勤数据
	 * @param file
	 * @return
	 * @throws IOException
	 */
	@RequestMapping("/parse/attendance")
	public ResponseEntity parseAttendance(MultipartFile file, Long groupId) throws IOException {
		List<SalaryAttendanceHead> datas = new ArrayList<SalaryAttendanceHead>();
		excelProvider.read(file.getInputStream(), SalaryAttendanceHead.class,100,new Consumer<List<SalaryAttendanceHead>>() {

			public void accept(List<SalaryAttendanceHead> t) {
				for (SalaryAttendanceHead item : t) {
//					salaryCurrentService.importAttendance(item,groupId);
					datas.add(item);
				}
			}
		},4);
		return this.ok(datas);

	}
	/**
	 * 解析个税数据
	 * @param file
	 * @return
	 * @throws IOException
	 */
	@RequestMapping("/parse/tax")
	public ResponseEntity parseTax(MultipartFile file, Long groupId) throws IOException {
		List<SalaryTaxHead> datas = new ArrayList<>();
		excelProvider.read(file.getInputStream(), SalaryTaxHead.class,100,new Consumer<List<SalaryTaxHead>>() {
			
			public void accept(List<SalaryTaxHead> t) {
				for (SalaryTaxHead item : t) {
					datas.add(item);
				}
			}
		},4);
		return this.ok(datas);
		
	}
	/**
	 * 导入个税数据
	 * @param  List<SalaryAttendanceHead>
	 * @return
	 */
	@RequestMapping("/import/tax")
	public ResponseEntity importTax(@RequestBody List<SalaryTaxHead> datas,Long groupId) {
		for (SalaryTaxHead item : datas) {
			salaryCurrentService.importTax(item,groupId);
		}
		return this.ok();
		
	}
	/**
	 * 导入考勤数据
	 */
	@RequestMapping("/import/attendance")
	public ResponseEntity importAttendance(@RequestBody List<SalaryAttendanceHead> datas,Long groupId) throws IOException {
		for (SalaryAttendanceHead item : datas) {
			salaryCurrentService.importAttendance(item,groupId);
		}
		return this.ok();
		
	}
	/**
	 * 导入浮动
	 * @param file
	 * @return
	 * @throws IOException
	 */
	@RequestMapping("/import/float")
	public ResponseEntity importFloat(MultipartFile file,Long groupId) throws IOException {

		EasyExcel.read(file.getInputStream(), new NoModelDataListener(groupId )).sheet().doRead();

		return this.ok(rst);

	}
	/**
	 * 导入浮动保存到数据库
	 * @param file
	 * @return
	 * @throws IOException
	 */
	@RequestMapping("/import/saveFloat")
	public ResponseEntity importFloat(@RequestBody ImportSaveFloatReq req ) throws IOException {
		
		salaryCurrentService.importFloat(req.getDatas(),req.getGroupId());
		return this.ok();
		
	}
	/**
	 * 生成浮动数据模板
	 * @param response
	 * @param id
	 * @return
	 * @throws IOException
	 */
	@RequestMapping("/float/gentemp")
	public ResponseEntity gentemp(HttpServletResponse  response,@RequestParam Long groupId) throws IOException {

		
		response.setContentType("application/octet-stream");
		response.setCharacterEncoding("utf-8");
		// 这里URLEncoder.encode可以防止中文乱码 当然和easyexcel没有关系
		String fileName = URLEncoder.encode("浮动数据导入", "UTF-8").replaceAll("\\+", "%20");
		response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
		// 读取薪资组的规则
		Map<String,Object> header = salaryCurrentService.genFloatTemp(groupId);
	    String tst = "D:\\test\\浮动数据.xlsx"; // response.getOutputStream()
		EasyExcel.write(response.getOutputStream()).head(SalaryExcelUtil.createHead((List<String>)header.get("header"))).sheet().doWrite((ArrayList<?>)header.get("data"));;
		return this.ok();

	}



	public class NoModelDataListener extends AnalysisEventListener<Map<Integer, String>> {
		/**
		 * 每隔5条存储数据库，实际使用中可以100条，然后清理list ，方便内存回收
		 */
		private static final int BATCH_COUNT = 1000;
		private Map<Integer, String> floatHeader =null;
		private Long groupId ;
		private List<Map<Integer, String>> cachedDataList = ListUtils.newArrayListWithExpectedSize(BATCH_COUNT);

		public NoModelDataListener(Long groupId) {
			this.groupId= groupId;
		}

		@Override
		public void invoke(Map<Integer, String> data, AnalysisContext context) {
			System.out.println(JSON.toJSONString(data));
			cachedDataList.add(data);
			if (cachedDataList.size() >= BATCH_COUNT) {
				saveData();
				cachedDataList = ListUtils.newArrayListWithExpectedSize(BATCH_COUNT);
			}
		}

		@Override
		public void doAfterAllAnalysed(AnalysisContext context) {
			saveData();
			log.info("所有数据解析完成！");
		}
		@Override
		public void invokeHeadMap(Map<Integer, String> headMap, AnalysisContext context) {
			this.floatHeader= headMap;
			System.out.println(headMap);
		}

		/**
		 * 加上存储数据库
		 */
		private void saveData() {
			List<Map<String,Object>>datas = new ArrayList<>();
			cachedDataList.forEach(map0->{
				Map<String,Object> data = new LinkedHashMap<String,Object>();
				map0.keySet().forEach(ind->{
					data.put(floatHeader.get(ind), map0.get(ind));
				});;
				datas.add(data);
			});
			System.out.println(datas);
			rst = salaryCurrentService.checkExcelData(datas);
		}
	}
}
