package com.bcxin.rest.web.apis.controllers.salarycal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.excel.EasyExcel;
import com.bcxin.api.interfaces.rbacs.ISalaryCurrentService;
import com.bcxin.api.interfaces.rbacs.ISalaryGroupService;
import com.bcxin.api.interfaces.salary.req.BatchDelGroupUserReq;
import com.bcxin.api.interfaces.salary.req.CurrentSalaryPagQueryReq;
import com.bcxin.api.interfaces.salary.req.CurrentUserAddReq;
import com.bcxin.api.interfaces.salary.req.PreTaxSalaryCommand;
import com.bcxin.api.interfaces.salary.req.SalaryUserCheckPageQuery;
import com.bcxin.rest.web.apis.controllers.ControllerAbstract;
import com.bcxin.rest.web.apis.responses.calcu.excel.CurrentSalaryExportReq;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;


@RestController
@RequestMapping("/{organizationId}")
public class SalaryCurrentController extends ControllerAbstract{
	
	

@Autowired
private  ISalaryCurrentService salaryCurrentService ;

@Autowired
private  ISalaryGroupService salaryGroupService ;



    /**
     * 当前薪资-列表  从MongoDB里面取数据
     * @param req
     * @return
     */
    @PostMapping("/salarylist")
    public ResponseEntity salarylist(@RequestBody CurrentSalaryPagQueryReq req ) {
        return this.ok(salaryCurrentService.pagelist(req));
    }
    
    /**
     * 当前薪资-计算薪资-税前工资
     * @param req
     * @return
     */
    @PostMapping("/compute")
    public ResponseEntity compute(@RequestBody CurrentSalaryPagQueryReq req ) {
    	salaryCurrentService.calSalary(req.getGroupId(),req.getType());
        return this.ok();
    }
    /**
     * 薪资计算-当前工资-更多操作-批量删除
     * @param req
     * @return
     */
    @PostMapping("/delsalary")
    public ResponseEntity del(@RequestBody List<Long>ids  ) {
    	ids.forEach(id->{
    		salaryCurrentService.del(id);
    	});
    	
    	return this.ok();
    }
  
    /**
     * 当前薪资-核对人员查询列表
     * @param req
     * @return
     */
    @PostMapping("/salaryuser")
    public ResponseEntity pageUserlist(@RequestBody SalaryUserCheckPageQuery query) {
    	return this.ok(salaryCurrentService.pageUserlist(query));
    }
   
    
    /**
     * 当前工资-添加算薪 
     */
    @PostMapping("/current/addEmployee")
    public ResponseEntity addEmployee(@RequestBody CurrentUserAddReq req ){
    	salaryCurrentService.addEmployee(req);
    	return this.ok();
    }
    /**
     *  薪资计算-当前工资-计算薪资-核对计薪人员-更多操作-批量删除功能  #83
     */
    @PostMapping("/check/batchdel")
    public ResponseEntity batchDelGroupUser(@RequestBody BatchDelGroupUserReq req ){
    	salaryGroupService.batchDelGroupUser(req);
    	return this.ok();
    }
    
    /**
     *  薪资计算-当前工资-更多操作-导出 #85 TODO
     * @param req
     * @return
     * @throws IOException 
     */
    @PostMapping("/export/checkExport")
    public ResponseEntity export(HttpServletResponse  response,@RequestBody CurrentSalaryExportReq req) throws IOException {
    	
        response.setContentType("application/octet-stream");
        response.setCharacterEncoding("utf-8");
        response.setHeader("Content-disposition", "attachment;filename=demo.xlsx");
        // get current month
        List<List<String>> headList = new ArrayList<List<String>>();
//        List<String> header0 =  new ArrayList<String>();
//        header0.add("姓名");
//        List<String> header1 =  new ArrayList<String>();
//        header1.add("员工号");
//        headList.add(header0);
//        headList.add(header1);
       
        List<List<String>>data = new ArrayList<List<String>>();
        List<Map> lst = salaryCurrentService.list(req.groupId);
        if(!lst.isEmpty()) {
        	List groupInfo = (List) lst.get(0).get("groupInfo");
        	for (Object arr : groupInfo) {
        		JSONObject obj = JSONUtil.parseObj(arr);
        		// 分组名
        		String name = obj.getStr("name");
        		JSONArray salaryItems = obj.getJSONArray("salaryItems");
        		for (Object item : salaryItems) {
        			List<String> header =  new ArrayList<String>();
        			JSONObject itemJson = JSONUtil.parseObj(item);
        		  	header.add(name);
        			header.add(itemJson.getStr("item"));
        			headList.add(header);
				}
			}
        }
        for (Map map : lst) {
        	
        	List<String> dta = new ArrayList<String>();
        	List groupInfo = (List) map.get("groupInfo");
        	for (Object arr : groupInfo) {
        		JSONObject obj = JSONUtil.parseObj(arr);
        		// 分组名
        		JSONArray salaryItems = obj.getJSONArray("salaryItems");
        		for (Object item : salaryItems) {
        			JSONObject itemJson = JSONUtil.parseObj(item);
        			dta.add(itemJson.getStr("value"));
				}
			}
        	data.add(dta);
         
		}
        EasyExcel.write(response.getOutputStream()) //  String path= "D:\\bx\\动态.xlsx";
                .head(headList)
                .sheet()
                .doWrite(data);
    	return this.ok();
    	
    }
    
    
    /**
     * 当前薪资-计算税前薪资列表
     * @param req
     * @return
     */
    @PostMapping("/preTax/salarylist")
    public ResponseEntity preTaxSalary(@RequestBody CurrentSalaryPagQueryReq req ) {
        return this.ok(salaryCurrentService.pagelist(req));
    }
    /**
     * 当前薪资-计算税前薪批量修改
     * @param req
     * @return
     */
    @PostMapping("/preTax/updateSalaryLst")
    public ResponseEntity updateSalaryLst(@RequestBody List<PreTaxSalaryCommand> commands ) {
    	salaryCurrentService.updateSalaryLst(commands);
    	return this.ok();
    }
    
    
    @PostMapping("/person/syn")
    public ResponseEntity syn(@RequestBody List<PreTaxSalaryCommand> commands ) {
    	salaryCurrentService.updateSalaryLst(commands);
    	return this.ok();
    }
    
}
