package com.bcxin.rest.web.apis.controllers.salarycal;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.bcxin.api.interfaces.rbacs.ISalaryConfigService;
import com.bcxin.api.interfaces.salary.res.EmployeeBasicRes;
import com.bcxin.api.interfaces.salary.res.SalaryConfigRes;
import com.bcxin.rest.web.apis.controllers.ControllerAbstract;

/**
 * @description 薪资组
 */
@RestController
@RequestMapping("/{organizationId}")
public class SalaryConfigController extends ControllerAbstract{

    @Autowired
    private ISalaryConfigService salaryConfigService;
    


    /**
    * 新增或编辑
    */
    @PostMapping("/config/save")
    public ResponseEntity save(@RequestBody SalaryConfigRes res){
    	salaryConfigService.save(res);
        return this.ok();
    }


    /**
    * 查询
    */
    @PostMapping("/config/find")
    public ResponseEntity find(String type){
    	
        return this.ok(salaryConfigService.findBy(type));
    }
    /**
     * 查询薪资规则的数据来源
     */
    @PostMapping("/config/rulesource")
    public ResponseEntity listRuleSource(){
    	
    	return this.ok(salaryConfigService.findBy("rule_source"));
    }
    /**
     * 根据数据来源查询薪资规则的字段  mysql  mongodb
     */
    @PostMapping("/config/rulecolumn")
    public ResponseEntity listRuleCol(@RequestBody SalaryConfigRes res){
    	return this.ok(salaryConfigService.findBy(res));
    }
   
}
