package com.bcxin.rest.web.apis.controllers.salarycal;

import java.io.IOException;
import java.util.List;

import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.excel.EasyExcel;
import com.bcxin.Infrastructures.components.ExcelProvider;
import com.bcxin.api.interfaces.rbacs.ISalaryArchiveService;
import com.bcxin.api.interfaces.rbacs.ISalaryChangeRecordService;
import com.bcxin.api.interfaces.salary.req.ArchiveChangePageQueryReq;
import com.bcxin.api.interfaces.salary.req.SalaryChangeRecordHead;
import com.bcxin.rest.web.apis.controllers.ControllerAbstract;
/**
 * 定调薪记录
 * @author ctyc
 *
 */
@RestController
@RequestMapping("/{organizationId}")
public class SalaryChangeRecordController extends ControllerAbstract{
	
	



@Autowired
private  ISalaryChangeRecordService salaryChangeRecordService ;
@Autowired
private  ISalaryArchiveService salaryArchiveService ;

    /**
     * 列表查询
     * @param req
     * @return
     */
    @PostMapping("/record/list")
    public ResponseEntity list(@RequestBody ArchiveChangePageQueryReq req ) {
        return this.ok(salaryChangeRecordService.queryRecordList(req));
    }
    /**
     * 调薪详情
     * @param req
     * @return
     */
    @PostMapping("/record/detail")
    public ResponseEntity getDetail(Long id ) {
    	return this.ok(salaryArchiveService.getFixedDetail(id));
    }
    
    /**
     * 撤销定调薪  撤销操作成功后保留撤销前的定调薪记录。
     * @return
     */
    @PostMapping("/record/batchrevoke")
    public ResponseEntity batchrevoke(@RequestBody List<Long> ids) {
        this.salaryChangeRecordService.batchRevokeChange(ids);
    	return this.ok();
    }
    /**
     *  撤销定调定薪    type=1 定薪 type = 2 调薪
     * @param req
     * @return
     */
    @PostMapping("/record/revoke")
    public ResponseEntity revoke(int id ) {
    	salaryChangeRecordService.revokeChange(id);
    	return this.ok(id);
    }
    
    @PostMapping("/record/export")
    public ResponseEntity export(@RequestBody List<String> ids,HttpServletResponse  response) throws IOException {
     response.setContentType("application/octet-stream");
     response.setCharacterEncoding("utf-8");
     response.setHeader("Content-disposition", "attachment;filename=demo.xlsx");
     List<SalaryChangeRecordHead>lst = salaryChangeRecordService.getExportData();
     EasyExcel.write(response.getOutputStream(), SalaryChangeRecordHead.class).sheet().doWrite(lst);
     return this.ok(ids);
    }
  
    
    
    
}
