package com.bcxin.rest.web.apis.controllers.salarycal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotEmpty;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.util.ListUtils;
import com.bcxin.api.interfaces.rbacs.ISalaryArchiveService;
import com.bcxin.api.interfaces.salary.req.ArchiveChangeReq;
import com.bcxin.api.interfaces.salary.req.ArchiveFixedReq;
import com.bcxin.api.interfaces.salary.req.ArchiveItemEditReq;
import com.bcxin.api.interfaces.salary.req.ArchivePageQueryReq;
import com.bcxin.api.interfaces.salary.req.DynamicBean;
import com.bcxin.api.interfaces.salary.res.ArchiveItemQueryRes;
import com.bcxin.api.interfaces.salary.res.ArchivePageQueryExport;
import com.bcxin.rest.web.apis.constants.RestConstants;
import com.bcxin.rest.web.apis.controllers.ControllerAbstract;
import com.bcxin.rest.web.apis.utils.SalaryExcelUtil;


@RestController
@RequestMapping("/{organizationId}")
public class SalaryArchiveController extends ControllerAbstract{
	
	



@Autowired
private  ISalaryArchiveService salaryArchiveService ;


  private Map<String,Object> tmp=new LinkedHashMap<String, Object>();
    /**
     * 薪资档案-列表
     * @param req
     * @return
     */
    @PostMapping("/archlist")
    public ResponseEntity archlist(@RequestBody ArchivePageQueryReq req ) {
        return this.ok(salaryArchiveService.queryArchlist(req));
    }
    /**
     * 薪资档案項查詢
     * @return
     */
    @PostMapping("/arch/itemquery")
    public ResponseEntity itemquery() {
    	return this.ok(salaryArchiveService.queryItem());
    }
    /**
     *  薪资档案-档案项设置
     * @param req
     * @return
     */
    @PostMapping("/arch/itemedit")
    public ResponseEntity itemedit(@RequestBody List<ArchiveItemEditReq> req ) {
    	salaryArchiveService.itemedit(req);
    	return this.ok();
    }
    /**
     *  薪资档案-档案项刪除
     * @param req
     * @return
     */
    @PostMapping("/arch/itemdel")
    public ResponseEntity itemdel(@NotEmpty String id) {
    	salaryArchiveService.itemedel(id);
    	return this.ok();
    }
    
    /**
     *  薪资档案-定薪 根據基本工資查詢总工资
     * @param req
     * @return
     */
    @PostMapping("/arch/totalquery")
    public ResponseEntity totalquery(@RequestBody ArchiveFixedReq req) {
    	
    	return this.ok(salaryArchiveService.getTotalByBasic(req));
    }
    /**
     *  薪资档案-单笔定薪
     * @param req
     * @return
     */
    @PostMapping("/arch/fixed")
    public ResponseEntity fixed(@RequestBody ArchiveFixedReq req) {
    	salaryArchiveService.fixSalary(req);
    	return this.ok();
    }
    
    /**
     *  薪资档案-单笔调薪
     * @param req
     * @return
     */
    @PostMapping("/arch/change")
    public ResponseEntity change(@RequestBody ArchiveChangeReq req) {
    	salaryArchiveService.changeSalary( req);
    	return this.ok();
    }
    
    /**
     *  薪资档案-定薪详情
     * @param req
     * @return
     */
    @PostMapping("/arch/fixdetail")
    public ResponseEntity fixdetail( long id) {
    	return this.ok(salaryArchiveService.getFixedDetail(id));
    }
    /**
     *  薪资档案-批量定薪 解析
     * @param req
     * @return
     * @throws IOException 
     */
    @PostMapping("/parse/batchfix")
    public ResponseEntity parsebatchfix(MultipartFile file ) throws IOException {
        //读取表头
    	EasyExcel.read(file.getInputStream(), new NoModelDataListener()).sheet().doRead();
    	return this.ok(tmp);
    }
    /**
     *  薪资档案-批量定薪导入
     * @param req
     * @return
     * @throws IOException 
     */
    @PostMapping("/arch/batchfix")
    public ResponseEntity batchfix(@RequestBody DynamicBean dynamic ) throws IOException {
    	//读取表头
    	List<String> cols = dynamic.getDynCol();
    	List<List<String>> datas = dynamic.getDynData();
    	
    	List<Map<String,Object>> maps = new ArrayList<>();
    	for (int i = 0; i < datas.size(); i++) {
    		Map<String,Object> dto = new LinkedHashMap<>();
			for (int j = 0; j < cols.size(); j++) {
				dto.put(cols.get(j), datas.get(i).get(j));
			}
			maps.add(dto);
		}
    	maps.forEach(dto->{
    		salaryArchiveService.importFixedSalary(dto);
    	});
    	return this.ok(maps);
    }
    
    
    /**
     *  薪资档案-批量调薪解析
     * @param req
     * @return
     * @throws IOException 
     */
    @RequestMapping("/parse/batchchange")
    public ResponseEntity parseBatchchange(MultipartFile file) throws IOException {
		EasyExcel.read(file.getInputStream(), new NoModelDataListener()).sheet().doRead();
    	return this.ok(tmp);
    	
    }
    /**
     *  薪资档案-批量调薪导入
     * @param req
     * @return
     * @throws IOException 
     */
    @RequestMapping("/arch/batchchange")
    public ResponseEntity batchchange(@RequestBody DynamicBean dynamic ) throws IOException {
    	
    	//读取表头
    	List<String> cols = dynamic.getDynCol();
    	List<List<String>> datas = dynamic.getDynData();
    	
    	List<Map<String,Object>> maps = new ArrayList<>();
    	for (int i = 0; i < datas.size(); i++) {
    		Map<String,Object> dto = new LinkedHashMap<>();
			for (int j = 0; j < cols.size(); j++) {
				dto.put(cols.get(j), datas.get(i).get(j));
			}
			maps.add(dto);
		}
    	maps.parallelStream().forEach(dto->{
    		salaryArchiveService.importChangeSalary(dto);
    	});
    	return this.ok(maps);
    	
    }
    
    /**
     *  薪资档案-导出
     * @param req
     * @return
     * @throws IOException 
     */
    @RequestMapping("/arch/export")
    public ResponseEntity export(@RequestBody ArchivePageQueryReq req,HttpServletResponse  response ) throws IOException {
        response.setContentType("application/octet-stream");
        response.setCharacterEncoding("utf-8");
        response.setHeader("Content-disposition", "attachment;filename=薪资档案.xlsx");
        List<ArchivePageQueryExport> lst = salaryArchiveService.export(req);
        EasyExcel.write(response.getOutputStream(), ArchivePageQueryExport.class).sheet().doWrite(lst);
    	return this.ok();
    
    }
    /**
     *  薪资档案-生成批量定薪模板
     * @param req
     * @return
     * @throws IOException 
     */
    @GetMapping("/arch/exportFixTemplate")
    public ResponseEntity exportFixTemplate(HttpServletResponse  response ) throws IOException {
    	response.setContentType("application/octet-stream");
    	response.setCharacterEncoding("utf-8");
    	response.setHeader("Content-disposition", "attachment;filename=批量定薪表.xlsx");
    	
    	// 得到薪资项
    	List<ArchiveItemQueryRes> res = salaryArchiveService.queryItem();
    	List<String> header = new ArrayList<String>();
    	header.add(RestConstants.NAME);
    	header.add(RestConstants.EMPLOYEENO);
    	header.add(RestConstants.DEPT);
    	for (ArchiveItemQueryRes salaryConfigRes : res) {
			header.add(RestConstants.CURRENT+salaryConfigRes.getName());
		}
    	for (ArchiveItemQueryRes salaryConfigRes : res) {
    		header.add(RestConstants.FORMAL+salaryConfigRes.getName());
    	}
    	// 匹配表头
    	ArchivePageQueryReq req = new ArchivePageQueryReq();
    	req.setType(1);
    	req.setChangeState("0");
    	List<ArchivePageQueryExport> lst = salaryArchiveService.export(req);
    	List<List<String>>rst = new ArrayList<List<String>>();
    	for (ArchivePageQueryExport archivePageQueryExport : lst) {
    		List<String> obj = new ArrayList<String>();
    		obj.add(archivePageQueryExport.getName());
    		obj.add(archivePageQueryExport.getEmployeeNo());
    		obj.add(archivePageQueryExport.getDept());
    		rst.add(obj);
		}
//    	InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(RestConstants.ATTENDANCE_TEMPLATE);
    	String ts= "D://test//fix.xlsx"; // response.getOutputStream()
//        ExcelWriter excelWriter = EasyExcel.write(ts).withTemplate(inputStream).build();
//        WriteSheet writeSheet = EasyExcel.writerSheet().build();
//        writeSheet.setHead(SalaryExcelUtil.createHead(header));
//        // 直接写入数据
//        excelWriter.fill(lst, writeSheet);
//        excelWriter.finish();
    	EasyExcel.write(response.getOutputStream()).head(SalaryExcelUtil.createHead(header)).sheet().doWrite(rst);
    	response.flushBuffer();
    	return this.ok();
    	
    }
    /**
     *  薪资档案-生成批量调薪模板
     * @param req
     * @return
     * @throws IOException 
     */
    @RequestMapping("/arch/exportChangeTemp")
    public ResponseEntity exportChangeTemp(HttpServletResponse  response ) throws IOException {
    	response.setContentType("application/octet-stream");
    	response.setCharacterEncoding("utf-8");
    	response.setHeader("Content-disposition", "attachment;filename=批量调薪表.xlsx");
    	// 得到薪资项
    	List<ArchiveItemQueryRes> res = salaryArchiveService.queryItem();
    	List<String> header = new ArrayList<String>();
    	header.add(RestConstants.NAME);
    	header.add(RestConstants.EMPLOYEENO);
    	header.add(RestConstants.DEPT);
    	for (ArchiveItemQueryRes salaryConfigRes : res) {
    		header.add(RestConstants.JUSTED+salaryConfigRes.getName());
    	}
    	header.add(RestConstants.VALID_DATE);
    	header.add(RestConstants.JUSTED_REMARK);
    	// 匹配表头
    	ArchivePageQueryReq req = new ArchivePageQueryReq();
       	req.setChangeState("2");
    	List<ArchivePageQueryExport> lst = salaryArchiveService.export(req);
    	List<List<String>>rst = new ArrayList<List<String>>();
    	for (ArchivePageQueryExport archivePageQueryExport : lst) {
    		List<String> obj = new ArrayList<String>();
    		obj.add(archivePageQueryExport.getName());
    		obj.add(archivePageQueryExport.getEmployeeNo());
    		obj.add(archivePageQueryExport.getDept());
//    		String jsonArry = archivePageQueryExport.getOtherItem();
//    		JSONArray arr = JSONUtil.parseArray(jsonArry);
//    		for (Object s : arr) {
//    			String value =JSONUtil.parseObj(s).getStr("vaule");
//    			obj.add(value);
//			}
    		rst.add(obj);
    	}
    	// response.getOutputStream()
    	String ts= "D://test//fix.xlsx";  //response.getOutputStream();
    	EasyExcel.write(response.getOutputStream()).head(SalaryExcelUtil.createHead(header)).sheet().doWrite(rst);
    	return this.ok();
    	
    }
    
    
    public class NoModelDataListener extends AnalysisEventListener<Map<Integer, String>> {
        /**
         * 每隔5条存储数据库，实际使用中可以100条，然后清理list ，方便内存回收
         */
        private static final int BATCH_COUNT = 5;
        private List<Map<Integer, String>> cachedDataList = ListUtils.newArrayListWithExpectedSize(BATCH_COUNT);
        private List<String>dynCol= new ArrayList<String>();
        private List<List<String>>dynData= new ArrayList<>();
        public NoModelDataListener() {
        	tmp.put("dynCol", dynCol);
        	tmp.put("dynData", dynData);
		}

		@Override
        public void invoke(Map<Integer, String> data, AnalysisContext context) {
			cachedDataList.add(data);
        }

        @Override
        public void doAfterAllAnalysed(AnalysisContext context) {
        	saveData();
        }
        @Override
        public void invokeHeadMap(Map<Integer, String> headMap, AnalysisContext context) {
        	headMap.keySet().forEach(k->{
            	dynCol.add(headMap.get(k));
            });
        }

        /**
         * 加上存储数据库
         */
        private void saveData() {
       		
       		cachedDataList.forEach(dt->{
       			List<String> data = new ArrayList<>();
       			dt.entrySet().forEach(s->{
       				data.add(s.getValue());
       			});
       			dynData.add(data);
    		});
        }
    }
}
