package com.bcxin.rest.web.apis.controllers;

import com.bcxin.api.interfaces.tenants.UserRpcProvider;
import com.bcxin.api.interfaces.tenants.requests.tenantUsers.UpdateBasicTenantUserRequest;
import com.bcxin.api.interfaces.tenants.requests.tenantUsers.UpdateTenantUserRequest;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/tenant/users")
public class TenantUserController extends ControllerAbstract{
    private final UserRpcProvider userRpcProvider;

    public TenantUserController(UserRpcProvider userRpcProvider) {
        this.userRpcProvider = userRpcProvider;
    }

    @ApiOperation(value = "更改用户其他基本", response = Void.class)
    @PutMapping("/{id}/detail")
    public ResponseEntity put(@PathVariable String id, @RequestBody UpdateTenantUserRequest request) {
        this.userRpcProvider.update(id, request);

        return this.ok();
    }

    @ApiOperation(value = "变更用户姓名/手机信息", response = Void.class)
    @PutMapping("/{id}/basic")
    public ResponseEntity put_basic(@PathVariable String id, @RequestBody UpdateBasicTenantUserRequest request) {
        this.userRpcProvider.updateBasic(id, request);

        return this.ok();
    }
}
