package com.bcxin.rest.web.apis.controllers;

import com.bcxin.Infrastructures.Pagination;
import com.bcxin.api.interfaces.tenants.EmployeeRpcProvider;
import com.bcxin.api.interfaces.tenants.OrganizationRpcProvider;
import com.bcxin.api.interfaces.tenants.criterias.OrganizationCriteria;
import com.bcxin.api.interfaces.tenants.requests.organizations.ApproveCompanyRequest;
import com.bcxin.api.interfaces.tenants.requests.organizations.CompanyRegistrationRequest;
import com.bcxin.api.interfaces.tenants.responses.OrganizationGetResponse;
import com.bcxin.api.interfaces.tenants.responses.OrganizationResponse;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

/**
 * 先统一再Service进行验证
 */
//@Validated
@RestController
@RequestMapping("/tenant/organizations")
public class OrganizationController extends ControllerAbstract {
    private final OrganizationRpcProvider organizationRpcProvider;
    private final EmployeeRpcProvider employeeRpcProvider;

    public OrganizationController(OrganizationRpcProvider organizationRpcProvider,
                                  EmployeeRpcProvider employeeRpcProvider) {
        this.organizationRpcProvider = organizationRpcProvider;
        this.employeeRpcProvider = employeeRpcProvider;
    }

    @ApiOperation(value = "注册企业信息", response = String.class)
    @PostMapping("/registration")
    public ResponseEntity post(@Valid @RequestBody CompanyRegistrationRequest request) {
        String comId = this.organizationRpcProvider.register(request);
        return this.ok(comId);
    }

    @ApiOperation(value = "获取企业详情", response = OrganizationGetResponse.class)
    @GetMapping("/{organizationId}")
    public ResponseEntity<OrganizationGetResponse> get(@PathVariable String organizationId) {
        OrganizationGetResponse response = organizationRpcProvider.get(organizationId);

        return this.ok(response);
    }

    @ApiOperation(value = "审批企业", response = OrganizationResponse.class)
    @PutMapping("/{organizationId}/approved")
    public ResponseEntity approved(@PathVariable String organizationId,
                                   @RequestBody ApproveCompanyRequest request) {
        this.organizationRpcProvider.approve(organizationId, request);

        return ok();
    }

    @ApiOperation(value = "搜索企业信息", response = OrganizationResponse.class)
    @PostMapping("/search")
    public ResponseEntity search(@RequestBody OrganizationCriteria criteria) {
        Pagination<OrganizationResponse> data =
                this.organizationRpcProvider.search(criteria);

        return this.ok(data);
    }
}
