package com.bcxin.rest.web.apis.controllers;

import com.bcxin.api.interfaces.identities.IdentityRpcProvider;
import com.bcxin.api.interfaces.identities.requests.*;
import com.bcxin.api.interfaces.identities.responses.PrepareResetPasswordResponse;
import com.bcxin.api.interfaces.identities.responses.SignInResponse;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;

@RestController
@RequestMapping("/identity")
public class IdentityController extends ControllerAbstract {
    private final IdentityRpcProvider identityRpcProvider;

    public IdentityController(IdentityRpcProvider identityRpcProvider) {
        this.identityRpcProvider = identityRpcProvider;
    }

    @ApiOperation(value = "登入", response = SignInResponse.class)
    @PostMapping("/sign-in")
    public ResponseEntity<SignInResponse> signIn(@Valid @RequestBody SignInRequest request) {
        SignInResponse response = this.identityRpcProvider.signIn(request);

        return this.ok(response);
    }

    @ApiOperation(value = "修改密码", response = SignInResponse.class)
    @PostMapping("/change-password")
    public ResponseEntity changePassword(
            @Valid @RequestBody com.bcxin.rest.web.apis.requests.ChangePasswordRequest request,
            HttpServletRequest servletRequest) {
        ChangePasswordRequest changePasswordRequest = request.getRequest(servletRequest);
        this.identityRpcProvider.changePassword(changePasswordRequest);

        return this.ok(null);
    }

    @ApiOperation(value = "微信登入", response = SignInResponse.class)
    @PostMapping("/wechat-in")
    public ResponseEntity<SignInResponse> sso_login(@RequestBody WeChatSignInRequest request) {
        SignInResponse response = this.identityRpcProvider.signIn(request);

        return this.ok(response);
    }

    @ApiOperation(value = "忘记密码前的验证操作(短信/人脸)")
    @PostMapping("/prepare-reset-password")
    public ResponseEntity prepareResetPassword(@RequestBody PrepareResetPasswordRequest request) {
        PrepareResetPasswordResponse response = this.identityRpcProvider.prepareResetPassword(request);

        return this.ok(response);
    }

    @ApiOperation(value = "通过忘记密码前的操作执行密码修改")
    @PostMapping("/reset-password")
    public ResponseEntity resetPassword(@RequestBody ResetPasswordRequest request) {
        this.identityRpcProvider.restPassword(request);

        return this.ok();
    }
}
