package com.bcxin.rest.web.apis.controllers;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletResponse;

import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.metadata.fill.FillConfig;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import com.bcxin.api.interfaces.commons.DownloadImportedResponse;
import com.bcxin.api.interfaces.tenants.ResourceRpcProvider;
import com.bcxin.rest.web.apis.constants.ReportConstants;

@RequestMapping("/download/resources/{resourceId}")
@RestController
public class DownloadController extends ControllerAbstract {
    private static Map<String, InputStream> _staticTemplateResource = new ConcurrentHashMap<>();
    private final ResourceRpcProvider resourceRpcProvider;

    public DownloadController(ResourceRpcProvider resourceRpcProvider) {
        this.resourceRpcProvider = resourceRpcProvider;
    }

    @GetMapping("/{category}")
    public void download(HttpServletResponse response, @PathVariable String resourceId, @PathVariable String category) throws IOException {
        response.setContentType("application/octet-stream");// 设置文本内省
        response.setCharacterEncoding("utf-8");// 设置字符编码
        DownloadImportedResponse result = this.resourceRpcProvider.getImportResult(resourceId, category);
        String fileName = String.format("%s.xlsx", UUID.randomUUID());
        if (StringUtils.hasLength(result.getPath()) && result.getPath().contains("/")) {
            fileName = result.getPath().substring(result.getPath().lastIndexOf("/") + 1);
        }

        String disposition = String.format("attachment;filename=%s.xlsx", URLEncoder.encode(fileName, "UTF-8"));
        response.setHeader("Content-disposition", disposition);

        Collection<Map<String, Object>> errorItems = result.getReport().stream().filter(ii -> !ii.IsSuccess())
                .map(ii -> ii.getParameters())
                .collect(Collectors.toList());

        try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(getCategoryTemplate(category))) {
            ExcelWriter excelWriter = EasyExcel.write(response.getOutputStream())
                    .withTemplate(inputStream).build();
            FillConfig fillConfig = FillConfig.builder().forceNewRow(false)
                    .build();
            excelWriter.fill(errorItems, fillConfig, EasyExcel.writerSheet().build());

            excelWriter.finish();
            response.flushBuffer();
        }
    }

    private static String getCategoryTemplate(String category) {
        switch (category) {
            case ReportConstants.DEPARTMENT:
                return "templates/V5部门导入模板2021.xlsx";
            case ReportConstants.EMPLOYEE:
                return "templates/V5在职员工导入模板2021.xlsx";
            case ReportConstants.CONTRACT:
                return "templates/V5合同导入模板2021.xlsx";
        }

        throw new ArgumentTenantException("无效参数");
    }
    
}