package com.bcxin.rest.web.apis.controllers;

import com.bcxin.Infrastructures.Pagination;
import com.bcxin.api.interfaces.tenants.DepartAdminRpcProvider;
import com.bcxin.api.interfaces.tenants.criterias.DepartAdminCriteria;
import com.bcxin.api.interfaces.tenants.requests.BatchCreateDepartAdminRequest;
import com.bcxin.api.interfaces.tenants.requests.BatchDeleteDepartAdminRequest;
import com.bcxin.api.interfaces.tenants.responses.DepartAdminGetResponse;
import com.bcxin.rest.web.apis.requests.SearchDepartAdminRequest;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/tenant/organizations/{organizationId}/depart-admins")
public class DepartAdminController extends ControllerAbstract {
    private final DepartAdminRpcProvider departAdminRpcProvider;

    public DepartAdminController(DepartAdminRpcProvider departAdminRpcProvider) {
        this.departAdminRpcProvider = departAdminRpcProvider;
    }

    @ApiOperation(value = "批量添加部门管理员", response = Void.class)
    @PostMapping("/batch-create")
    public ResponseEntity post(@PathVariable String organizationId,
                               @RequestBody BatchCreateDepartAdminRequest request) {
        this.departAdminRpcProvider.batchCreate(organizationId, request);

        return this.ok();
    }

    @ApiOperation(value = "批量删除部门管理员", response = Void.class)
    @PostMapping("/batch-delete")
    public ResponseEntity delete(@PathVariable String organizationId,
                                 @RequestBody BatchDeleteDepartAdminRequest request) {
        this.departAdminRpcProvider.batchDelete(organizationId, request);

        return this.ok();
    }

    @ApiOperation(value = "搜索部门管理员", response = DepartAdminGetResponse.class, responseContainer = "list")
    @PostMapping("/search")
    public ResponseEntity search(@PathVariable String organizationId,
                                                         @RequestBody SearchDepartAdminRequest request) {
        DepartAdminCriteria criteria = DepartAdminCriteria.create(
                request.getPageIndex(),
                request.getPageSize(),
                organizationId, this.getSelectedEmployeeId());

        criteria.changePage(request.getPageIndex(), request.getPageSize());

        Pagination<DepartAdminGetResponse> responsePageable =
                this.departAdminRpcProvider.search(criteria);

        return this.ok(responsePageable);
    }
}
