package com.bcxin.rest.web.apis.caches;
import com.bcxin.Infrastructures.enums.MasterSlaveType;
import lombok.Getter;

import java.io.Serializable;
import java.util.Map;

@Getter
public class UserOrganBasic implements Serializable {
    private final String organizationId;
    private final String employeeId;
    private final String name;
    private final MasterSlaveType masterSlaveType;
    private final Map<String,Object> additional;

    public UserOrganBasic(String organizationId, String employeeId, String name,
                          MasterSlaveType masterSlaveType,
                          Map<String,Object> additional) {
        this.organizationId = organizationId;
        this.employeeId = employeeId;
        this.name = name;
        this.masterSlaveType = masterSlaveType;
        this.additional = additional;
    }

    public static UserOrganBasic create(String organizationId, String employeeId, String name,
                                        MasterSlaveType masterSlaveType,Map<String,Object> additional) {
        return new UserOrganBasic(organizationId, employeeId,name, masterSlaveType,additional);
    }
}
