package com.bcxin.rest.web.apis;

import com.bcxin.Infrastructures.exceptions.BadTenantException;
import com.bcxin.Infrastructures.exceptions.ForbidTenantException;
import com.bcxin.Infrastructures.exceptions.UnAuthorizedTenantException;
import com.bcxin.Infrastructures.utils.JwtUtil;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;
import org.springframework.util.StringUtils;

public class WebAppContext {
    private final static WebAppContext _instance = new WebAppContext();
    private final static ThreadLocal<AppContextData> _contextData = new ThreadLocal<>();

    private WebAppContext(){}
    public static WebAppContext getInstance() {
        return _instance;
    }

    public String getUserId() {
        return getAppContextData().getUserId();
    }

    public AppContextData.OrganizationData getSelectedOrgan() {
        AppContextData.OrganizationData organizationData =
                getAppContextData().getOrganization();
        if (organizationData == null) {
            throw new BadTenantException("找不到当前企业信息");
        }

        return organizationData;
    }

    public void initRequestOrgan(String organId,String name, String employeeId) {
        this.getAppContextData().updateCurrentOrgan(organId, name, employeeId);
    }

    public void resetRequestOrgan() {
        this.getAppContextData().updateCurrentOrgan(null, null,null);
    }

    public void initCurrentUser(String token) {
        if (!StringUtils.hasLength(token)) {
            throw new UnAuthorizedTenantException(String.format("Token(%s)无效", token));
        }

        try {
            String userId = JwtUtil.getUserIdFromToken(token);
            AppContextData data = getAppContextData();
            data.update(token, userId);

            _contextData.set(data);
        } catch (Exception ex) {
            ex.printStackTrace();

            throw new BadTenantException("Token初始化用户信息无效!", ex);
        }
    }

    private AppContextData getAppContextData() {
        AppContextData data = _contextData.get();
        if (data == null) {
            data = new AppContextData();
            _contextData.set(data);
        }

        return data;
    }

    @Getter
    @Setter(AccessLevel.PRIVATE)
    public static class AppContextData {
        private String userId;
        private String token;
        private OrganizationData organization;

        public void update(String token, String userId) {
            this.userId = userId;
            this.token = token;
        }

        public void updateCurrentOrgan(String id, String name, String employeeId) {
            if (this.organization == null) {
                this.organization = OrganizationData.create(id, name, employeeId);
            }

            this.organization.update(id, name, employeeId);
        }

        @Getter
        @Setter(AccessLevel.PRIVATE)
        public static class OrganizationData {
            private String id;
            private String name;
            private String employeeId;

            public OrganizationData(String id,String name, String employeeId) {
                this.id = id;
                this.employeeId = employeeId;
            }

            public static OrganizationData create(String id, String name,String employeeId) {
                return new OrganizationData(id, name, employeeId);
            }

            public void update(String organId,String name, String employeeId) {
                this.setEmployeeId(employeeId);
                this.setId(organId);
                this.setName(name);
            }
        }
    }
}
