package com.bcxin.rest.web.apis;

import com.bcxin.Infrastructures.components.ExcelProvider;
import com.bcxin.Infrastructures.components.WebFileProvider;
import com.bcxin.Infrastructures.utils.URLUtil;
import io.swagger.models.auth.In;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.stereotype.Component;

import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

@Component
public class ExtractDataComponent {
    private final WebFileProvider webFileProvider;
    private final ExcelProvider excelProvider;

    public ExtractDataComponent(WebFileProvider webFileProvider, ExcelProvider excelProvider) {
        this.webFileProvider = webFileProvider;
        this.excelProvider = excelProvider;
    }

    public <T> Collection<T> extract(int headRow, String path, Function<Collection<Map<Integer,String>>, Collection<T>> function) {
        String downloadUrl = URLUtil.decodeValue(path);
        InputStream reader = this.webFileProvider.download(downloadUrl);
        Map<String, Object> attributes = new HashMap<>();
        attributes.put(ExcelProvider.ATTRIBUTE_HEADER_ROW_COUNT, 2);
        Collection<Map<Integer, String>> excelMapValues = this.excelProvider.read(reader, attributes);

        return function.apply(excelMapValues);
    }
}
