/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.auth.quartz.controller;

import com.bcxin.auth.common.annotation.Log;
import com.bcxin.auth.common.core.controller.BaseController;
import com.bcxin.auth.common.core.domain.AjaxResult;
import com.bcxin.auth.common.core.page.TableDataInfo;
import com.bcxin.auth.common.enums.BusinessType;
import com.bcxin.auth.common.utils.StringUtils;
import com.bcxin.auth.common.utils.poi.ExcelUtil;
import com.bcxin.auth.quartz.domain.SysJob;
import com.bcxin.auth.quartz.domain.SysJobLog;
import com.bcxin.auth.quartz.service.ISysJobLogService;
import com.bcxin.auth.quartz.service.ISysJobService;
import java.util.List;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/monitor/jobLog"})
public class SysJobLogController
extends BaseController {
    private String prefix = "monitor/job";
    @Autowired
    private ISysJobService jobService;
    @Autowired
    private ISysJobLogService jobLogService;

    @RequiresPermissions(value={"monitor:job:view"})
    @GetMapping
    public String jobLog(@RequestParam(value="jobId", required=false) Long jobId, ModelMap mmap) {
        if (StringUtils.isNotNull((Object)jobId)) {
            SysJob job = this.jobService.selectJobById(jobId);
            mmap.put((Object)"job", (Object)job);
        }
        return this.prefix + "/jobLog";
    }

    @RequiresPermissions(value={"monitor:job:list"})
    @PostMapping(value={"/list"})
    @ResponseBody
    public TableDataInfo list(SysJobLog jobLog) {
        this.startPage();
        List<SysJobLog> list = this.jobLogService.selectJobLogList(jobLog);
        return this.getDataTable(list);
    }

    @Log(title="\u8c03\u5ea6\u65e5\u5fd7", businessType=BusinessType.EXPORT)
    @RequiresPermissions(value={"monitor:job:export"})
    @PostMapping(value={"/export"})
    @ResponseBody
    public AjaxResult export(SysJobLog jobLog) {
        List<SysJobLog> list = this.jobLogService.selectJobLogList(jobLog);
        ExcelUtil util = new ExcelUtil(SysJobLog.class);
        return util.exportExcel(list, "\u8c03\u5ea6\u65e5\u5fd7");
    }

    @Log(title="\u8c03\u5ea6\u65e5\u5fd7", businessType=BusinessType.DELETE)
    @RequiresPermissions(value={"monitor:job:remove"})
    @PostMapping(value={"/remove"})
    @ResponseBody
    public AjaxResult remove(String ids) {
        return this.toAjax(this.jobLogService.deleteJobLogByIds(ids));
    }

    @RequiresPermissions(value={"monitor:job:detail"})
    @GetMapping(value={"/detail/{jobLogId}"})
    public String detail(@PathVariable(value="jobLogId") Long jobLogId, ModelMap mmap) {
        mmap.put((Object)"name", (Object)"jobLog");
        mmap.put((Object)"jobLog", (Object)this.jobLogService.selectJobLogById(jobLogId));
        return this.prefix + "/detail";
    }

    @Log(title="\u8c03\u5ea6\u65e5\u5fd7", businessType=BusinessType.CLEAN)
    @RequiresPermissions(value={"monitor:job:remove"})
    @PostMapping(value={"/clean"})
    @ResponseBody
    public AjaxResult clean() {
        this.jobLogService.cleanJobLog();
        return this.success();
    }
}

