package com.bcxin.obpm.service.impl;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.auth.common.config.BMSConfig;
import com.bcxin.auth.common.constant.Constants;
import com.bcxin.auth.common.core.domain.AjaxResult;
import com.bcxin.auth.common.exception.V5BusinessException;
import com.bcxin.auth.common.utils.DateUtils;
import com.bcxin.auth.common.utils.StringUtils;
import com.bcxin.auth.system.domain.SysInterfaceLog;
import com.bcxin.auth.system.mapper.SysInterfaceLogMapper;
import com.bcxin.auth.system.util.ConfigUtil;
import com.bcxin.obpm.dto.*;
import com.bcxin.obpm.dto.beijing.PerInfoDto;
import com.bcxin.obpm.dto.beijing.PerInfoResult;
import com.bcxin.obpm.dto.beijing.Results;
import com.bcxin.obpm.dto.beijing.VerifyResult;
import com.bcxin.obpm.service.BackgroundService;
import com.bcxin.obpm.util.AuthConstants;
import com.bcxin.obpm.util.FaceUtil;
import com.github.pagehelper.util.StringUtil;
import com.google.common.collect.Maps;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.IOException;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 北京
 * @author linqinglin
 * @date 2021/08/19 0019 10:25
 */

@Service("backgroundService_110000")
public class BJBackgroundServiceImpl implements BackgroundService {

    private static Logger logger = LoggerFactory.getLogger(BJBackgroundServiceImpl.class);

    @Autowired
    private FaceUtil faceUtil;

    @Resource
    private ConfigUtil configUtil;

    @Autowired
    private SysInterfaceLogMapper sysInterfaceLogMapper;


    /**
     * 北京人员基本信息接口（无照片）
     */
    private final String BEIJING_PERSON_BASE_INFO_URL = "http://14.62.1.210:9006/zzxt/jk/helu/personBaseInfo";

    /**
     * 北京人员基本信息接口（有照片）
     */
    private final String BEIJING_PERSON_BASE_INFO_PHOTO_URL = "http://14.62.1.210:9006/zzxt/jk/rkk/ryhjglxxcx";


    /**
     * 北京检查库变更后url地址
     */
    private final String BEIJING_CHECK_PERSON_BASE_INFO_URL = "http://14.62.1.210:9006/zzxt/jk/helu/checkPersonBaseInfo";

    @Override
    public AjaxResult personnelReview(String idNumber, String realName) {
        if (StringUtils.isEmpty(idNumber)) {
            return AjaxResult.error("参数不正确");
        }
        List<BackgroundInfo> backgroundInfoList = new ArrayList<>();
        List<String> unRemind=configUtil.getUnRemindList();
        BackgroundResult backgroundResult = new BackgroundResult();
        //checkPersonInfo(backgroundInfoList,idNumber,unRemind);
        backgroundResult.setIdNumber(idNumber);
        backgroundResult.setCensorResult(backgroundInfoList);
        logger.info("身份证{}筛查结果:{}", idNumber, backgroundResult);
        // 请求
        return AjaxResult.success("请求成功", backgroundResult);
    }


    private void checkPersonInfo(List<BackgroundInfo> list, String idNumber,List<String> unRemind) {
        SysInterfaceLog interfaceLog=new SysInterfaceLog();
        Boolean isSuccessful = true;
        try {
            //请求参数
            Map<String, Object> paramMap = Maps.newHashMapWithExpectedSize(8);
            //mac地址 固定值
            paramMap.put(Constants.BEIJING_PARAM_DEVICE_ID, Constants.BEIJING_DEVICE_ID);
            //查询民警身份证号 固定值
            paramMap.put(Constants.BEIJING_PARAM_POLICE_IDENTITY_NUMBER, Constants.POLICESFZH);
            //查询民警姓名 固定值
            paramMap.put(Constants.BEIJING_PARAM_POLICE_NAME, Constants.POLICENAME);
            //被查询人员的身份证号
            paramMap.put(Constants.BEIJING_PARAM_BE_QUERIED_IDENTITY_NUMBER, idNumber);


            interfaceLog.setCreateTime(new Date());
            interfaceLog.setActive(true);
            interfaceLog.setUrl(BEIJING_CHECK_PERSON_BASE_INFO_URL);
            interfaceLog.setParameters(JSONObject.toJSONString(paramMap));

            //构建请求
            HttpResponse response = HttpUtil
                    .createRequest(Method.GET, BEIJING_CHECK_PERSON_BASE_INFO_URL)
                    .form(paramMap)
                    //设置三十秒超时时间
                    .timeout(Constants.TIMEOUT)
                    //需携带请求头uid 固定值
                    .header(Constants.BEIJING_HEADER_UID, Constants.BEIJING_HEADER_UID_VALUE)
                    //请求头username 固定值
                    .header(Constants.BEIJING_HEADER_USERNAME, Constants.BEIJING_HEADER_USERNAME_VALUE)
                    //请求头user pwd 固定值
                    .header(Constants.BEIJING_HEADER_USER_PWD, Constants.BEIJING_HEADER_USER_PWD_VALUE)
                    .execute();
            String result = response.body();
            interfaceLog.setResult(result);

            logger.error("身份证号:{},北京核查库返回数据:{}", idNumber, result);
            if (StringUtil.isNotEmpty(result)) {
                VerifyResult censorResult = JSONObject.parseObject(result, VerifyResult.class);
                if (censorResult.getStatus() != 0) {
                    throw new V5BusinessException("调用接口失败：".concat(censorResult.getMsg()));
                }
                List<Results> results = censorResult.getResults();
                if (results != null && !results.isEmpty()) {
                    //背景筛查原因列表
                    for (Results item : results) {
                        boolean help=false;
                        for (int i=0;i<unRemind.size();i++) {
                            String str=unRemind.get(i);
                            if (str.equals(item.getValue())){
                                help=true;
                                break;
                            }
                        }
                        if (help){
                            continue;
                        }
                        BackgroundInfo backgroundInfo = new BackgroundInfo();
                        Map<String, Object> wfMap = new HashMap<>();
                        wfMap.put("detail",item.getValue());
                        backgroundInfo.setCode(200);
                        backgroundInfo.setData(wfMap);
                        backgroundInfo.setResult(1);
                        backgroundInfo.setCxxt("核查库接口");
                        list.add(backgroundInfo);
                    }
                }
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            isSuccessful=false;
            interfaceLog.setResult(e.getMessage());
            throw new V5BusinessException("北京核查库调用异常！！");

        }finally {
            interfaceLog.setUpdateTime(new Date());
            interfaceLog.setSuccessful(isSuccessful);
            new Thread(()->{
                sysInterfaceLogMapper.insert(interfaceLog);
            }).start();
        }
    }

    @Override
    public AjaxResult getPersonnelInformation(String idNumber) {
        if (StringUtils.isEmpty(idNumber)) {
            return AjaxResult.error("参数不正确");
        }

        AuthenticationResult authenticationResult = new AuthenticationResult();
        authenticationResult.setIdNumber(idNumber);
        try {
            //请求参数
            Map<String, Object> paramMap = Maps.newHashMapWithExpectedSize(8);
            //mac地址 固定值
            paramMap.put(Constants.BEIJING_PARAM_DEVICE_ID, Constants.BEIJING_DEVICE_ID);
            //查询民警身份证号 固定值
            paramMap.put(Constants.BEIJING_PARAM_POLICE_IDENTITY_NUMBER, Constants.POLICESFZH);
            //查询民警姓名 固定值
            paramMap.put(Constants.BEIJING_PARAM_POLICE_NAME, Constants.POLICENAME);
            //被查询人员的身份证号
            paramMap.put(Constants.BEIJING_PARAM_BE_QUERIED_IDENTITY_NUMBER, idNumber);

            //构建请求
            HttpResponse response = HttpUtil
                    .createRequest(Method.GET,BEIJING_PERSON_BASE_INFO_URL)
                    .form(paramMap)
                    //设置三十秒超时时间
                    .timeout(Constants.TIMEOUT)
                    //需携带请求头uid 固定值
                    .header(Constants.BEIJING_HEADER_UID, Constants.BEIJING_HEADER_UID_VALUE)
                    //请求头username 固定值
                    .header(Constants.BEIJING_HEADER_USERNAME, Constants.BEIJING_HEADER_USERNAME_VALUE)
                    //请求头user pwd 固定值
                    .header(Constants.BEIJING_HEADER_USER_PWD, Constants.BEIJING_HEADER_USER_PWD_VALUE)
                    .execute();
            String result = response.body();


            logger.info("身份证号:{},北京人员基本信息接口返回数据:{}", idNumber, result);
            if (StringUtil.isNotEmpty(result)) {
                PerInfoResult perInfoResult = JSONObject.parseObject(result, PerInfoResult.class);
                List<PerInfoDto> results = perInfoResult.getResults();
                if (results != null && !results.isEmpty()) {
                    PerInfoDto perInfoDto = results.get(0);
                    authenticationResult.setRealName(perInfoDto.getName());
                    authenticationResult.setPhoto(getPhoto(idNumber, perInfoDto.getName()));
                }
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw new V5BusinessException("北京人员基本信息接口调用异常！！");

        }

        logger.info("{}人员信息服务返回:{}", idNumber, authenticationResult);
        return AjaxResult.success("请求成功", authenticationResult);

    }


    private PerPhotoDto getPopulationInfo(String idnum, String name) {
        PerPhotoDto person = new PerPhotoDto();
        SysInterfaceLog interfaceLog=new SysInterfaceLog();
        Boolean isSuccessful = true;
        person.setIdNum(idnum);
        try {
            //请求参数
            Map<String, Object> paramMap = Maps.newHashMapWithExpectedSize(8);
            //mac地址 固定值
            paramMap.put("device_id",Constants.BEIJING_DEVICE_ID);
            //查询民警身份证号 固定值
            paramMap.put("police_idcard", Constants.POLICESFZH);
            //查询民警姓名 固定值
            paramMap.put("police_name", Constants.POLICENAME);
            //被查询人员的身份证号
            paramMap.put("des_idcard", idnum);
            paramMap.put("des_name",name);
            logger.error("北京人员照片基本信息接口请求参数:{}", JSON.toJSONString(paramMap));
            logger.error("北京人员照片基本信息接口请求地址:{}", BEIJING_PERSON_BASE_INFO_PHOTO_URL);
            interfaceLog.setCreateTime(new Date());
            interfaceLog.setActive(true);
            interfaceLog.setUrl(BEIJING_PERSON_BASE_INFO_PHOTO_URL);
            interfaceLog.setParameters(JSONObject.toJSONString(paramMap));
            String result = postWithJson(BEIJING_PERSON_BASE_INFO_PHOTO_URL,paramMap);

            //logger.error("身份证号:{},北京人员照片基本信息接口返回数据:{}", idnum, result);
            if (StringUtils.isNotEmpty(result)) {
                JSONObject perInfoResult = JSONObject.parseObject(result);
                interfaceLog.setResult("返回编码："+perInfoResult.get("code").toString()+"，返回信息："+perInfoResult.get("msg").toString());
                    if ("0".equals(perInfoResult.get("code").toString())) {
                        if (perInfoResult.get("data") != null) {
                            try {
                                JSONArray perInfoArr = JSONArray.parseArray(JSON.toJSONString(perInfoResult.get("data")));
                                if (perInfoArr.size() > 0) {
                                    JSONObject perInfo = JSON.parseObject(JSON.toJSONString(perInfoArr.get(0)));
                                    person.setName(name);
                                    person.setPhoto(perInfo.get("XP").toString());
                                }
                            } catch (Exception e) {
                                logger.error(e.getMessage(), e);
                                logger.error("北京人员照片基本信息接口，返回数据无照片信息");
                            }
                        }
                    } else if (perInfoResult.get("msg") == null ||
                            !perInfoResult.get("msg").toString().contains("没有查询到相关信息")){
                        throw new V5BusinessException("北京人员照片基本信息接口返回异常!");
                    }
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            isSuccessful=false;
            interfaceLog.setResult(e.getMessage());
            throw new V5BusinessException("北京人员照片基本信息接口调用异常！！");
        }finally {
            interfaceLog.setUpdateTime(new Date());
            interfaceLog.setSuccessful(isSuccessful);
            new Thread(()->{
                sysInterfaceLogMapper.insert(interfaceLog);
            }).start();
        }
        if(StringUtils.isEmpty(person.getName())){
            person.setName(getName(idnum));
        }

        return person;

    }

    /***
     * 北京调用人口库方式
     * @param idNumber 身份证号
     * @return
     */
    private String getName(String idNumber){
        SysInterfaceLog interfaceLog=new SysInterfaceLog();
        Boolean isSuccessful = true;
        try {
            //请求参数
            Map<String, Object> paramMap = Maps.newHashMapWithExpectedSize(8);
            //mac地址 固定值
            paramMap.put("deviceid",Constants.BEIJING_DEVICE_ID);
            //查询民警身份证号 固定值
            paramMap.put("policesfzh", Constants.POLICESFZH);
            //查询民警姓名 固定值
            paramMap.put("policename", Constants.POLICENAME);
            paramMap.put("sfzh", idNumber);

            logger.error("身份证号:{},北京人员基本信息接口请求地址:{}", idNumber, BEIJING_PERSON_BASE_INFO_URL);
            logger.error("身份证号:{},北京人员基本信息接口请求参数:{}", idNumber, JSON.toJSONString(paramMap));
            //构建请求
            HttpResponse response = HttpUtil
                    .createRequest(Method.GET, BEIJING_PERSON_BASE_INFO_URL)
                    .form(paramMap)
                    //设置三十秒超时时间
                    .timeout(30000)
                    //需携带请求头uid 固定值
                    .header("uid", "1100002200000700")
                    .header("username", "baxt")
                    .header("userpwd", "Bzxt*bzxt")
                    .execute();
            interfaceLog.setCreateTime(new Date());
            interfaceLog.setActive(true);
            interfaceLog.setUrl(BEIJING_PERSON_BASE_INFO_URL);
            interfaceLog.setParameters(JSONObject.toJSONString(paramMap));
            String result = response.body();
            interfaceLog.setResult(result);
            logger.error("身份证号:{},北京人员基本信息接口返回数据:{}", idNumber, result);
            if (StringUtils.isNotEmpty(result)) {
                JSONObject perInfoResult = JSONObject.parseObject(result);
                Object results = perInfoResult.get("results");
                if (results != null) {
                    JSONArray perInfoArr = JSONArray.parseArray(JSON.toJSONString(results));
                    JSONObject perInfoDto = JSONObject.parseObject(JSON.toJSONString(perInfoArr.get(0)));

                    if(perInfoDto.get("name") != null) {
                        return perInfoDto.get("name").toString();
                    }
                }
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            isSuccessful=false;
            interfaceLog.setResult(e.getMessage());
            throw new V5BusinessException("北京人员基本信息接口调用异常！！");
        }finally {
            interfaceLog.setUpdateTime(new Date());
            interfaceLog.setSuccessful(isSuccessful);
            new Thread(()->{
                sysInterfaceLogMapper.insert(interfaceLog);
            }).start();
        }

        return StringUtils.EMPTY;
    }

    private String getPhoto(String idNumber, String name) {
        try {
            //请求参数
            Map<String, Object> paramMap = Maps.newHashMapWithExpectedSize(8);
            //mac地址 固定值
            paramMap.put("device_id", Constants.BEIJING_DEVICE_ID);
            //查询民警身份证号 固定值
            paramMap.put("police_idcard", Constants.POLICESFZH);
            //查询民警姓名 固定值
            paramMap.put("police_name", Constants.POLICENAME);
            //被查询人员的身份证号
            paramMap.put("des_idcard", idNumber);
            paramMap.put("des_name", name);

            logger.error("北京人员照片基本信息接口请求参数:{}", JSON.toJSONString(paramMap));
            logger.error("北京人员照片基本信息接口请求地址:{}", BEIJING_PERSON_BASE_INFO_PHOTO_URL);
            //第四步：发送HttpPost请求，获取返回值
            String result = postWithJson(BEIJING_PERSON_BASE_INFO_PHOTO_URL,paramMap); //调接口获取返回值时，必须用此方法

            logger.error("身份证号:{},北京人员照片基本信息接口返回数据:{}", idNumber, result);
            if (StringUtil.isNotEmpty(result)) {
                JSONObject perInfoResult = JSONObject.parseObject(result);
                if(perInfoResult.get("msg") != null && perInfoResult.get("msg").toString().equals("未授权的IP地址")){
                    throw new V5BusinessException("北京人员照片基本信息接口调用异常 -- 未授权的IP地址");
                }
                if(perInfoResult.get("data") != null){
                    JSONArray perInfoArr = JSONArray.parseArray(JSON.toJSONString(perInfoResult.get("data")));
                    if(perInfoArr.size() > 0) {
                        JSONObject perInfo = JSON.parseObject(JSON.toJSONString(perInfoArr.get(0)));
                        return perInfo.get("XP").toString();
                    }
                }
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw new V5BusinessException("北京人员照片基本信息接口调用异常！！");
        }

        return StrUtil.EMPTY;
    }

    @Override
    public List<AuthLog> validateResult(List<AuthLog> list) {
        for (AuthLog authLog : list) {
            try {
                this.matchResult(authLog);
                authLog.setAuthDate(DateUtils.getNowDate());
            } catch (Exception e) {
                e.printStackTrace();
            } finally {
            }
        }
        return list.stream().filter(((authLog)-> StrUtil.isNotEmpty(authLog.getAuthStatus()))).collect(Collectors.toList());
    }

    @Override
    public void getPersonnelAddress(String idNumber) {

    }


    private String postWithJson(String requestUrl, Map<String, Object> paramMap) throws Exception{
        String returnValue = StringUtils.EMPTY;
        CloseableHttpClient httpClient = HttpClients.createDefault();
        ResponseHandler<String> responseHandler = new BasicResponseHandler();
        try{
            //第一步：创建HttpClient对象
            httpClient = HttpClients.createDefault();
            //第二步：创建httpPost对象
            HttpPost httpPost = new HttpPost(requestUrl);

            RequestConfig.Builder requestConfig = RequestConfig.custom();
            requestConfig.setConnectTimeout(Constants.TIMEOUT);
            requestConfig.setConnectionRequestTimeout(Constants.TIMEOUT);
            requestConfig.setSocketTimeout(Constants.TIMEOUT);
            //第三步：给httpPost设置JSON格式的参数
            StringEntity requestEntity = new StringEntity(JSON.toJSONString(paramMap),"utf-8");
            requestEntity.setContentEncoding("UTF-8");
            httpPost.setHeader("Content-type", "application/json");
            httpPost.setHeader(Constants.BEIJING_HEADER_UID, Constants.BEIJING_HEADER_UID_VALUE);
            //请求头username 固定值
            httpPost.setHeader(Constants.BEIJING_HEADER_USERNAME, Constants.BEIJING_HEADER_USERNAME_VALUE);
            //请求头user pwd 固定值
            httpPost.setHeader(Constants.BEIJING_HEADER_USER_PWD, "Baxt*RKK");
            httpPost.setConfig(requestConfig.build());

            httpPost.setEntity(requestEntity);

            //第四步：发送HttpPost请求，获取返回值
            returnValue = httpClient.execute(httpPost,responseHandler); //调接口获取返回值时，必须用此方法
        }catch(Exception e){
            e.printStackTrace();
            throw e;
        }finally {
            try {
                httpClient.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        //第五步：处理返回值
        return returnValue;
    }


    /**
     * 实名认证比对
     * @param authLog
     * @throws IOException
     */
    public void matchResult(AuthLog authLog) throws IOException {
        try {
            /***2.2 获取人口库照片，base64，如果是互联网则获取本地图片，以身份证命名******/
            PerPhotoDto person = getPopulationInfo(authLog.getIdNumber(),authLog.getSecurityName());
            String xp = "";
            /**
             *  2.2.1获取姓名
             */
            String name = person.getName();
            /**
             * 2.2.2 判断姓名是否为空，如果为空，则人口库没有信息
             */
            if (StrUtil.isEmpty(name)) {
                //姓名和身份证不匹配
                authLog.setAuthStatus(AuthConstants.AUTHRESULT_NO);
                authLog.setAuthResult(AuthConstants.AUTHRESULT_NO_CARD_IDEMSG);
            } else if (name.equals(authLog.getSecurityName())) {
                /**
                 * 2.2.3 匹配姓名是否正常，如果匹配则获取照片信息，不匹配则返回
                 */
                //获取人口库照片
                xp = person.getPhoto();
                /***2.2.4 没有照片代码身份证和姓名不匹配**/
                if (StrUtil.isEmpty(xp)) {
                    authLog.setAuthStatus(AuthConstants.AUTHRESULT_NO);
                    authLog.setAuthResult(AuthConstants.AUTHRESULT_NO_PHOTO_IDEMSG);
                }
            } else {
                /***
                 * 2.2.4 姓名和身份证不匹配
                 */
                authLog.setAuthStatus(AuthConstants.AUTHRESULT_NO);
                authLog.setAuthResult(AuthConstants.AUTHRESULT_NO_NAME_IDEMSG);
            }

            /***
             * 2.3 如果有照片进行对比
             */
            if (StrUtil.isNotEmpty(xp)) {
                /***2.4 人口库和认证头像比对 **/
                if (xp.trim().startsWith("http")) {
                    logger.error("在线地址转base64");
                    String suffix = ".jpg";
                    if (!xp.matches(".*access_token.*")) {
                        suffix = xp.substring(xp.lastIndexOf("."));
                    }
                    String filePath = BMSConfig.getTempPath() + UUID.randomUUID().toString() + suffix;
                    faceUtil.downloadFile(xp, filePath);
                    xp = faceUtil.ImageToBase64(filePath);
                    FileUtil.del(filePath);
                }
                if (faceUtil.matchResult(xp, faceUtil.ImageToBase64(authLog.getImgPath()))) {
                    authLog.setAuthStatus(AuthConstants.AUTHRESULT_YES);
                    authLog.setAuthResult(AuthConstants.AUTHRESULT_YES_MESSAGE);
                } else {
                    authLog.setAuthStatus(AuthConstants.AUTHRESULT_NO);
                    authLog.setAuthResult(AuthConstants.AUTHRESULT_NO_IMGMSG);
                }
            }
            authLog.setAuthDate(DateUtils.getNowDate());
        } catch (Exception e) {
            authLog.setAuthStatus(AuthConstants.AUTHRESULT_ZHONG);
            authLog.setAuthResult("比对接口异常！！");
            e.printStackTrace();
        }

    }
}
