package com.bcxin.obpm.schedule;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.auth.system.util.ConfigUtil;
import com.bcxin.obpm.dto.hunanAuth.*;
import com.bcxin.obpm.util.HttpClientUtil;
import com.bcxin.obpm.util.ImageProcessEnding;
import com.bcxin.obpm.util.SRRZUtilEnding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component("huNanAuthTask")
public class HuNanAuthTask {
    private static Logger logger = LoggerFactory.getLogger(HuNanAuthTask.class);

    private boolean lock = false;

    @Autowired
    ConfigUtil configUtil;

    public void run(){
        if (configUtil.isHNAuth()){
            this.authResult();
        }else {
            logger.error("环境不对");
        }
    }

    //判断环境代码
    public  void  authResult(){
        if (lock){
            return;
        }
        lock = true;

        Map<String, String> headMap = new HashMap<>();
        headMap.put("Authorization",SRRZUtilEnding.AUTH_TOKEN);
        try {
            logger.error("==============开始认证=================");
            //1、调用智能人事接口，获取为认证的数据
            //1.1获取数据的接口
            Map<String,Object> param = new HashMap<>();
            param.put("region",SRRZUtilEnding.DATA_FROM);
            String paramJson = JSON.toJSONString(param);
            String getReturn= HttpClientUtil.doPostJson(SRRZUtilEnding.GET_AUTH_DATA_URL,paramJson,headMap);
            //2.解析获取的数据
            JSONObject jsonObject = JSON.parseObject(getReturn);
            ZhiNenRenShiReturn zhiNenRenShiReturn = jsonObject.toJavaObject(jsonObject, ZhiNenRenShiReturn.class);
            if (zhiNenRenShiReturn.getStatus() == 200){
                //拿到认证的数据
                List<SecurityMan> securityMEN = JSON.parseArray(zhiNenRenShiReturn.getData(), SecurityMan.class);
                logger.error("取得未认证数据："+securityMEN.size());
                if (!securityMEN.isEmpty()){
                    for (SecurityMan securityMAN : securityMEN) {
                        //认证后返回到智能人事的数据
                        List<UpdateTenantUserRealNameRequest> list = new ArrayList<>();
                        UpdateTenantUserRealNameRequest updateTenantUserRealNameRequest = new UpdateTenantUserRealNameRequest();
                        //处理图片路径
                        String imgPathHandle = SRRZUtilEnding.imgPathHandle(securityMAN.getOneInchColorWhitePhoto());
                        //判断图片地址是否存在
                        logger.error("判断照片是否正常"+securityMAN.getNumber());
                        String imagesTrue = HttpClientUtil.isImagesTrue(imgPathHandle);
                        if (!imagesTrue.equals("200")){
                            updateTenantUserRealNameRequest.setNumber(securityMAN.getNumber());
                            updateTenantUserRealNameRequest.setStatus(2);
                            updateTenantUserRealNameRequest.setResult("认证失败,图片地址不存在或者图片受损，请重新上传");
                            list.add(updateTenantUserRealNameRequest);
                            logger.error(securityMAN.getNumber()+"开始返回数据到智能人事");
                            String s1 = HttpClientUtil.doPostJson(SRRZUtilEnding.UPDATE_AUTH_DATA_URL, JSON.toJSONString(list), headMap);
                            //解析返回的数据
                            this.parseJSON(s1);
                            continue;
                        }
                        //从网络将图片转换成字节数组
                        byte[] imgUrlToByte = ImageProcessEnding.getImgUrlToByte(imgPathHandle);
                        //图片压缩，返回byte[]数组
                        if(imgUrlToByte == null){
                            updateTenantUserRealNameRequest.setNumber(securityMAN.getNumber());
                            updateTenantUserRealNameRequest.setResult("图片地址不存在或者图片受损，请重新上传");
                            updateTenantUserRealNameRequest.setStatus(2);
                            list.add(updateTenantUserRealNameRequest);
                            //实人认证完毕，将数据封装好发给智能人事的更新接口
                            logger.error(securityMAN.getNumber()+"开始返回数据到智能人事");
                            String updateReturn = HttpClientUtil.doPostJson(SRRZUtilEnding.UPDATE_AUTH_DATA_URL, JSON.toJSONString(list), headMap);
                            //解析返回的数据
                            this.parseJSON(updateReturn);
                            continue;
                        }
                        byte[] bytes = ImageProcessEnding.compressImage(imgUrlToByte, 100);
                        //图片进行压缩处理后的base64编码
                        String processAfterBase = ImageProcessEnding.ImageByteToBaseCode(bytes);
                        //调用实人认证接口
                        //封装认证参数
                        String srrzJson = SRRZUtilEnding.authUtil(securityMAN, processAfterBase);
                        if (srrzJson != null){
                            logger.error(securityMAN.getNumber()+"正在认证");
                            //调用实人认证的接口
                            String authReturn = HttpClientUtil.doPostJson(SRRZUtilEnding.AUTH_URL, srrzJson);
                            logger.error(authReturn);
                            JSONObject jsonObject1 = JSON.parseObject(authReturn);
                            ShiRenReturn aShiRenReturn = jsonObject1.toJavaObject(ShiRenReturn.class);
                            if ("200".equals(aShiRenReturn.getStatus())){
                                logger.error("实人认证接口调用返回编码:"+aShiRenReturn.getStatus());
                                String msg = aShiRenReturn.getMsg();
                                JSONObject msgJson = JSON.parseObject(msg);
                                ShiRenReturn msgReturn = msgJson.toJavaObject(ShiRenReturn.class);
                                JSONObject dataObject = JSON.parseObject(msgReturn.getData());
                                ShiRenReturn2 shiRenReturn2 = dataObject.toJavaObject(ShiRenReturn2.class);
                                if ("00XX".equals(shiRenReturn2.getResStr())){
                                    logger.error(securityMAN.getNumber()+"认证成功");
                                    updateTenantUserRealNameRequest.setNumber(securityMAN.getNumber());
                                    updateTenantUserRealNameRequest.setResult("认证成功");
                                    updateTenantUserRealNameRequest.setStatus(3);
                                }else if ("55XX".equals(shiRenReturn2.getResStr())){
                                    updateTenantUserRealNameRequest.setNumber(securityMAN.getNumber());
                                    updateTenantUserRealNameRequest.setResult("身份信息不存在或者身份信息不匹配，请检查身份信息");
                                    updateTenantUserRealNameRequest.setStatus(2);
                                }else if ("66XX".equals(shiRenReturn2.getResStr())){
                                    updateTenantUserRealNameRequest.setNumber(securityMAN.getNumber());
                                    updateTenantUserRealNameRequest.setResult("身份信息格式，请检查身份信息");
                                    updateTenantUserRealNameRequest.setStatus(2);
                                }else {
                                    updateTenantUserRealNameRequest.setNumber(securityMAN.getNumber());
                                    updateTenantUserRealNameRequest.setResult("认证失败，认证信息不正确.请检查身份信息");
                                    updateTenantUserRealNameRequest.setStatus(2);
                                }
                                list.add(updateTenantUserRealNameRequest);
                            }else {
                                logger.error("认证接口调用失败===================================");
                            }
                        }
                        if (!list.isEmpty()){
                            //实人认证完毕，将数据封装好发给智能人事的更新接口
                            logger.error(securityMAN.getNumber()+"开始返回数据到智能人事");
                            String s1 = HttpClientUtil.doPostJson(SRRZUtilEnding.UPDATE_AUTH_DATA_URL, JSON.toJSONString(list), headMap);
                            //解析返回的数据
                            this.parseJSON(s1);
                        }
                    }
                }
            }else{
                logger.error("调用智能人事接口失败++++++++++");
            }
        }catch (Exception e){
            logger.error(e.getMessage());
        }finally {
            lock = false;
        }
    }
    public void parseJSON(String updateReturn){
        JSONObject jsonObject = JSON.parseObject(updateReturn);
        ZhiNenRenShiReturn updateReturn1 = jsonObject.toJavaObject(ZhiNenRenShiReturn.class);
        if (200==updateReturn1.getStatus()){
            logger.error("数据成功返回到智能人事");
        }
    }

}
