package com.bcxin.obpm.ministerial;


import com.bcxin.obpm.annotation.MinisterialAttr;
import org.springframework.stereotype.Component;

import java.lang.reflect.Field;

/**
 * @author zhangyutong
 */
@Component
public class PoliceOrgCodeMinDataFormatStrategy implements MinDataFormatStrategy {
    @Override
    public String format(Field columnField, Object data) {
        if(data == null){
            MinisterialAttr resource = columnField.getAnnotation(MinisterialAttr.class);
            return resource.defaultValue();
        }
        String code = (String) data;
        if (data != null && code.length() == 2) {
            code += "0000000000";
        }
        return code;
    }
}
