package com.bcxin.obpm.ministerial;

import org.springframework.stereotype.Component;

import java.lang.reflect.Field;

/**
 * 管理层证件类型
 * @author zhangyutong
 */
@Component
public class ManagerMinDataFormatStrategy implements MinDataFormatStrategy {
    @Override
    public String format(Field columnField, Object data) {
        if (data == null) {
            return "01";
        }
        /*
         * 01: 居民身份证； 03: 护照；
         * 04: 往来港澳通行证；
         * 05: 台湾居民来往大陆通行证
         */
        switch (String.valueOf(data)) {
            case "8" :
                return "03";
            case "4" :
            case "5" :
                return "04";
            case "6" :
                return "05";
            default:
                return "01";
        }
    }
}
