package com.bcxin.obpm.dto.Ministerial;

import com.bcxin.obpm.annotation.MinisterialAttr;
import com.bcxin.obpm.annotation.MinisterialEntity;
import lombok.Data;

/**
 * 保安服务公司分公司主要管理人员信息上报实体类
 *
 * @author Wangjianchi
 */
@Data
@MinisterialEntity(tableName = "tlk_ManagementLayer", extraWhere = "and t1.ITEM_DOMAIN_ID in (select tlk_companyinformation.ITEM_DOMAIN_ID from tlk_companyinformation where item_officeType in ('0102','保安服务公司') and ITEM_isSub in ('2','3'))")
public class Bafwgsfgsglry extends XxbaBaseDto {
    /**
     * 保安服务公司编码
     */
    @MinisterialAttr(column = "(select item_companyCode from tlk_companyinformation where tlk_companyinformation.item_domain_id = t1.item_domain_id limit 1)", isSubQuery = true)
    private String bagsbm;
    /**
     * 分公司名称
     */
    @MinisterialAttr(column = "(select ITEM_companyName from tlk_companyinformation where tlk_companyinformation.item_domain_id = t1.item_domain_id limit 1)", isSubQuery = true)
    private String fgsmc;
    /**
     * 公民身份号码
     */
    @MinisterialAttr(column = "ITEM_documentID")
    private String sfzh;
    /**
     * 姓名
     */
    @MinisterialAttr(column = "ITEM_name")
    private String xm;
    /**
     * 联系电话
     */
    @MinisterialAttr(column = "ITEM_phone")
    private String lxdh;
    /**
     * 备案公安机关编码
     */
    private String bagajgbm;
    /**
     * 备案公安机关名称
     */
    private String bagajgmc;
    /**
     * 备案日期
     */
    private String barq;
    /**
     * 职务
     */
    private String zw;
    /**
     * 备注1
     */
    private String bz1;
    /**
     * 备注2
     */
    private String bz2;
    /**
     * 备注3
     */
    private String bz3;


    /**
     * 证件类型
     */
    @MinisterialAttr(column = "ifnull(ITEM_documentType,1)", isSubQuery = true, DATA_FORMAT = MinisterialDataFormat.MANAGER_CARD_TYPE)
    private String zjlx;

    /**
     * 总公司保安服务许可证号
     */
    @MinisterialAttr(column = "(select sc2.ITEM_securityServicePermitNo from tlk_companyinformation sc2 where  sc2.item_domain_id = t1.item_domain_id limit 1)", isSubQuery = true)
    private String bafwxkz;


}
