package com.bcxin.obpm.dto;

import lombok.Data;

import java.io.Serializable;

@Data
public class AuthAjaxResult implements Serializable {

	private static final long serialVersionUID = 4530474987109938356L;

	private boolean successful;
	private String code;
	private String msg;
	private Object data;


	public AuthAjaxResult(){

	}

	public AuthAjaxResult(boolean successful, String msg){
		this.successful = successful;
		this.msg = msg;
	}

	public AuthAjaxResult(boolean successful, String msg, Object data){
		this.successful = successful;
		this.msg = msg;
		this.data = data;
	}

	public static AuthAjaxResult success(String msg){
		return new AuthAjaxResult(true,msg);
	}

	public static AuthAjaxResult error(String msg){
		return new AuthAjaxResult(false,msg);
	}

}
