package com.bcxin.auth.system.util;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.auth.base.dto.SAASResultDto;
import com.bcxin.auth.common.constant.Constants;
import com.bcxin.auth.system.domain.DataSyncLog;
import com.bcxin.auth.system.domain.SysInterfaceLog;
import com.bcxin.auth.system.dto.datasync.DataSyncDto;
import com.bcxin.auth.system.mapper.SysInterfaceLogMapper;
import com.bcxin.obpm.dto.AuthAjaxResult;
import com.github.pagehelper.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.Map;

/**
 * 调接口工具类
 * @author linqinglin
 * @date 2019/04/23 0023 15:14
 */
@Component
public class DataSyncInterfaceUtil {

    private static Logger logger = LoggerFactory.getLogger(DataSyncInterfaceUtil.class);

    @Autowired
    private SysInterfaceLogMapper interfaceLogMapper;

    @Autowired
    private ConfigUtil configUtil;



    /**
     * 调saas接口
     * @param url 接口地址
     * @param dataSyncLog 传参
     */
    public AuthAjaxResult callInterface(String url , DataSyncLog dataSyncLog){

        DataSyncDto dataSyncDto = new DataSyncDto();
        dataSyncDto.setRegionId(configUtil.getCurrentProvince());
        dataSyncDto.setBusinessId(dataSyncLog.getId()+"");
        dataSyncDto.setData(JSON.toJSONString(dataSyncLog));
        dataSyncDto.setTargetServiceUrl(Constants.DATASYNC_RECEIVE_URL);
        dataSyncDto.setCallbackUrl(configUtil.getTimeUrl()+Constants.DATASYNC_CALLBACK_URL);
        dataSyncDto.setSrcApp(configUtil.getTimeUrl());
        dataSyncDto.setTargetApp(configUtil.getTargetTimeUrl());
        dataSyncDto.setFileUrls(configUtil.getTimeUrl()+dataSyncLog.getUrl());


        Map<String,Object> paramMap = BeanUtil.beanToMap(dataSyncDto);

        String msg = StrUtil.EMPTY;
        Boolean result = true;
        Object data = null;
        //获取对接地址

        url = configUtil.getDataSyncFtpUrl() + url;

        SysInterfaceLog interfaceLog = new SysInterfaceLog();
        interfaceLog.setCreateTime(new Date());
        interfaceLog.setUrl(url);
        interfaceLog.setActive(true);
        interfaceLog.setParameters(JSONObject.toJSONString(paramMap));

        try {
            logger.error("请求地址:{}",url);
            logger.error("请求参数:{}",JSON.toJSONString(paramMap));
            //获取结果
            String resultStr = HttpUtil.post(url, paramMap,30000);
            logger.error("返回结果:{}",resultStr);
            interfaceLog.setResult(resultStr);

            SAASResultDto resultDto = JSONObject.parseObject(resultStr, SAASResultDto.class);
            if(resultDto != null && StringUtil.isNotEmpty(resultDto.getRetType())) {
                String retType = resultDto.getRetType();
                if (Constants.N.equals(retType)) {
                    data = resultDto.getData();
                    logger.info("调用FTP同步服务成功");
                } else {
                    result = false;
                    //错误信息
                    msg =  resultDto.getMsg();
                    logger.error(resultStr);
                    logger.info("调用FTP同步服务失败");
                }
            }else{
                result = false;
                msg =  "没有返回结果";
                logger.info("调用FTP同步服务失败,没有返回结果");
            }
        }catch (Exception e){
            result = false;
            logger.error(e.getMessage(),e);
            msg = e.getMessage();
            interfaceLog.setResult(e.getMessage());
        }finally {
            interfaceLog.setUpdateTime(new Date());
            interfaceLog.setSuccessful(result);
            /**
             * 异步保存
             */
            new Thread(()->{
                interfaceLogMapper.insert(interfaceLog);
            }).start();

            if(StringUtil.isNotEmpty(msg)){
                msg = "调用FTP同步服务失败:" + msg;
            }
        }
        return new AuthAjaxResult(result,msg,data);
    }

}
