
CREATE TABLE `com_grant_record_detail` (
  `comGrantRecordDetailId` bigint(20) NOT NULL COMMENT '企业发放记录明细ID',
  `comGrantRecordId` bigint(20) NOT NULL COMMENT '企业发放记录ID',
  `comGrantDetailId` bigint(20) NOT NULL COMMENT '企业发放单明细ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  PRIMARY KEY (`comGrantRecordDetailId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='企业发放记录明细';

CREATE TABLE `config_bank_outlets` (
  `id` int(5) NOT NULL COMMENT '主键',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `bankCode` varchar(20) NOT NULL COMMENT '银行编码',
  `bankOutlets` varchar(50) DEFAULT NULL COMMENT '银行网点',
  `areaName` varchar(50) DEFAULT NULL COMMENT '区域',
  `area` int(6) DEFAULT NULL COMMENT '区域代码',
  `bankAddress` varchar(100) DEFAULT NULL COMMENT '银行地址',
  `addressLongitude` varchar(50) DEFAULT NULL COMMENT '经度',
  `addressLatitude` varchar(50) DEFAULT NULL COMMENT '纬度',
  `contactPhone` varchar(30) DEFAULT NULL COMMENT '联系电话',
  `businessHours` varchar(20) DEFAULT NULL COMMENT '营业时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='银行网点配置表';

CREATE TABLE `config_bank_outlets_work_day` (
  `id` int(5) NOT NULL COMMENT '主键',
  `bankOutletsId` int(5) NOT NULL COMMENT '银行网点ID',
  `weekDay` int(1) DEFAULT NULL COMMENT '星期几',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='银行网点工作日配置表';

CREATE TABLE `config_bank_outlets_work_day_time_period` (
  `id` int(5) NOT NULL COMMENT '主键',
  `bankOutletsWorkDayId` int(5) DEFAULT NULL COMMENT '银行网点工作日ID',
  `startTime` time DEFAULT NULL COMMENT '开始时间',
  `endTime` time DEFAULT NULL COMMENT '结束时间',
  `maxPerNum` int(3) DEFAULT NULL COMMENT '人数上限',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='银行网点工作日时间段人数上限配置表';

CREATE TABLE `per_bank_outlets_appointment` (
  `perId` bigint(20) NOT NULL COMMENT '人员ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人',
  `appointmentDate` date DEFAULT NULL COMMENT '预约日期',
  `bankOutletsWorkDayTimePeriodId` int(5) NOT NULL COMMENT '银行网点工作日人数上限配置ID',
  PRIMARY KEY (`perId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='人员银行网点预约';

CREATE TABLE `per_jointly_card` (
  `perId` bigint(20) NOT NULL COMMENT '人员ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `isActive` varchar(1) DEFAULT NULL COMMENT '是否激活',
  `activeTime` varchar(20) DEFAULT NULL COMMENT '激活时间',
  `openCardTime` varchar(20) DEFAULT NULL COMMENT '开卡时间',
  `bankCode` varchar(20) DEFAULT NULL COMMENT '银行编码',
  `bankOutlets` varchar(50) DEFAULT NULL COMMENT '银行网点',
  `bankAccountType` varchar(6) DEFAULT NULL COMMENT '银行账户类型',
  `bankNo` varchar(50) DEFAULT NULL COMMENT '银行行号',
  `bankCardNo` varchar(30) DEFAULT NULL COMMENT '银行卡号',
  `bankAccountStatus` varchar(6) DEFAULT NULL COMMENT '银行账户状态',
  `cancelTime` varchar(20) DEFAULT NULL COMMENT '注销时间',
  `cancelReason` varchar(50) DEFAULT NULL COMMENT '注销原因',
  PRIMARY KEY (`perId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='人员联名卡';


-- ----------------------------
-- Table structure for config_industry_dict
-- ----------------------------
DROP TABLE IF EXISTS `config_industry_dict`;
CREATE TABLE `config_industry_dict` (
  `industryDictId` int(20) NOT NULL COMMENT '行业代码条目ID',
  `industryType` varchar(6) DEFAULT NULL COMMENT '行业类型',
  `institutionType` varchar(6) DEFAULT NULL COMMENT '机构类型',
  `codeType` varchar(30) DEFAULT NULL COMMENT '代码类型',
  `description` varchar(255) DEFAULT NULL COMMENT '代码中文描述',
  `codeValue` varchar(8) DEFAULT NULL COMMENT '代码值',
  `label` varchar(30) DEFAULT NULL COMMENT '代码值中文描述',
  `seq` int(2) DEFAULT NULL COMMENT '排序',
  PRIMARY KEY (`industryDictId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='行业字典表';

-- ----------------------------
-- Records of config_industry_dict
-- ----------------------------
INSERT INTO `config_industry_dict` VALUES ('1', '01', '0101', 'perType', '人员类型', '010001', '普通保安员', '1');
INSERT INTO `config_industry_dict` VALUES ('2', '01', '0101', 'perType', '人员类型', '010002', '武装押运人员', '2');
INSERT INTO `config_industry_dict` VALUES ('3', '01', '0101', 'perType', '人员类型', '010003', '内勤人员', '3');
INSERT INTO `config_industry_dict` VALUES ('4', '01', '0102', 'perType', '人员类型', '010001', '普通保安员', '1');
INSERT INTO `config_industry_dict` VALUES ('5', '01', '0102', 'perType', '人员类型', '010002', '武装押运人员', '2');
INSERT INTO `config_industry_dict` VALUES ('6', '01', '0102', 'perType', '人员类型', '010003', '内勤人员', '3');
INSERT INTO `config_industry_dict` VALUES ('7', '01', '0103', 'perType', '人员类型', '010001', '普通保安员', '1');
INSERT INTO `config_industry_dict` VALUES ('8', '01', '0103', 'perType', '人员类型', '010002', '武装押运人员', '2');
INSERT INTO `config_industry_dict` VALUES ('9', '01', '0103', 'perType', '人员类型', '010003', '内勤人员', '3');
INSERT INTO `config_industry_dict` VALUES ('10', '01', '0104', 'perType', '人员类型', '010001', '普通保安员', '1');
INSERT INTO `config_industry_dict` VALUES ('11', '01', '0104', 'perType', '人员类型', '010002', '武装押运人员', '2');
INSERT INTO `config_industry_dict` VALUES ('12', '01', '0104', 'perType', '人员类型', '010003', '内勤人员', '3');
INSERT INTO `config_industry_dict` VALUES ('13', '01', '0101', 'perCerType', '人员证书类型', '010001', '保安员等级证', '1');
INSERT INTO `config_industry_dict` VALUES ('14', '01', '0101', 'perCerType', '人员证书类型', '010002', '保安员资格证', '2');
INSERT INTO `config_industry_dict` VALUES ('15', '01', '0101', 'perCerType', '人员证书类型', '010003', '持枪证', '3');
INSERT INTO `config_industry_dict` VALUES ('16', '01', '0102', 'perCerType', '人员证书类型', '010001', '保安员等级证', '1');
INSERT INTO `config_industry_dict` VALUES ('17', '01', '0102', 'perCerType', '人员证书类型', '010002', '保安员资格证', '2');
INSERT INTO `config_industry_dict` VALUES ('18', '01', '0102', 'perCerType', '人员证书类型', '010003', '持枪证', '3');
INSERT INTO `config_industry_dict` VALUES ('19', '01', '0103', 'perCerType', '人员证书类型', '010001', '保安员等级证', '1');
INSERT INTO `config_industry_dict` VALUES ('20', '01', '0103', 'perCerType', '人员证书类型', '010002', '保安员资格证', '2');
INSERT INTO `config_industry_dict` VALUES ('21', '01', '0103', 'perCerType', '人员证书类型', '010003', '持枪证', '3');
INSERT INTO `config_industry_dict` VALUES ('22', '01', '0104', 'perCerType', '人员证书类型', '010001', '保安员等级证', '1');
INSERT INTO `config_industry_dict` VALUES ('23', '01', '0104', 'perCerType', '人员证书类型', '010002', '保安员资格证', '2');
INSERT INTO `config_industry_dict` VALUES ('24', '01', '0104', 'perCerType', '人员证书类型', '010003', '持枪证', '3');
INSERT INTO `config_industry_dict` VALUES ('25', '01', '0101', 'jobSkillLevel', '职业技能等级', '010001', '初级保安员', '1');
INSERT INTO `config_industry_dict` VALUES ('26', '01', '0101', 'jobSkillLevel', '职业技能等级', '010002', '中级保安员', '2');
INSERT INTO `config_industry_dict` VALUES ('27', '01', '0101', 'jobSkillLevel', '职业技能等级', '010003', '高级保安员', '3');
INSERT INTO `config_industry_dict` VALUES ('28', '01', '0101', 'jobSkillLevel', '职业技能等级', '010004', '保安师', '4');
INSERT INTO `config_industry_dict` VALUES ('29', '01', '0101', 'jobSkillLevel', '职业技能等级', '010005', '高级保安管理员', '5');
INSERT INTO `config_industry_dict` VALUES ('30', '01', '0102', 'jobSkillLevel', '职业技能等级', '010001', '初级保安员', '1');
INSERT INTO `config_industry_dict` VALUES ('31', '01', '0102', 'jobSkillLevel', '职业技能等级', '010002', '中级保安员', '2');
INSERT INTO `config_industry_dict` VALUES ('32', '01', '0102', 'jobSkillLevel', '职业技能等级', '010003', '高级保安员', '3');
INSERT INTO `config_industry_dict` VALUES ('33', '01', '0102', 'jobSkillLevel', '职业技能等级', '010004', '保安师', '4');
INSERT INTO `config_industry_dict` VALUES ('34', '01', '0102', 'jobSkillLevel', '职业技能等级', '010005', '高级保安管理员', '5');
INSERT INTO `config_industry_dict` VALUES ('35', '01', '0103', 'jobSkillLevel', '职业技能等级', '010001', '初级保安员', '1');
INSERT INTO `config_industry_dict` VALUES ('36', '01', '0103', 'jobSkillLevel', '职业技能等级', '010002', '中级保安员', '2');
INSERT INTO `config_industry_dict` VALUES ('37', '01', '0103', 'jobSkillLevel', '职业技能等级', '010003', '高级保安员', '3');
INSERT INTO `config_industry_dict` VALUES ('38', '01', '0103', 'jobSkillLevel', '职业技能等级', '010004', '保安师', '4');
INSERT INTO `config_industry_dict` VALUES ('39', '01', '0103', 'jobSkillLevel', '职业技能等级', '010005', '高级保安管理员', '5');
INSERT INTO `config_industry_dict` VALUES ('40', '01', '0104', 'jobSkillLevel', '职业技能等级', '010001', '初级保安员', '1');
INSERT INTO `config_industry_dict` VALUES ('41', '01', '0104', 'jobSkillLevel', '职业技能等级', '010002', '中级保安员', '2');
INSERT INTO `config_industry_dict` VALUES ('42', '01', '0104', 'jobSkillLevel', '职业技能等级', '010003', '高级保安员', '3');
INSERT INTO `config_industry_dict` VALUES ('43', '01', '0104', 'jobSkillLevel', '职业技能等级', '010004', '保安师', '4');
INSERT INTO `config_industry_dict` VALUES ('44', '01', '0104', 'jobSkillLevel', '职业技能等级', '010005', '高级保安管理员', '5');
INSERT INTO `config_industry_dict` VALUES ('65', '01', '0101', 'serviceType', '服务类型', '010001', '技防', '1');
INSERT INTO `config_industry_dict` VALUES ('66', '01', '0101', 'serviceType', '服务类型', '010002', '人防', '2');
INSERT INTO `config_industry_dict` VALUES ('67', '01', '0101', 'serviceType', '服务类型', '010003', '随身护卫', '3');
INSERT INTO `config_industry_dict` VALUES ('68', '01', '0101', 'serviceType', '服务类型', '010004', '安全检查', '4');
INSERT INTO `config_industry_dict` VALUES ('69', '01', '0101', 'serviceType', '服务类型', '010009', '其他', '9');
INSERT INTO `config_industry_dict` VALUES ('70', '01', '0102', 'serviceType', '服务类型', '010001', '技防', '1');
INSERT INTO `config_industry_dict` VALUES ('71', '01', '0102', 'serviceType', '服务类型', '010002', '人防', '2');
INSERT INTO `config_industry_dict` VALUES ('72', '01', '0102', 'serviceType', '服务类型', '010003', '随身护卫', '3');
INSERT INTO `config_industry_dict` VALUES ('73', '01', '0102', 'serviceType', '服务类型', '010004', '安全检查', '4');
INSERT INTO `config_industry_dict` VALUES ('74', '01', '0102', 'serviceType', '服务类型', '010009', '其他', '9');
INSERT INTO `config_industry_dict` VALUES ('75', '01', '0103', 'serviceType', '服务类型', '010001', '技防', '1');
INSERT INTO `config_industry_dict` VALUES ('76', '01', '0103', 'serviceType', '服务类型', '010002', '人防', '2');
INSERT INTO `config_industry_dict` VALUES ('77', '01', '0103', 'serviceType', '服务类型', '010003', '随身护卫', '3');
INSERT INTO `config_industry_dict` VALUES ('78', '01', '0103', 'serviceType', '服务类型', '010004', '安全检查', '4');
INSERT INTO `config_industry_dict` VALUES ('79', '01', '0103', 'serviceType', '服务类型', '010009', '其他', '9');
INSERT INTO `config_industry_dict` VALUES ('80', '01', '0104', 'serviceType', '服务类型', '010001', '技防', '1');
INSERT INTO `config_industry_dict` VALUES ('81', '01', '0104', 'serviceType', '服务类型', '010002', '人防', '2');
INSERT INTO `config_industry_dict` VALUES ('82', '01', '0104', 'serviceType', '服务类型', '010003', '随身护卫', '3');
INSERT INTO `config_industry_dict` VALUES ('83', '01', '0104', 'serviceType', '服务类型', '010004', '安全检查', '4');
INSERT INTO `config_industry_dict` VALUES ('84', '01', '0104', 'serviceType', '服务类型', '010009', '其他', '9');
INSERT INTO `config_industry_dict` VALUES ('85', '01', '0105', 'serviceType', '服务类型', '010001', '技防', '1');
INSERT INTO `config_industry_dict` VALUES ('86', '01', '0105', 'serviceType', '服务类型', '010002', '人防', '2');
INSERT INTO `config_industry_dict` VALUES ('87', '01', '0105', 'serviceType', '服务类型', '010003', '随身护卫', '3');
INSERT INTO `config_industry_dict` VALUES ('88', '01', '0105', 'serviceType', '服务类型', '010004', '安全检查', '4');
INSERT INTO `config_industry_dict` VALUES ('89', '01', '0105', 'serviceType', '服务类型', '010009', '其他', '9');
INSERT INTO `config_industry_dict` VALUES ('90', '01', '0105', 'perType', '人员类型', '010001', '普通保安员', '1');
INSERT INTO `config_industry_dict` VALUES ('91', '01', '0105', 'perType', '人员类型', '010002', '武装押运人员', '2');
INSERT INTO `config_industry_dict` VALUES ('92', '01', '0105', 'perType', '人员类型', '010003', '内勤人员', '3');
INSERT INTO `config_industry_dict` VALUES ('93', '02', '0201', 'perType', '人员类型', '020001', '普通职员', '1');
INSERT INTO `config_industry_dict` VALUES ('94', '02', '0201', 'perType', '人员类型', '020102', '结算人员', '2');
INSERT INTO `config_industry_dict` VALUES ('95', '02', '0201', 'perType', '人员类型', '020103', '财务人员', '3');
INSERT INTO `config_industry_dict` VALUES ('96', '02', '0201', 'perType', '人员类型', '020104', '勘查项目经理', '4');
INSERT INTO `config_industry_dict` VALUES ('97', '02', '0201', 'perType', '人员类型', '020105', '勘查区域经理', '5');
INSERT INTO `config_industry_dict` VALUES ('98', '02', '0201', 'perType', '人员类型', '020106', '报告编写人员', '6');
INSERT INTO `config_industry_dict` VALUES ('99', '02', '0201', 'perType', '人员类型', '020107', '报告审核人员', '7');
INSERT INTO `config_industry_dict` VALUES ('100', '02', '0201', 'perType', '人员类型', '020108', '撰写专家', '8');
INSERT INTO `config_industry_dict` VALUES ('101', '02', '0201', 'perType', '人员类型', '020109', '评估组长', '9');
INSERT INTO `config_industry_dict` VALUES ('102', '02', '0201', 'perType', '人员类型', '020110', '勘查人员', '10');
INSERT INTO `config_industry_dict` VALUES ('103', '02', '0201', 'perType', '人员类型', '020111', '勘查专家', '11');
INSERT INTO `config_industry_dict` VALUES ('104', '02', '0202', 'perType', '人员类型', '020001', '普通职员', '1');
INSERT INTO `config_industry_dict` VALUES ('105', '02', '0203', 'perType', '人员类型', '020001', '普通职员', '1');
INSERT INTO `config_industry_dict` VALUES ('107', '02', '0204', 'perType', '人员类型', '020001', '普通职员', null);
INSERT INTO `config_industry_dict` VALUES ('108', '01', '0101', 'perCerLevel', '人员证书等级', '01000101', '初级保安员', '1');
INSERT INTO `config_industry_dict` VALUES ('109', '01', '0101', 'perCerLevel', '人员证书等级', '01000102', '中级保安员', '2');
INSERT INTO `config_industry_dict` VALUES ('110', '01', '0101', 'perCerLevel', '人员证书等级', '01000103', '高级保安员', '3');
INSERT INTO `config_industry_dict` VALUES ('111', '01', '0101', 'perCerLevel', '人员证书等级', '01000104', '保安师', '4');
INSERT INTO `config_industry_dict` VALUES ('112', '01', '0101', 'perCerLevel', '人员证书等级', '01000105', '高级保安管理员', '5');
INSERT INTO `config_industry_dict` VALUES ('113', '01', '0102', 'perCerLevel', '人员证书等级', '01000101', '初级保安员', '1');
INSERT INTO `config_industry_dict` VALUES ('114', '01', '0102', 'perCerLevel', '人员证书等级', '01000102', '中级保安员', '2');
INSERT INTO `config_industry_dict` VALUES ('115', '01', '0102', 'perCerLevel', '人员证书等级', '01000103', '高级保安员', '3');
INSERT INTO `config_industry_dict` VALUES ('116', '01', '0102', 'perCerLevel', '人员证书等级', '01000104', '保安师', '4');
INSERT INTO `config_industry_dict` VALUES ('117', '01', '0102', 'perCerLevel', '人员证书等级', '01000105', '高级保安管理员', '5');
INSERT INTO `config_industry_dict` VALUES ('118', '01', '0103', 'perCerLevel', '人员证书等级', '01000101', '初级保安员', '1');
INSERT INTO `config_industry_dict` VALUES ('119', '01', '0103', 'perCerLevel', '人员证书等级', '01000102', '中级保安员', '2');
INSERT INTO `config_industry_dict` VALUES ('120', '01', '0103', 'perCerLevel', '人员证书等级', '01000103', '高级保安员', '3');
INSERT INTO `config_industry_dict` VALUES ('121', '01', '0103', 'perCerLevel', '人员证书等级', '01000104', '保安师', '4');
INSERT INTO `config_industry_dict` VALUES ('122', '01', '0103', 'perCerLevel', '人员证书等级', '01000105', '高级保安管理员', '5');
INSERT INTO `config_industry_dict` VALUES ('123', '01', '0104', 'perCerLevel', '人员证书等级', '01000101', '初级保安员', '1');
INSERT INTO `config_industry_dict` VALUES ('124', '01', '0104', 'perCerLevel', '人员证书等级', '01000102', '中级保安员', '2');
INSERT INTO `config_industry_dict` VALUES ('125', '01', '0104', 'perCerLevel', '人员证书等级', '01000103', '高级保安员', '3');
INSERT INTO `config_industry_dict` VALUES ('126', '01', '0104', 'perCerLevel', '人员证书等级', '01000104', '保安师', '4');
INSERT INTO `config_industry_dict` VALUES ('127', '01', '0104', 'perCerLevel', '人员证书等级', '01000105', '高级保安管理员', '5');
INSERT INTO `config_industry_dict` VALUES ('128', '01', '0105', 'perCerLevel', '人员证书等级', '01000101', '初级保安员', '1');
INSERT INTO `config_industry_dict` VALUES ('129', '01', '0105', 'perCerLevel', '人员证书等级', '01000102', '中级保安员', '2');
INSERT INTO `config_industry_dict` VALUES ('130', '01', '0105', 'perCerLevel', '人员证书等级', '01000103', '高级保安员', '3');
INSERT INTO `config_industry_dict` VALUES ('131', '01', '0105', 'perCerLevel', '人员证书等级', '01000104', '保安师', '4');
INSERT INTO `config_industry_dict` VALUES ('132', '01', '0105', 'perCerLevel', '人员证书等级', '01000105', '高级保安管理员', '5');
INSERT INTO `config_industry_dict` VALUES ('133', '02', '0205', 'perType', '人员类型', '020501', '管理员', '1');
INSERT INTO `config_industry_dict` VALUES ('134', '01', '0101', 'perCerType', '人员证书类型', '010004', '保安员等级结业证', '4');
INSERT INTO `config_industry_dict` VALUES ('135', '01', '0102', 'perCerType', '人员证书类型', '010004', '保安员等级结业证', '4');
INSERT INTO `config_industry_dict` VALUES ('136', '01', '0103', 'perCerType', '人员证书类型', '010004', '保安员等级结业证', '4');
INSERT INTO `config_industry_dict` VALUES ('137', '01', '0104', 'perCerType', '人员证书类型', '010004', '保安员等级结业证', '4');
INSERT INTO `config_industry_dict` VALUES ('138', '09', '0901', 'perType', '人员类型', '090001', '管理层', '1');
INSERT INTO `config_industry_dict` VALUES ('139', '09', '0901', 'perType', '人员类型', '090002', '项目经理', '2');
INSERT INTO `config_industry_dict` VALUES ('140', '09', '0901', 'perType', '人员类型', '090003', '区域经理', '3');
INSERT INTO `config_industry_dict` VALUES ('141', '09', '0901', 'perType', '人员类型', '090004', '保洁主管', '4');
INSERT INTO `config_industry_dict` VALUES ('142', '09', '0901', 'perType', '人员类型', '090005', '保洁员', '5');

