package com.bcxin.platform.web.controller.manage.wallet;

import com.bcxin.platform.common.core.controller.BaseController;
import com.bcxin.platform.common.core.page.PageDomain;
import com.bcxin.platform.common.core.page.TableSupport;
import com.bcxin.platform.common.exception.V5BusinessException;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.common.utils.ShiroUtils;
import com.bcxin.platform.domain.wallet.ComWalletAccount;
import com.bcxin.platform.domain.wallet.ComWalletChangeEvent;
import com.bcxin.platform.dto.SearchParamDTO;
import com.bcxin.platform.service.wallet.manage.ComWalletManageService;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

/**
 * <b> 企业钱包信息 </b>
 * @author ZXF
 * @create 2019/09/02 0002 10:28
 * @version
 * @注意事项 </b>
 */
@Controller
@RequestMapping("/manage/com-wallet")
public class ComWalletManageController extends BaseController {

    private String prefix = "manage/com-wallet";

    @Autowired
    private ComWalletManageService comWalletService;

    /**
     * 跳转企业钱包信息列表
     * @return
     */
    @RequiresPermissions("com-wallet:view")
    @GetMapping("/com-wallet-list-view")
    public String comWalletListView() {
        return prefix + "/comWalletList";
    }

    /**
     * 跳转企业账户信息
     * @return
     */
    @GetMapping("/com-wallet-account-view/{comId}")
    public String comWalletAccountView(@PathVariable("comId") String comId, ModelMap mmap) {
        SearchParamDTO dto = new SearchParamDTO();
        dto.setComId(Long.parseLong(comId));
        Result ret = comWalletService.getComWalletAccountByComId(dto);
        mmap.put("comWalletAccount", ret.getData());
        return prefix + "/comWalletAccount";
    }

    /**
     * 跳转企业收支明细
     * @return
     */
    @GetMapping("/com-wallet-account-trade-detail-view/{comId}/{walletAccountNo}")
    public String comWalletAccountTradeDetailView(@PathVariable("comId") String comId, @PathVariable("walletAccountNo") String walletAccountNo, ModelMap mmap) {
        mmap.put("comId", comId);
        mmap.put("walletAccountNo", walletAccountNo);
        return prefix + "/comWalletAccountTradeDetail";
    }

    /**
     * 跳转托底账户收支明细
     * @return
     */
    @RequiresPermissions("com-wallet:view")
    @GetMapping("/the-palm-family-payment-detail-view")
    public String thePalmFamilyPaymentDetailView() {
        return prefix + "/thePalmFamilyPaymentDetail";
    }

    /**
     * 跳转企业收支明细-详情
     * @return
     */
    @GetMapping("/com-trade-detail-view")
    public String comTradeDetailView() {
        return prefix + "/comTradeDetail";
    }

    /**
     * <b> 企业钱包信息修改审批 </b>
     * @author ZXF
     * @create 2019/09/11 0011 10:30
     * @version
     * @注意事项 </b>
     */
    @RequiresPermissions("com-wallet:view")
    @GetMapping("/com-wallet-approve-list-view")
    public String comWalletApproveListView() {
        return prefix + "/comWalletApproveList";
    }

    /**
     * <b> 企业钱包信息修改审批-详情 </b>
     * @author ZXF
     * @create 2019/09/11 0011 10:33
     * @version
     * @注意事项 </b>
     */
    @GetMapping("/com-wallet-approve-detail-view/{eventId}")
    public String comWalletApproveDetailView(@PathVariable("eventId") String eventId, ModelMap mmap) {
        SearchParamDTO dto = new SearchParamDTO();
        dto.setId(Long.parseLong(eventId));
        Result ret = comWalletService.getComWalletApproveById(dto);
        mmap.put("comWalletApprove", ret.getData());
        return prefix + "/comWalletApproveDetail";
    }

    /**
     * <b> 对账数据查询页面 </b>
     * @author ZXF
     * @create 2019/09/11 0011 10:33
     * @version
     * @注意事项 </b>
     */
    @RequiresPermissions("com-wallet:view")
    @GetMapping("/page-com-wallet-reconciliation-list-view")
    public String pageComWalletReconciliationListView() {
        return prefix + "/comWalletReconciliationList";
    }

    /**
     * <b> 企业钱包账户-收支明细 </b>
     * @author ZXF
     * @create 2020/11/11 0011 14:21
     * @version
     * @注意事项 </b>
     */
    @RequiresPermissions("com-wallet:view")
    @GetMapping("/page-com-wallet-account-detail-list-view")
    public String pageComWalletAccountDetailView() {
        return prefix + "/comWalletAccountDetailList";
    }

    /**
     * 获得企业钱包信息列表
     * @param dto
     * @return
     */
    @RequiresPermissions("com-wallet:list")
    @PostMapping("/page-com-wallet-list")
    @ResponseBody
    public Object pageComWalletList(SearchParamDTO dto) {
        startPage();
        return getDataTable(comWalletService.pageComWalletList(dto));
    }

    /**
     * 获得托底账户收支明细列表
     * @param dto
     * @return
     */
    @RequiresPermissions("com-wallet:list")
    @PostMapping("/page-account-base-record")
    @ResponseBody
    public Object pageAccountBaseRecord(SearchParamDTO dto) throws V5BusinessException {
        startPage();
        return getDataTable(comWalletService.pageAccountBaseRecord(dto));
    }

    /**
     * 对账数据查询
     * @param dto
     * @return
     */
    @RequiresPermissions("com-wallet:list")
    @PostMapping("/page-com-wallet-reconciliation-list")
    @ResponseBody
    public Object pageComWalletReconciliationList(SearchParamDTO dto) {
        startPage();
        return getDataTable(comWalletService.pageComWalletReconciliationList(dto));
    }

    /**
     * 企业钱包账户-收支明细
     * @param dto
     * @return
     */
    @RequiresPermissions("com-wallet:list")
    @PostMapping("/page-com-wallet-account-detail-list")
    @ResponseBody
    public Object pageComWalletAccountDetailList(SearchParamDTO dto) {
        startPage();
        return getDataTable(comWalletService.pageComWalletAccountDetailList(dto));
    }

    /**
     * <b> 导出企业钱包账户对账数据 </b>
     * @author ZXF
     * @create 2019/10/16 0016 14:59
     * @version
     * @注意事项 </b>
     */
    @RequiresPermissions("com-wallet:list")
    @GetMapping(value = "export-com-wallet-reconciliation")
    public Result exprokComWalletReconciliation(SearchParamDTO dto) throws V5BusinessException {
        return comWalletService.exprokComWalletReconciliation(dto,getResponse()).setBack(getRequest());
    }

    /**
     * 获得账户信息
     * @param paramDTO
     * @return
     */
    @RequiresPermissions("com-wallet:list")
    @PostMapping("/get-com-wallet-account-by-id")
    @ResponseBody
    public Object getComWalletAccountById(SearchParamDTO paramDTO) throws V5BusinessException {
        return comWalletService.getComWalletAccountByComId(paramDTO);
    }

    /**
     * 企业收支明细
     * @param dto
     * @return
     */
    @RequiresPermissions("com-wallet:list")
    @PostMapping("/get-com-wallet-account-trade-detail")
    @ResponseBody
    public Object getComWalletAccountTradeDetail(SearchParamDTO dto) throws V5BusinessException {
        PageDomain pageDomain = TableSupport.buildPageRequest();
        Integer pageNum = pageDomain.getPageNum();
        Integer pageSize = pageDomain.getPageSize();
        return getDataTable(comWalletService.getComWalletAccountTradeDetail(dto,pageNum,pageSize));
    }

    /**
     * <b> 电子回单 </b>
     * @author ZXF
     * @create 2019/09/03 0003 14:19
     * @version
     * @注意事项 </b>
     */
    @RequiresPermissions("com-wallet:list")
    @PostMapping("/get-com-account-trade-voucher")
    @ResponseBody
    public Result getComAccountTradeVoucher(SearchParamDTO dto) throws V5BusinessException {
        return comWalletService.getComAccountTradeVoucher(dto);
    }

    /**
     * <b> 交易凭证 </b>
     * @author ZXF
     * @create 2019/09/03 0003 14:19
     * @version
     * @注意事项 </b>
     */
    @RequiresPermissions("com-wallet:list")
    @PostMapping("/get-com-account-pay-voucher")
    @ResponseBody
    public Result getComAccountPayVoucher(SearchParamDTO dto) throws V5BusinessException {
        return comWalletService.getComAccountPayVoucher(dto);
    }

    /**
     * <b> 绑定银行卡 </b>
     * @author ZXF
     * @create 2019/09/02 0002 10:42
     * @version
     * @注意事项 </b>
     */
    @RequiresPermissions("com-wallet:list")
    @PostMapping("/bind-bank-card")
    @ResponseBody
    public Result BindBankCard(ComWalletAccount comWalletAccount) throws V5BusinessException{
        comWalletAccount.setUpdateBy(ShiroUtils.getUserId());
        return comWalletService.updateComWalletAccount(comWalletAccount);
    }

    /**
     * <b> 获取所有银行编码下拉数据 </b>
     * @author ZXF
     * @create 2019/09/02 0002 17:05
     * @version
     * @注意事项 </b>
     */
    @RequiresPermissions("com-wallet:list")
    @PostMapping("/get-all-bank-code-data")
    @ResponseBody
    public Object getAllBankCodeData(){
        return comWalletService.getAllBankCodeData();
    }

    /**
     * <b> 获得钱包信息修改审批列表 </b>
     * @author ZXF
     * @create 2019/09/11 0011 10:36
     * @version
     * @注意事项 </b>
     */
    @RequiresPermissions("com-wallet:list")
    @PostMapping("/page-com-wallet-approve-list")
    @ResponseBody
    public Object pageComWalletApproveList(SearchParamDTO dto) {
        startPage();
        return getDataTable(comWalletService.pageComWalletApproveList(dto));
    }

    /**
     * <b> 获得钱包信息修改审批信息-详情 </b>
     * @author ZXF
     * @create 2019/09/11 0011 10:36
     * @version
     * @注意事项 </b>
     */
    @RequiresPermissions("com-wallet:list")
    @PostMapping("/get-com-wallet-approve-by-id")
    @ResponseBody
    public Result getComWalletApproveById(SearchParamDTO paramDTO) throws V5BusinessException {
        return comWalletService.getComWalletApproveById(paramDTO);
    }

    /**
     * <b> 获得钱包信息修改字段信息列 </b>
     * @author ZXF
     * @create 2019/09/11 0011 10:36
     * @version
     * @注意事项 </b>
     */
    @RequiresPermissions("com-wallet:list")
    @PostMapping("/page-com-wallet-change-list")
    @ResponseBody
    public Object pageComWalletChangeList(SearchParamDTO dto) throws V5BusinessException {
        startPage();
        return getDataTable(comWalletService.pageComWalletChangeList(dto));
    }

    /**
     * <b> 钱包信息变更保存 </b>
     * @author ZXF
     * @create 2019/09/11 0011 10:36
     * @version
     * @注意事项 </b>
     */
    @RequiresPermissions("com-wallet:list")
    @PostMapping("/update-com-wallet-approve-status")
    @ResponseBody
    public Result updateComWalletApproveStatus(ComWalletChangeEvent comWalletChangeEvent) throws V5BusinessException {
        comWalletChangeEvent.setApprovePerId(ShiroUtils.getUserId());
        return comWalletService.updateComWalletApproveStatus(comWalletChangeEvent);
    }

}
