package com.bcxin.platform.web.controller.attend;

import com.bcxin.platform.common.annotation.Log;
import com.bcxin.platform.common.constant.Constants;
import com.bcxin.platform.common.core.controller.BaseController;
import com.bcxin.platform.common.core.domain.AjaxResult;
import com.bcxin.platform.common.core.page.TableDataInfo;
import com.bcxin.platform.common.enums.BusinessType;
import com.bcxin.platform.common.utils.poi.ExcelUtil;
import com.bcxin.platform.common.utils.validator.ValidatorUtils;
import com.bcxin.platform.common.utils.validator.group.AddGroup;
import com.bcxin.platform.domain.attend.AttendDict;
import com.bcxin.platform.dto.attend.AttendDictDto;
import com.bcxin.platform.service.attend.AttendDictService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 考勤类别Controller
 * 
 * @author lin
 * @date 2021-08-10
 */
@Controller
@RequestMapping("/attend/dict")
public class AttendDictController extends BaseController{

    @Autowired
    private AttendDictService attendDictService;

    /**
     * 查询考勤类别列表
     */
    @PostMapping("/list")
    @ResponseBody
    public TableDataInfo list(AttendDictDto attendDict){
        attendDict.setActive(Constants.Y);
        List<AttendDictDto> list = attendDictService.selectList(attendDict);
        return getDataTable(list);
    }

    /**
     * 分页查询考勤类别列表
     */
    @PostMapping("/searchForPage")
    @ResponseBody
    public TableDataInfo searchForPage(AttendDictDto attendDict){
        startPage();
        List<AttendDictDto> list = attendDictService.selectList(attendDict);
        return getDataTable(list);
    }

    /**
     * 导出考勤类别列表
     */
    @Log(title = "类别", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    @ResponseBody
    public AjaxResult export(AttendDictDto attendDict){
        List<AttendDictDto> list = attendDictService.selectList(attendDict);
        ExcelUtil<AttendDictDto> util = new ExcelUtil<AttendDictDto>(AttendDictDto.class);
        return util.exportExcel(list, "dict");
    }

    /**
     * 根据主键id查询
     */
    @GetMapping("/findById/{id}")
    @ResponseBody
    public AjaxResult findById(@PathVariable("id") Long id){
        AttendDict attendDict = attendDictService.findById(id);
        return AjaxResult.success(null,attendDict);
    }

    /**
     * 保存考勤类别
     */
    @Log(title = "考勤类别", businessType = BusinessType.UPDATE)
    @PostMapping("/save")
    @ResponseBody
    public AjaxResult editSave(AttendDict attendDict){
        ValidatorUtils.validateEntity(attendDict, AddGroup.class);
        return toAjax(attendDictService.update(attendDict));
    }

    /**
     * 删除考勤类别
     */
    @Log(title = "考勤类别", businessType = BusinessType.DELETE)
    @PostMapping( "/remove")
    @ResponseBody
    public AjaxResult remove(String ids){
        return toAjax(attendDictService.deleteByIds(ids));
    }
}
