package com.bcxin.platform.framework.config.kafka;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.platform.common.utils.spring.SpringUtils;
import com.bcxin.platform.components.*;
import com.bcxin.platform.domain.temporary.ComProject;
import com.bcxin.platform.domain.temporary.ComProjectPer;
import com.bcxin.platform.service.temporary.ComProjectService;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.*;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

/**
 * 仅内网和互联网可用（其他地方采用）
 */
@Configuration
@ConditionalOnProperty(value = "spring.kafka.bootstrap-servers",matchIfMissing = false )
public class KafkaConsumerListener {
    private static final Logger logger = LoggerFactory.getLogger(KafkaConsumerListener.class);

    private final String TOPIC_BAIBAODUNFLOW_TLK_PROJECT_PERSON = "baibaodunflow.binlog-cdc.topic.v2.tlk_project_person";
    private final String TOPIC_BAIBAODUNFLOW_TLK_TEMPORARY_PROTECTION_PROJECT = "baibaodunflow.binlog-cdc.topic.v2.tlk_temporary_protection_project";

    @DependsOn("batchFactory")
    @KafkaListener(
            id = "${spring.kafka.consumer.group-id}-group-v8-baibaodunflow-2-tlk_temporary_protection_project",
            topics = {
                    TOPIC_BAIBAODUNFLOW_TLK_TEMPORARY_PROTECTION_PROJECT
            }, groupId = "${spring.kafka.consumer.group-id}-group-v8-baibaodunflow-2-tlk_temporary_protection_project")
    public void ackTemporaryProtectionProjectListener(
            List<ConsumerRecord<String, String>> records, Acknowledgment ack) {
        if (CollectionUtils.isEmpty(records)) {
            return;
        }
        boolean allowed2CommitAtFinial = true;
        try {
            ComProjectService comProjectService = SpringUtils.getBean(ComProjectService.class);
            AtomicInteger count = new AtomicInteger();
            records.stream().forEach(ii -> {
                try {
                    Map<String, Object> mapB = JSONObject.parseObject(ii.value(),Map.class);
                    if(mapB.get("after") != null){
                        Map<String, Object> originalMap = JSONObject.parseObject(JSON.toJSONString(mapB.get("after")), Map.class);
                        // 转换 key 为大写
                        Map<String, Object> map = originalMap.entrySet().stream()
                                .collect(Collectors.toMap(
                                        entry -> entry.getKey().toUpperCase(),
                                        Map.Entry::getValue
                                ));
                        System.out.println("1.======> "+map.toString());
                        ComProject project = ComProject.build(map.get("ID")+""
                                , map.get("ITEM_PROJECT_NAME")+""
                                , map.get("ITEM_PROJECT_TYPE")+""
                                , map.get("DOMAINID")+""
                                , map.get("ITEM_PROJECT_START_TIME") != null ? (new Date(Long.parseLong(map.get("ITEM_PROJECT_START_TIME")+""))) : null
                                , map.get("ITEM_PROJECT_END_TIME") != null ? (new Date(Long.parseLong(map.get("ITEM_PROJECT_END_TIME")+""))) : null
                                , map.get("ITEM_ATTENDANCESITELONGITUDE")+","+map.get("ITEM_ATTENDANCESITELATITUDE")
                                , map.get("ITEM_ATTENDANCESITEFULLADDRESS")+"");
                        comProjectService.save(project);
                        count.getAndIncrement();
                    }
                } catch (Exception ex) {
                    logger.error("======> 处理临保项目信息异常", ex);
                }
            });
            logger.error("成功从缓存中处理{}条的临保项目信息", count.get());
        } catch (Exception ex) {
            logger.error("新增临保项目信息异常", ex);
            allowed2CommitAtFinial = false;
        } finally {
            if (allowed2CommitAtFinial) {
                ack.acknowledge();
            }
        }
    }

    @DependsOn("batchFactory")
    @KafkaListener(
            id = "${spring.kafka.consumer.group-id}-group-v8-baibaodunflow-2-tlk_project_person",
            topics = {
                    TOPIC_BAIBAODUNFLOW_TLK_PROJECT_PERSON
            }, groupId = "${spring.kafka.consumer.group-id}-group-v8-baibaodunflow-2-tlk_project_person")
    public void ackProjectPersonListener(
            List<ConsumerRecord<String, String>> records, Acknowledgment ack) {
        if (CollectionUtils.isEmpty(records)) {
            return;
        }


        boolean allowed2CommitAtFinial = true;
        try {
            Collection<ComProjectPer> pers = Collections.synchronizedList(new ArrayList<>());
            List<String> ids = new ArrayList<>();
            records.stream().forEach(ii -> {
                Map<String, Object> mapB = JSONObject.parseObject(ii.value(),Map.class);
                if(mapB.get("after") != null){
                    Map<String, Object> originalMap = JSONObject.parseObject(JSON.toJSONString(mapB.get("after")), Map.class);
                    // 转换 key 为大写
                    Map<String, Object> map = originalMap.entrySet().stream()
                            .collect(Collectors.toMap(
                                    entry -> entry.getKey().toUpperCase(),
                                    Map.Entry::getValue
                            ));
                    System.out.println("1.======> "+map.toString());
                    ComProjectPer per = new ComProjectPer();
                    per.setTlkProjectPerId(map.get("ID")+"");
                    per.setTlkPerId(map.get("ITEM_PERSON_ID")+"");
                    per.setTlkProjectId(map.get("ITEM_PROJECT_ID")+"");
                    per.setTlkComId(map.get("DOMAINID")+"");
                    per.setCreateTime(new Date());
                    pers.add(per);
                }else{
                    if(mapB.get("before") != null){
                        Map<String, Object> originalMap = JSONObject.parseObject(JSON.toJSONString(mapB.get("before")), Map.class);
                        // 转换 key 为大写
                        Map<String, Object> map = originalMap.entrySet().stream()
                                .collect(Collectors.toMap(
                                        entry -> entry.getKey().toUpperCase(),
                                        Map.Entry::getValue
                                ));
                        ids.add(map.get("ID")+"");
                    }
                }

            });

            ComProjectService comProjectService = SpringUtils.getBean(ComProjectService.class);
            if (!CollectionUtils.isEmpty(pers)) {
                comProjectService.savePer(pers);
            }
            if (!CollectionUtils.isEmpty(ids)) {
                comProjectService.batchDelete(ids.toArray(new String[0]));
            }

            logger.error("成功从缓存中处理{}条的授权信息", pers.size());
        } catch (Exception ex) {
            logger.error("消费用户角色信息发生异常", ex);
            allowed2CommitAtFinial = false;
        } finally {
            if (allowed2CommitAtFinial) {
                ack.acknowledge();
            }
        }
    }

    private Collection<String> extractValue(String debeziumJsonValue, String field) {
        if (!StringUtils.hasLength(debeziumJsonValue)) {
            return Collections.EMPTY_LIST;
        }

        JSONObject rootNode = SpringUtils.getBean(JsonProvider.class).getData(debeziumJsonValue, JSONObject.class);

        if (rootNode == null) {
            return Collections.EMPTY_LIST;
        }

        Collection<JSONObject> allNodes = new HashSet<>();
        JSONObject before = rootNode.getJSONObject("before");
        if (before != null) {
            allNodes.add(before);
        }
        JSONObject after = rootNode.getJSONObject("after");
        if (after != null) {
            allNodes.add(after);
        }

        Collection<String> employeeIds =
                allNodes.stream().map(ii -> {
                            String selectedKey =
                                    ii.keySet().stream().filter(fi -> fi.equalsIgnoreCase(field)).findFirst().orElse(null);
                            if (StringUtils.hasLength(selectedKey)) {
                                return ii.getString(selectedKey);
                            }

                            return null;
                        }).filter(ii -> StringUtils.hasLength(ii))
                        .collect(Collectors.toSet());

        return employeeIds;
    }

    private void postRefreshInstanceUserCache(
            HttpMethod method,
            String serviceUrl, String urlFormat,Object params ) {
        String targetUrl = String.format(urlFormat,serviceUrl);
        try {
            CloseableHttpClient httpClient = null;
            try {
                httpClient = HttpClientBuilder.create().build();

                HttpEntityEnclosingRequestBase put = new HttpPost(targetUrl);
                if(method==HttpMethod.PUT) {
                    put = new HttpPut(targetUrl);
                }

                String json = SpringUtils.getBean(JsonProvider.class).getJson(params);
                put.setEntity(new StringEntity(json, ContentType.APPLICATION_JSON));
                CloseableHttpResponse response = httpClient.execute(put);
                String result = EntityUtils.toString(response.getEntity(), "UTF-8");

                logger.error("推送表单数据至{}-数据={} 保存结果为:{}-{}",
                        put.getURI(), json, response.getStatusLine(), result);
            } finally {
                if (httpClient != null) {
                    httpClient.close();
                }
            }
        } catch (Exception ex) {
            logger.error("刷新runtime({})组件缓存发生异常:{}", targetUrl, SpringUtils.getBean(JsonProvider.class).getJson(params), ex);
        }
    }
}
