/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.framework.manager.factory;

import com.bcxin.platform.common.utils.AddressUtils;
import com.bcxin.platform.common.utils.LogUtils;
import com.bcxin.platform.common.utils.ServletUtils;
import com.bcxin.platform.common.utils.ShiroUtils;
import com.bcxin.platform.common.utils.StringUtils;
import com.bcxin.platform.common.utils.spring.SpringUtils;
import com.bcxin.platform.domain.system.SysLogininfor;
import com.bcxin.platform.domain.system.SysOperLog;
import com.bcxin.platform.domain.system.SysUserOnline;
import com.bcxin.platform.framework.shiro.session.OnlineSession;
import com.bcxin.platform.service.system.ISysOperLogService;
import com.bcxin.platform.service.system.ISysUserOnlineService;
import com.bcxin.platform.service.system.impl.SysLogininforServiceImpl;
import eu.bitwalker.useragentutils.UserAgent;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncFactory {
    private static final Logger sys_user_logger = LoggerFactory.getLogger((String)"sys-user");

    public static TimerTask syncSessionToDb(final OnlineSession session) {
        return new TimerTask(){

            @Override
            public void run() {
                SysUserOnline online = new SysUserOnline();
                online.setSessionId(String.valueOf(session.getId()));
                online.setDeptName(session.getDeptName());
                online.setLoginName(session.getLoginName());
                online.setStartTimestamp(session.getStartTimestamp());
                online.setLastAccessTime(session.getLastAccessTime());
                online.setExpireTime(Long.valueOf(session.getTimeout()));
                online.setIpaddr(session.getHost());
                online.setLoginLocation(AddressUtils.getRealAddressByIP((String)session.getHost()));
                online.setBrowser(session.getBrowser());
                online.setOs(session.getOs());
                online.setStatus(session.getStatus());
                ((ISysUserOnlineService)SpringUtils.getBean(ISysUserOnlineService.class)).saveOnline(online);
            }
        };
    }

    public static TimerTask recordOper(final SysOperLog operLog) {
        return new TimerTask(){

            @Override
            public void run() {
                operLog.setOperLocation(AddressUtils.getRealAddressByIP((String)operLog.getOperIp()));
                ((ISysOperLogService)SpringUtils.getBean(ISysOperLogService.class)).insertOperlog(operLog);
            }
        };
    }

    public static TimerTask recordLogininfor(final String username, final String status, final String message, final Object ... args) {
        final UserAgent userAgent = UserAgent.parseUserAgentString((String)ServletUtils.getRequest().getHeader("User-Agent"));
        final String ip = ShiroUtils.getIp();
        return new TimerTask(){

            @Override
            public void run() {
                String address = AddressUtils.getRealAddressByIP((String)ip);
                StringBuilder s = new StringBuilder();
                s.append(LogUtils.getBlock((Object)ip));
                s.append(address);
                s.append(LogUtils.getBlock((Object)username));
                s.append(LogUtils.getBlock((Object)status));
                s.append(LogUtils.getBlock((Object)message));
                sys_user_logger.info(s.toString(), args);
                String os = userAgent.getOperatingSystem().getName();
                String browser = userAgent.getBrowser().getName();
                SysLogininfor logininfor = new SysLogininfor();
                logininfor.setLoginName(username);
                logininfor.setIpaddr(ip);
                logininfor.setLoginLocation(address);
                logininfor.setBrowser(browser);
                logininfor.setOs(os);
                logininfor.setMsg(message);
                if (StringUtils.equalsAny((CharSequence)status, (CharSequence[])new CharSequence[]{"Success", "Logout", "Register"})) {
                    logininfor.setStatus("0");
                } else if ("Error".equals(status)) {
                    logininfor.setStatus("1");
                }
                ((SysLogininforServiceImpl)SpringUtils.getBean(SysLogininforServiceImpl.class)).insertLogininfor(logininfor);
            }
        };
    }
}

