package com.bcxin.platform.util;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtils;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.*;

/**
 * 对象操作工具类, 继承org.apache.commons.beanutils.BeanUtils类
 *
 * @author zhangye
 * @version 1.0
 */
public class ObjectUtils extends BeanUtils {

	static {
		//注册sql.date的转换器，允许BeanUtils.copyProperties时sql.Date类型的值允许为空
		ConvertUtils.register(new org.apache.commons.beanutils.converters.SqlDateConverter(null), java.sql.Date.class);
		//注册util.date的转换器，允许BeanUtils.copyProperties时util.Date类型的值允许为空
		ConvertUtils.register(new org.apache.commons.beanutils.converters.SqlDateConverter(null), Date.class);
	}

	/**
	 * @Author: wangcy
	 * @Description: dest 要copy的对象 ，orig是copy内容的来源
	 * @Date: 2017/12/27 0027 10:57
	 */
	public static void copyProperties(Object dest, Object orig) {
		try {
			BeanUtilsBean.getInstance().copyProperties(dest, orig);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * @Author: wangjianchi
	 * @Description: dest 要copy的对象 ，orig是copy内容的来源 拷贝系统初始化所需常量
	 * @Date: 2018/01/22 0027 10:57
	 */
	public static void appCopyProperties(Object dest, Object orig) {
		try {
			Map<String, Object> sourceMap = new HashMap<String, Object>();
			Field[] origFields = getAllFields(orig);
			for (Field file : origFields) {
				file.setAccessible(true);
				String fileName = file.getName();
				if (fileName.equals("createBy")) {
					sourceMap.put("createBy", file.get(orig));
				} else if (fileName.equals("createTime")) {
					sourceMap.put("createTime", file.get(orig));
				} else if (fileName.equals("updateBy")) {
					sourceMap.put("updateBy", file.get(orig));
				} else if (fileName.equals("updateTime")) {
					sourceMap.put("updateTime", file.get(orig));
				} else if (fileName.equals("isDelete")) {
					sourceMap.put("isDelete", file.get(orig));
				} else if (fileName.equals("comId")) {
					sourceMap.put("comId", file.get(orig));
				} else if (fileName.equals("sessionId")) {
					sourceMap.put("sessionId", file.get(orig));
				}
			}

			Field[] destFields = getAllFields(dest);
			{
				for (Field file : destFields) {
					file.setAccessible(true);
					String fileName = file.getName();
					if (fileName.equals("createBy")) {
						file.set(dest, sourceMap.get(fileName));
					} else if (fileName.equals("createTime")) {
						file.set(dest, sourceMap.get(fileName));
					} else if (fileName.equals("updateBy")) {
						file.set(dest, sourceMap.get(fileName));
					} else if (fileName.equals("updateTime")) {
						file.set(dest, sourceMap.get(fileName));
					} else if (fileName.equals("isDelete")) {
						file.set(dest, sourceMap.get(fileName));
					} else if (fileName.equals("comId")) {
						file.set(dest, sourceMap.get(fileName));
					}else if (fileName.equals("sessionId")) {
						file.set(dest, sourceMap.get(fileName));
					}
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public static Field[] getAllFields(Object object) {
		Class clazz = object.getClass();
		List<Field> fieldList = new ArrayList<>();
		while (clazz != null) {
			fieldList.addAll(new ArrayList<>(Arrays.asList(clazz.getDeclaredFields())));
			clazz = clazz.getSuperclass();
		}
		Field[] fields = new Field[fieldList.size()];
		fieldList.toArray(fields);
		return fields;
	}

	public static <T> Map<String, String> compare(T obj1, T Obj2) throws Exception {

		Map<String, String> result = new HashMap<String, String>();

		Field[] fs = obj1.getClass().getDeclaredFields();
		for (Field f : fs) {
			f.setAccessible(true);
			Object v1 = f.get(obj1);
			Object v2 = f.get(Obj2);
			result.put(f.getName(), String.valueOf(equals(v1, v2)));
		}
		return result;
	}

	public static boolean equals(Object obj1, Object obj2) {

		if (obj1 == obj2) {
			return true;
		}
		if (obj1 == null || obj2 == null) {
			return false;
		}
		return obj1.equals(obj2);
	}

	/**
	 * 比较两个实体属性值，返回一个map以有差异的属性名为key，value为一个list分别存obj1,obj2此属性名的值
	 *
	 * @param obj1
	 *            进行属性比较的对象1
	 * @param obj2
	 *            进行属性比较的对象2()
	 * @param ignoreArr
	 *            选择忽略比较的属性数组
	 * @return 属性差异比较结果map
	 * @Author: wangcy
	 */

	public static Map<String, List<Object>> compareFields(Object obj1, Object obj2, String[] ignoreArr) {
		try {
			Map<String, List<Object>> map = new HashMap<String, List<Object>>();
			List<String> ignoreList = null;
			if (ignoreArr != null && ignoreArr.length > 0) {
				// array转化为list
				ignoreList = Arrays.asList(ignoreArr);
			}
			// 只有两个对象都是同一类型的才有可比性
			if (obj1.getClass() == obj2.getClass()) {
				Class clazz = obj1.getClass();
				// 获取object的属性描述
				PropertyDescriptor[] pds = Introspector.getBeanInfo(clazz, Object.class).getPropertyDescriptors();
				for (PropertyDescriptor pd : pds) {// 这里就是所有的属性了
					String name = pd.getName();// 属性名
					if (ignoreList != null && ignoreList.contains(name)) {// 如果当前属性选择忽略比较，跳到下一次循环
						continue;
					}
					Method readMethod = pd.getReadMethod();// get方法
					// 在obj1上调用get方法等同于获得obj1的属性值
					Object o1 = readMethod.invoke(obj1);
					// 在obj2上调用get方法等同于获得obj2的属性值
					Object o2 = readMethod.invoke(obj2);
					if (o1 instanceof Timestamp) {
						o1 = new Date(((Timestamp) o1).getTime());
					}
					if (o2 instanceof Timestamp) {
						o2 = new Date(((Timestamp) o2).getTime());
					}
					if (o1 == null && o2 == null) {
						continue;
					} else if (o1 == null && o2 != null) {
						List<Object> list = new ArrayList<Object>();
						list.add(o1);
						list.add(o2);
						map.put(name, list);
						continue;
					}
					if (!o1.equals(o2)) {// 比较这两个值是否相等,不等就可以放入map了
						List<Object> list = new ArrayList<Object>();
						list.add(o1);
						list.add(o2);
						map.put(name, list);
					}
				}
			}
			return map;
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}
	}

	public static String safeToString(Object object){
		if (object == null) {
			return "";
		}
		return object.toString();
	}
}
