package com.bcxin.platform.util;

import com.alibaba.fastjson.JSON;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import org.apache.commons.codec.binary.Base64;
import org.springframework.stereotype.Component;

import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

@Component
public class JwtUtil {
    /**
     * 数据请求返回码
     */
    public static final int RESCODE_SUCCESS = 1000;                //成功
    public static final int RESCODE_SUCCESS_MSG = 1001;            //成功(有返回信息)
    public static final int RESCODE_EXCEPTION = 1002;            //请求抛出异常
    public static final int RESCODE_NOLOGIN = 1003;                //未登陆状态
    public static final int RESCODE_NOEXIST = 1004;                //查询结果为空
    public static final int RESCODE_NOAUTH = 1005;                //无操作权限

    /**
     * jwt
     */
    public static final String JWT_SECRET = "sdoDFyzfieqMrisd4H5o5t9weOl6GmSr"; // 平台固定私钥
    public static final int JWT_TTL = 365 * 24 * 60 * 60 * 1000;  //millisecond 1天 客户端去申请token
    public static final int JWT_REFRESH_INTERVAL = 55 * 60 * 1000;  //millisecond token无效的时间间隔
    public static final int JWT_REFRESH_TTL = 7 * 24 * 60 * 60 * 1000;  //millisecond 7天重新登录的时间间隔

    /**
     * 由字符串生成加密key
     *
     * @return
     */
    private static SecretKey generalKey(String stringKey) {
        byte[] encodedKey = Base64.decodeBase64(stringKey);
        SecretKey key = new SecretKeySpec(encodedKey, 0, encodedKey.length, "AES");
        return key;
    }

    /**
     * 创建jwt，ttlMillis为负数表示不过期
     *
     * @param id
     * @param subject
     * @param ttlMillis
     * @return
     * @throws Exception
     */
    public static String createJWT(String id, String subject, String stringKey, long ttlMillis) throws Exception {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        JwtBuilder builder = Jwts.builder()
                .setId(id)
                .setIssuedAt(new Date(System.currentTimeMillis()))
                .setSubject(subject)
                .signWith(signatureAlgorithm, generalKey(stringKey));
        if (ttlMillis >= 0) {
            long expMillis = System.currentTimeMillis() + ttlMillis;
            Date exp = new Date(expMillis);
            builder.setExpiration(exp);
        }
        return builder.compact();
    }

    /**
     * 创建jwt
     *
     * @param subject
     * @return
     */
    public static String createJWT(Map<Object, Object> subject) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        JwtBuilder builder = Jwts.builder()
                .setSubject(JSON.toJSONString(subject)) //主题，就是附带在token中的信息
                .signWith(signatureAlgorithm, generalKey(JWT_SECRET)); //选择的算法，和私钥值
        if (JWT_REFRESH_TTL >= 0) { //如果过期时间为负数，那么不设置过期时间
            long expMillis = System.currentTimeMillis() + JWT_REFRESH_TTL;
            Date exp = new Date(expMillis);
            builder.setExpiration(exp);
        }
        return builder.compact();
    }

    /**
     * 创建jwt
     *
     * @param subject
     * @return
     */
    public static String createJWTObject(Object subject) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        JwtBuilder builder = Jwts.builder()
                .setSubject(JSON.toJSONString(subject)) //主题，就是附带在token中的信息
                .signWith(signatureAlgorithm, generalKey(JWT_SECRET)); //选择的算法，和私钥值
        if (JWT_REFRESH_TTL >= 0) { //如果过期时间为负数，那么不设置过期时间
            long expMillis = System.currentTimeMillis() + JWT_REFRESH_TTL;
            Date exp = new Date(expMillis);
            builder.setExpiration(exp);
        }
        return builder.compact();
    }

    /**
     * 创建jwt
     *
     * @param subject
     * @return
     */
    public static String createJWT(Map<Object, Object> subject, String stringKey, long ttlMillis) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        JwtBuilder builder = Jwts.builder()
                .setSubject(JSON.toJSONString(subject)) //主题，就是附带在token中的信息
                .signWith(signatureAlgorithm, generalKey(stringKey)); //选择的算法，和私钥值
        if (ttlMillis >= 0) { //如果过期时间为负数，那么不设置过期时间
            long expMillis = System.currentTimeMillis() + ttlMillis;
            Date exp = new Date(expMillis);
            builder.setExpiration(exp);
        }
        return builder.compact();
    }

    /**
     * 解密jwt
     *
     * @param jwttoken
     * @return
     * @throws Exception
     */
    public static Claims parseJWT(String jwttoken) {
        Claims claims = Jwts.parser()
                .setSigningKey(generalKey(JWT_SECRET)) //没有私钥是解密不了的
                .parseClaimsJws(jwttoken).getBody();
        return claims;
    }

    public static void main(String[] args) throws Exception {
        Map<Object, Object> p = new HashMap<>();
        p.put("MerUserId", "664891052041175040");//平台会员号
        p.put("VirlAcctType", "01");//虚账户类型：00-平台虚拟过渡户，01-基本户，02-保证金户，03-结算户，04-只收丌付，05-融资与用户
        p.put("BeginDate", "2020-11-20");//开始日期
        p.put("EndDate", "2020-12-01");
//        Map<Object,Object> p = new HashMap<Object,Object>();
//        p.put("login_name", "sn20160048");//模拟数据
//        p.put("party", "ARS-SX");//模拟数据*//*
//        String token = "eyJhbGciOiJIUzI1NiJ9.eyJzdWIiOiJ7XCJ1c2VyaWRcIjoxMzkzfSIsImV4cCI6MTUwNjE1NDMxMX0.xBl9vnusKOIYl0xYQHGOSMv05nSYqZGjJcCiveFB_CE";//加密生成token
        String token = JwtUtil.createJWT(p);//加密生成token
        System.out.println(token);
        Claims claims = JwtUtil.parseJWT(token);  //205个字节,解密token获取数据

        System.out.println(claims.getSubject());
        String paramStr = claims.getSubject();
        Map<String, Object> paramMap = JSON.parseObject(paramStr, Map.class);
        System.out.println(paramMap);
    }

}
