package com.bcxin.platform.service.attend;

import com.bcxin.platform.domain.attend.AttendReport;
import com.bcxin.platform.dto.app.AppAttendReportDto;
import com.bcxin.platform.dto.app.AppAttendSearchDto;
import com.bcxin.platform.dto.attend.AttendReportDto;

import java.util.List;

/**
 * 考勤结果统计Service接口
 * 
 * @author lin
 * @date 2021-08-30
 */
public interface AttendReportService{

    /**
     * 查询考勤结果统计
     * 
     * @param id 考勤结果统计ID
     * @return 考勤结果统计
     */
    AttendReportDto findById(Long id);

    /**
     * 查询考勤结果统计列表
     * 
     * @param attendReport 考勤结果统计
     * @return 考勤结果统计集合
     */
    List<AttendReportDto> selectList(AttendReportDto attendReport);


    /**
     * 编辑考勤结果统计
     * 
     * @param attendReport 考勤结果统计
     * @return 结果
     */
    int update(AttendReport attendReport);

    AttendReportDto findDetail(Long id);

    /**
     * 我的统计 按月
     * @param searchDto
     * @return
     */
    AppAttendReportDto findMonthStatistics(AppAttendSearchDto searchDto);
}
