package com.bcxin.platform.dto.oauth;

import org.apache.oltu.oauth2.as.request.OAuthTokenRequest;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;

import javax.servlet.http.HttpServletRequest;

/**
 * @author zhangye
 */
public class OAuthTokenxRequest extends OAuthTokenRequest {
    private String tlkUserName;

    /**
     * Create an OAuth Token request from a given HttpSerlvetRequest
     *
     * @param request the httpservletrequest that is validated and transformed into
     *                the OAuth Token Request
     * @throws org.apache.oltu.oauth2.common.exception.OAuthSystemException  if an unexpected exception was thrown
     * @throws org.apache.oltu.oauth2.common.exception.OAuthProblemException if the request was not a valid Token request this exception
     *                                                                       is thrown.
     */
    public OAuthTokenxRequest(HttpServletRequest request) throws OAuthSystemException, OAuthProblemException {
        super(request);
    }

    public HttpServletRequest request() {
        return this.request;
    }

    public String getMobileEquipId() {
        return this.getParam("mobileEquipId");
    }

    public String getPublicKey() {
        return this.getParam("public_key");
    }

    public String getDevice() {
        return this.getParam("device");
    }

    public String getTlkAccessToken() {
        return this.getParam("tlk_access_token");
    }

    public String getTlkUserName() {
        return tlkUserName;
    }

    public void setTlkUserName(String tlkUserName) {
        this.tlkUserName = tlkUserName;
    }
}
