package com.bcxin.platform.dto.meeting;

import com.bcxin.platform.common.utils.StringUtils;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * <b> 与会者 </b>
 *
 * @author ZXF
 * @create 2020/01/13 0013 15:04
 * @注意事项 </b>
 */
@Data
public class AttendeeDTO {

    /**
     * 与会者的用户uuid
     */
    @ApiModelProperty(value = "与会者的用户uuid")
    private String userUUID;


    /**
     * 与会者帐号
     */
    @ApiModelProperty(value = "与会者帐号")
    private String accountId;


    /**
     * 与会者名称或昵称
     */
    @ApiModelProperty(value = "与会者名称或昵称")
    private String name;


    /**
     * 会议中的角色,0：普通与会者,1：会议主席
     */
    @ApiModelProperty(value = "会议中的角色")
    private Integer role;

    /**
     * 电话号码
     */
    @ApiModelProperty(value = "电话号码")
    private String phone;
    /**
     * 取值类型同参数“phone”
     */
    @ApiModelProperty(value = "取值类型同参数“phone”")
    private String phone2;
    /**
     * 取值类型同参数“phone”
     */
    @ApiModelProperty(value = "取值类型同参数“phone”")
    private String phone3;
    /**
     * 邮件地址
     */
    @ApiModelProperty(value = "邮件地址")
    private String email;
    /**
     * 短信通知的手机号码
     */
    @ApiModelProperty(value = "短信通知的手机号码")
    private String sms;
    /**
     * 用户入会时是否需要自动闭音
     */
    @ApiModelProperty(value = "用户入会时是否需要自动闭音")
    private Integer isMute;
    /**
     * 会议开始时是否自动邀请该与会者
     */
    @ApiModelProperty(value = "会议开始时是否自动邀请该与会者")
    private Integer isAutoInvite;
    /**
     * 默认值由会议AS定义
     * “normal”：语音、高清、标清与会者地址（默认），软终端用户
     * “telepresence”：智真与会者地址类型，单屏、三屏智真均属此类
     * “terminal”：会议室或硬终端
     * “outside”：外部与会人
     * “mobile”：软终端用户手机
     * “telephone”：软终端用户固定电话，暂不使用
     */
    @ApiModelProperty(value = "默认值由会议AS定义")
    private String type;
    /**
     * 终端所在会议室信息。
     */
    @ApiModelProperty(value = "终端所在会议室信息")
    private String address;
    /**
     * 部门名称
     */
    @ApiModelProperty(value = "部门名称")
    private String deptUUID;
    /**
     * 组织名称
     */
    @ApiModelProperty(value = "组织名称")
    private String deptName;
    /**
     * 是否支持SVC能力
     */
    @ApiModelProperty(value = "是否支持SVC能力")
    private boolean supportSVC;
    /**
     * 是否中继号码
     */
    @ApiModelProperty(value = "是否中继号码")
    private boolean isTruckNum;

    public void setPhone(String phone) {
        if (StringUtils.isNotEmpty(phone)) {
            //处理前端传+号被自动转空格的问题
            this.phone = phone.replace(" ", "+");
        }
    }

    public void setPhone2(String phone) {
        if (StringUtils.isNotEmpty(phone)) {
            this.phone2 = phone.replace(" ", "+");
        }
    }

    public void setPhone3(String phone) {
        if (StringUtils.isNotEmpty(phone)) {
            this.phone3 = phone.replace(" ", "+");
        }
    }
}
