package com.bcxin.platform.dto.company;

import com.bcxin.platform.annotation.DisMultiTenancy;
import com.bcxin.platform.common.serializer.LongJsonDeserializer;
import com.bcxin.platform.common.serializer.LongJsonSerializer;
import com.bcxin.platform.domain.company.ComBaseInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * @Author: 陈堂君
 * @Date: 2017/12/19
 * @Description: 
 * @Modified By: 
 */
@Data
@EqualsAndHashCode(callSuper = true)
@DisMultiTenancy
public class ComDTO extends ComBaseInfo {
    private String randomKey;
    private String code;
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long perId;
    private String phone;
    private String msg;
    private String legalAuthPhone;
    private String legalAuthCode;
    private String legalAuthCodeTimeSession;

    /**
     * @Author: wuxiaozhen
     * 关键字
     */
    @ApiModelProperty(value = "关键字")
    private String keyWord;

    /**
     * @Author: wuxiaozhen
     * 注册地所在省份名
     */
    @ApiModelProperty(value = "注册地所在省份名")
    private String regProvinceName;

    /**
     * @Author: wuxiaozhen
     * 注册地所在城市名
     */
    @ApiModelProperty(value = "注册地所在城市名")
    private String regCityName;

    /**
     * @Author: wuxiaozhen
     * 注册地所在区/县名
     */
    @ApiModelProperty(value = "注册地所在区/县名")
    private String regAreaName;

    /**
     * @Author: wuxiaozhen
     * 经营地所在省份
     */
    @ApiModelProperty(value = "经营地所在省份")
    private Integer manageProvince;

    /**
     * @Author: wuxiaozhen
     * 经营地所在城市
     */
    @ApiModelProperty(value = "经营地所在城市")
    private Integer manageCity;

    /**
     * @Author: wuxiaozhen
     * 经营地所在区/县
     */
    @ApiModelProperty(value = "经营地所在区/县")
    private Integer manageArea;

    /**
     * @Author: wuxiaozhen
     * 经营地所在省份名
     */
    @ApiModelProperty(value = "经营地所在省份名")
    private String manageProvinceName;

    /**
     * @Author: wuxiaozhen
     * 经营地所在城市名
     */
    @ApiModelProperty(value = "经营地所在城市名")
    private String manageCityName;

    /**
     * @Author: wuxiaozhen
     * 经营地所在区/县名
     */
    @ApiModelProperty(value = "经营地所在区/县名")
    private String manageAreaName;

    /**
     * @Author: wuxiaozhen
     * 经营地址
     */
    @ApiModelProperty(value = "经营地址")
    private String manageAddress;

    /**
     * @Author: wuxiaozhen
     * 备案公安机关
     */
    @ApiModelProperty(value = "备案公安机关")
    private String recordPolice;

    /**
     * @Author: wuxiaozhen
     * 备案日期
     */
    @ApiModelProperty(value = "备案日期")
    private Date recordDate;
    /**
     * @Author: zhongjianhui
     * 分公司的id
     */
    @ApiModelProperty(value = "分公司的id")
    private Long comBranchId;

    /**负责人姓名*/
    @ApiModelProperty(value = "负责人姓名")
    private String chargePerName;

    /**负责人手机号*/
    @ApiModelProperty(value = "负责人手机号")
    private String chargePerPhone;

    /**负责人证件类型*/
    @ApiModelProperty(value = "负责人证件类型")
    private String chargeIdCardType;

    /**负责人证件号码*/
    @ApiModelProperty(value = "负责人证件号码")
    private String chargeIdCardNo;
}
