package com.bcxin.platform.domain.company;

import com.bcxin.platform.annotation.DisMultiTenancy;
import com.bcxin.platform.annotation.TableName;
import com.bcxin.platform.common.serializer.LongJsonDeserializer;
import com.bcxin.platform.common.serializer.LongJsonSerializer;
import com.bcxin.platform.util.BaseEntity;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * @author：wangcy @date：2017/12/20 0020 10:06
 * @description：PerBaseInfo的实体类
 */
@TableName("per_base_info")
@DisMultiTenancy
@Data
public class PerBaseInfo extends BaseEntity<PerBaseInfo> {
	/**
	 * 人员ID
	 */
	@JsonSerialize(using = LongJsonSerializer.class)
	@JsonDeserialize(using = LongJsonDeserializer.class)
	@ApiModelProperty(value = "人员ID")
	@NotNull(message = "人员ID不能为空")
	private Long perId;
	/**
	 * 用户ID
	 */
	@JsonSerialize(using = LongJsonSerializer.class)
	@JsonDeserialize(using = LongJsonDeserializer.class)
	@ApiModelProperty(value = "用户ID")
	@NotNull(message = "用户ID不能为空")
	private Long userId;

	/**
	 * 身份证件类型
	 */
	@ApiModelProperty(value = "身份证件类型")
	private String idCardType;
	/**
	 * 证件号码
	 */
	@ApiModelProperty(value = "证件号码")
	private String idCardNo;
	/**
	 * 姓名
	 */
	@ApiModelProperty(value = "姓名")
	private String name;

	/**
	 * 是否在职
	 */
	@ApiModelProperty(value = "是否在职")
	private String isIncumbency;
	/**
	 * 手机号
	 */
	@ApiModelProperty(value = "手机号")
	private String mobilePhone;

	@ApiModelProperty(value = "v5人员id")
	private String tlkPerId;

	/**
	 * 性别
	 */
	private String sex;

	/**
	 * 生日
	 */
	private String birthDay;

	/**
	 * 人员类型 人员类型 010001	普通保安员，010002	武装押运人员，010003	内勤人员
	 */
	private String perType;

	/**
	 * 部门名称
	 */
	private String departName;

}
