package com.bcxin.oaflow.mapper;

import com.bcxin.oaflow.domain.PublicRelease;
import com.bcxin.oaflow.dto.OaBusinessDto;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 公出Mapper接口
 * 
 * @author lin
 * @date 2021-09-01
 */
public interface PublicReleaseMapper{

    /**
     * 查询公出
     * 
     * @param id 公出ID
     * @return 公出
     */
    PublicRelease findById(String id);

    /**
     * 查询公出列表
     * 
     * @param tlkPerIds
     * @param schedulDate
     * @return 公出集合
     */
    List<PublicRelease> selectList(@Param("list")List<String> tlkPerIds,@Param("schedulDate")String schedulDate);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<PublicRelease> findByBatchId(@Param("list") List<PublicRelease> list);

    /**
     * 查询出差列表
     *
     * @param tlkPerId
     * @param schedulDate
     * @return 出差集合
     */
    List<OaBusinessDto> findByUserId(@Param("tlkPerId")String tlkPerId, @Param("schedulDate")String schedulDate);
}
