/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.service.attend.impl;

import com.bcxin.platform.common.core.text.Convert;
import com.bcxin.platform.common.exception.BusinessException;
import com.bcxin.platform.common.utils.DateUtil;
import com.bcxin.platform.common.utils.DateUtils;
import com.bcxin.platform.common.utils.IdWorker;
import com.bcxin.platform.common.utils.bean.BeanUtils;
import com.bcxin.platform.domain.attend.AttendCalendarRest;
import com.bcxin.platform.domain.attend.AttendCalendarRestDetail;
import com.bcxin.platform.dto.attend.AttendCalendarRestDetailDto;
import com.bcxin.platform.mapper.attend.AttendCalendarRestDetailMapper;
import com.bcxin.platform.mapper.attend.AttendCalendarRestMapper;
import com.bcxin.platform.service.attend.AttendCalendarRestService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(value="transactionManager")
public class AttendCalendarRestServiceImpl
implements AttendCalendarRestService {
    @Autowired
    private AttendCalendarRestMapper attendCalendarRestMapper;
    @Autowired
    private AttendCalendarRestDetailMapper attendCalendarRestDetailMapper;
    @Resource
    private IdWorker idWorker;

    @Override
    public AttendCalendarRest findById(Long id) {
        return this.attendCalendarRestMapper.findById(id);
    }

    @Override
    public List<AttendCalendarRestDetailDto> selectList(AttendCalendarRestDetailDto attendCalendarDetail) {
        return this.attendCalendarRestMapper.selectList(attendCalendarDetail);
    }

    @Override
    public int saveBatch(List<AttendCalendarRest> restList) {
        for (AttendCalendarRest attendCalendarRest : restList) {
            this.update(attendCalendarRest);
        }
        return restList.size();
    }

    @Override
    public int update(AttendCalendarRest attendCalendarRest) {
        AttendCalendarRestDetailDto attendCalendarRestDetailDto = new AttendCalendarRestDetailDto();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("beginTime", attendCalendarRest.getStartDate());
        params.put("endTime", attendCalendarRest.getEndDate());
        attendCalendarRestDetailDto.setParams(params);
        attendCalendarRestDetailDto.setCalendarId(attendCalendarRest.getCalendarId());
        List<AttendCalendarRestDetailDto> detailDtos = this.attendCalendarRestDetailMapper.selectList(attendCalendarRestDetailDto);
        if (detailDtos.size() > 0) {
            throw new BusinessException(attendCalendarRest.getStartDate() + "~" + attendCalendarRest.getEndDate() + "\u8be5\u65e5\u671f\u533a\u95f4\u5b58\u5728\u4ea4\u53c9\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\uff01");
        }
        if (attendCalendarRest.getId() == null) {
            attendCalendarRest.setCreateTime(DateUtils.getNowDate());
            attendCalendarRest.setId(this.idWorker.nextId());
            attendCalendarRest.setIsDelete("0");
        } else {
            AttendCalendarRest dbAttendCalendarDetail = this.attendCalendarRestMapper.findById(attendCalendarRest.getId());
            BeanUtils.copyPropertiesIgnore((Object)((Object)attendCalendarRest), (Object)((Object)dbAttendCalendarDetail), (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)((Object)dbAttendCalendarDetail), (Object)((Object)attendCalendarRest), (Boolean)false);
        }
        List betweenDates = DateUtil.getBetweenDates((String)attendCalendarRest.getStartDate(), (String)attendCalendarRest.getEndDate());
        ArrayList<AttendCalendarRestDetail> details = new ArrayList<AttendCalendarRestDetail>();
        AttendCalendarRestDetail attendCalendarRestDetail = null;
        for (Date betweenDate : betweenDates) {
            attendCalendarRestDetail = new AttendCalendarRestDetail();
            attendCalendarRestDetail.setId(this.idWorker.nextId());
            attendCalendarRestDetail.setCalendarId(attendCalendarRest.getCalendarId());
            attendCalendarRestDetail.setCalendarType(attendCalendarRest.getCalendarType());
            attendCalendarRestDetail.setRestDate(DateUtils.parseDateToStr((String)DateUtils.YYYY_MM_DD, (Date)betweenDate));
            attendCalendarRestDetail.setRestId(attendCalendarRest.getId());
            attendCalendarRestDetail.setCreateTime(DateUtils.getNowDate());
            attendCalendarRestDetail.setIsDelete("0");
            attendCalendarRestDetail.setUpdateTime(DateUtils.getNowDate());
            attendCalendarRestDetail.setUpdateBy(attendCalendarRest.getUpdateBy());
            attendCalendarRestDetail.setCreateBy(attendCalendarRest.getUpdateBy());
            details.add(attendCalendarRestDetail);
        }
        if (details.size() > 0) {
            this.attendCalendarRestDetailMapper.saveBatch(details);
        }
        attendCalendarRest.setUpdateTime(DateUtils.getNowDate());
        return this.attendCalendarRestMapper.save(attendCalendarRest);
    }

    @Override
    public int deleteByIds(String ids) {
        return this.attendCalendarRestMapper.deleteByIds(Convert.toStrArray((String)ids));
    }

    @Override
    public int deleteById(Long id) {
        return this.attendCalendarRestMapper.deleteById(id);
    }
}

