/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.service.attend.impl;

import com.bcxin.platform.common.core.text.Convert;
import com.bcxin.platform.common.exception.BusinessException;
import com.bcxin.platform.common.utils.DateUtils;
import com.bcxin.platform.common.utils.IdWorker;
import com.bcxin.platform.common.utils.bean.BeanUtils;
import com.bcxin.platform.domain.attend.AttendSchedulConflict;
import com.bcxin.platform.dto.app.AppAttendSchedulConflictDto;
import com.bcxin.platform.mapper.attend.AttendSchedulConflictMapper;
import com.bcxin.platform.mapper.attend.AttendSchedulDetailMapper;
import com.bcxin.platform.service.attend.AttendSchedulConflictService;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class AttendSchedulConflictServiceImpl
implements AttendSchedulConflictService {
    @Autowired
    private AttendSchedulConflictMapper attendSchedulConflictMapper;
    @Autowired
    private AttendSchedulDetailMapper attendSchedulDetailMapper;
    @Resource
    private IdWorker idWorker;

    @Override
    public AttendSchedulConflict findById(Long id) {
        return this.attendSchedulConflictMapper.findById(id);
    }

    @Override
    public List<AttendSchedulConflict> selectList(AttendSchedulConflict attendSchedulConflict) {
        return this.attendSchedulConflictMapper.selectList(attendSchedulConflict);
    }

    @Override
    public List<AppAttendSchedulConflictDto> findByAttendId(Long attendId) {
        return this.attendSchedulConflictMapper.findByAttenId(attendId);
    }

    @Override
    public int update(AttendSchedulConflict attendSchedulConflict) {
        if (attendSchedulConflict.getId() == null) {
            attendSchedulConflict.setCreateTime(DateUtils.getNowDate());
            attendSchedulConflict.setId(this.idWorker.nextId());
        } else {
            AttendSchedulConflict dbAttendSchedulConflict = this.attendSchedulConflictMapper.findById(attendSchedulConflict.getId());
            BeanUtils.copyPropertiesIgnore((Object)attendSchedulConflict, (Object)dbAttendSchedulConflict, (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)dbAttendSchedulConflict, (Object)attendSchedulConflict, (Boolean)false);
        }
        attendSchedulConflict.setUpdateTime(DateUtils.getNowDate());
        return this.attendSchedulConflictMapper.save(attendSchedulConflict);
    }

    @Override
    public int deleteByIds(String ids) {
        return this.attendSchedulConflictMapper.deleteByIds(Convert.toStrArray((String)ids));
    }

    @Override
    public int deleteById(Long id) {
        return this.attendSchedulConflictMapper.deleteById(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int cover(AttendSchedulConflict attendSchedulConflict) {
        Long l = attendSchedulConflict.getId();
        synchronized (l) {
            AttendSchedulConflict schedulConflict = this.attendSchedulConflictMapper.findById(attendSchedulConflict.getId());
            if ("1".equals(schedulConflict.getIsDelete())) {
                throw new BusinessException("\u8be5\u51b2\u7a81\u5df2\u91cd\u6392\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\uff01");
            }
            if ("1".equals(schedulConflict.getConflictState())) {
                throw new BusinessException("\u8be5\u51b2\u7a81\u5df2\u8986\u76d6\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\uff01");
            }
            this.attendSchedulDetailMapper.save(schedulConflict);
            this.attendSchedulConflictMapper.coverSchedul(attendSchedulConflict);
            return this.attendSchedulConflictMapper.coverConflict(attendSchedulConflict);
        }
    }
}

