/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.service.attend.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.bcxin.oaflow.mapper.MakeUpCardMapper;
import com.bcxin.platform.common.core.text.Convert;
import com.bcxin.platform.common.exception.BusinessException;
import com.bcxin.platform.common.utils.DateUtils;
import com.bcxin.platform.common.utils.IdWorker;
import com.bcxin.platform.common.utils.bean.BeanUtils;
import com.bcxin.platform.domain.attend.Attend;
import com.bcxin.platform.domain.attend.AttendAddress;
import com.bcxin.platform.domain.attend.AttendCharge;
import com.bcxin.platform.domain.attend.AttendPer;
import com.bcxin.platform.domain.attend.AttendShift;
import com.bcxin.platform.domain.attend.AttendWifi;
import com.bcxin.platform.domain.company.PerBaseInfo;
import com.bcxin.platform.domain.company.PerOrgRelation;
import com.bcxin.platform.dto.app.AppAttendDto;
import com.bcxin.platform.dto.app.AppAttendEditDto;
import com.bcxin.platform.dto.app.AppAttendManageDto;
import com.bcxin.platform.dto.app.AppAttendSchedulClockDto;
import com.bcxin.platform.dto.app.AppAttendSearchDto;
import com.bcxin.platform.dto.attend.AttendDto;
import com.bcxin.platform.mapper.attend.AttendAddressMapper;
import com.bcxin.platform.mapper.attend.AttendChargeMapper;
import com.bcxin.platform.mapper.attend.AttendClockMapper;
import com.bcxin.platform.mapper.attend.AttendMapper;
import com.bcxin.platform.mapper.attend.AttendPerMapper;
import com.bcxin.platform.mapper.attend.AttendShiftMapper;
import com.bcxin.platform.mapper.attend.AttendWifiMapper;
import com.bcxin.platform.mapper.company.PerBaseInfoMapper;
import com.bcxin.platform.mapper.company.PerOrgRelationMapper;
import com.bcxin.platform.service.attend.AttendService;
import com.bcxin.platform.service.attend.AttendShiftService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(value="transactionManager")
public class AttendServiceImpl
implements AttendService {
    @Autowired
    private AttendShiftService attendShiftService;
    @Autowired
    private AttendMapper attendMapper;
    @Autowired
    private AttendShiftMapper attendShiftMapper;
    @Autowired
    private AttendChargeMapper attendChargeMapper;
    @Autowired
    private AttendClockMapper attendClockMapper;
    @Autowired
    private MakeUpCardMapper makeUpCardMapper;
    @Autowired
    private PerBaseInfoMapper perBaseInfoMapper;
    @Autowired
    private PerOrgRelationMapper perOrgRelationMapper;
    @Autowired
    private AttendPerMapper attendPerMapper;
    @Autowired
    private AttendAddressMapper attendAddressMapper;
    @Autowired
    private AttendWifiMapper attendWifiMapper;
    @Resource
    private IdWorker idWorker;

    @Override
    public Attend findById(Long id) {
        Attend attend = this.attendMapper.findById(id);
        if (attend != null) {
            List<PerBaseInfo> chargeList = this.attendChargeMapper.findPerByAttendId(id);
            attend.setChargeList(chargeList);
            List chargeIds = chargeList.stream().map(PerBaseInfo::getPerId).collect(Collectors.toList());
            List<String> charges = chargeIds.stream().map(s -> s.toString()).collect(Collectors.toList());
            attend.setChargeIds(charges.toArray(new String[0]));
            attend.setAddressList(this.attendAddressMapper.findByAttendId(id));
            attend.setWifiList(this.attendWifiMapper.findByAttendId(id));
            List<AttendPer> perList = this.attendPerMapper.findByAttendId(id);
            attend.setPerNum(perList.size());
        }
        return attend;
    }

    @Override
    public AppAttendDto findByPerId(AppAttendSearchDto searchDto) {
        Attend attend = this.attendMapper.findByPerId(searchDto.getPerId());
        if (attend == null) {
            return null;
        }
        AppAttendDto appAttend = new AppAttendDto();
        BeanUtils.copyPropertiesIgnore((Object)((Object)attend), (Object)((Object)appAttend), (Boolean)false);
        List<AppAttendSchedulClockDto> schedulClockList = this.attendClockMapper.selectListForApp(searchDto);
        Integer clockCount = 0;
        Integer missCount = 0;
        if ("2".equals(attend.getShiftType())) {
            appAttend.setTotal(schedulClockList.size());
        } else {
            appAttend.setTotal(schedulClockList.size() * 2);
        }
        if (schedulClockList.size() > 0) {
            appAttend.setSchedulClockList(schedulClockList);
            for (AppAttendSchedulClockDto schedulClockDto : schedulClockList) {
                Integer n;
                Integer n2;
                if (StrUtil.isNotEmpty((CharSequence)schedulClockDto.getClockStart())) {
                    n2 = clockCount;
                    n = clockCount = Integer.valueOf(clockCount + 1);
                }
                if (StrUtil.isNotEmpty((CharSequence)schedulClockDto.getClockEnd())) {
                    n2 = clockCount;
                    n = clockCount = Integer.valueOf(clockCount + 1);
                }
                if ("21".equals(schedulClockDto.getClockStatus()) || "22".equals(schedulClockDto.getClockStatus()) || "23".equals(schedulClockDto.getClockStatus()) || "24".equals(schedulClockDto.getClockStatus())) {
                    n2 = missCount;
                    n = missCount = Integer.valueOf(missCount + 1);
                    continue;
                }
                if ("3".equals(schedulClockDto.getClockStatus())) {
                    if ("2".equals(schedulClockDto.getShiftType()) || !StrUtil.isEmpty((CharSequence)schedulClockDto.getClockEnd()) || DateUtils.parseDate((Object)schedulClockDto.getEndTime()).getTime() >= DateUtils.addMinutes((Date)DateUtils.getNowDate(), (int)-30).getTime()) continue;
                    schedulClockDto.setClockStatus("23");
                    continue;
                }
                if ("5".equals(schedulClockDto.getClockStatus())) {
                    if ("1".equals(schedulClockDto.getShiftType())) {
                        missCount = missCount + 2;
                        continue;
                    }
                    missCount = missCount + 1;
                    continue;
                }
                if (!StrUtil.isEmpty((CharSequence)schedulClockDto.getClockStatus()) || "2".equals(schedulClockDto.getShiftType()) || DateUtils.parseDate((Object)schedulClockDto.getEndTime()).getTime() >= DateUtils.getNowDate().getTime()) continue;
                if (StrUtil.isEmpty((CharSequence)schedulClockDto.getClockStart())) {
                    if (DateUtils.parseDate((Object)schedulClockDto.getEndTime()).getTime() < DateUtils.addMinutes((Date)DateUtils.getNowDate(), (int)-30).getTime()) {
                        schedulClockDto.setClockStatus("5");
                        missCount = missCount + 2;
                        continue;
                    }
                    schedulClockDto.setClockStatus("21");
                    n2 = missCount;
                    n = missCount = Integer.valueOf(missCount + 1);
                    continue;
                }
                if (DateUtils.parseDate((Object)schedulClockDto.getEndTime()).getTime() >= DateUtils.addMinutes((Date)DateUtils.getNowDate(), (int)-30).getTime()) continue;
                schedulClockDto.setClockStatus("22");
                n2 = missCount;
                n = missCount = Integer.valueOf(missCount + 1);
            }
        }
        appAttend.setClockCount(clockCount);
        appAttend.setMissCount(missCount);
        appAttend.setAddressList(this.attendAddressMapper.findByAttendId(appAttend.getId()));
        appAttend.setWifiList(this.attendWifiMapper.findByAttendId(appAttend.getId()));
        return appAttend;
    }

    @Override
    public Integer getCountLimit(AppAttendSearchDto searchDto) {
        Attend attend = this.attendMapper.findByPerId(searchDto.getPerId());
        if (attend == null) {
            return 0;
        }
        PerBaseInfo perBaseInfo = this.perBaseInfoMapper.selectPerBaseInfoById(searchDto.getPerId());
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("beginTime", DateUtils.parseDateToStr((String)DateUtils.YYYY_MM_DD, (Date)DateUtil.beginOfMonth((Date)DateUtils.addMonths((Date)DateUtils.getNowDate(), (int)-1)).toJdkDate()));
        paramMap.put("endTime", DateUtils.getDate());
        paramMap.put("tlkPerId", perBaseInfo.getTlkPerId());
        Integer count = this.makeUpCardMapper.getCount(perBaseInfo.getTlkPerId(), searchDto.getSchedulDate());
        return attend.getCountLimit() != null ? Integer.valueOf(attend.getCountLimit() - count) : null;
    }

    @Override
    public List<Attend> selectList(AttendDto searchDto) {
        if (!(searchDto.isDomainAdmin() || searchDto.getAdminDepartIds() != null && searchDto.getAdminDepartIds().size() != 0)) {
            return new ArrayList<Attend>();
        }
        return this.attendMapper.selectList(searchDto);
    }

    @Override
    public List<Attend> selectListForPer(AttendDto attend) {
        return this.attendMapper.selectListForPer(attend);
    }

    @Override
    public List<Attend> selectListForChargePer(AttendDto attend) {
        return this.attendMapper.selectListForChargePer(attend);
    }

    @Override
    public List<AppAttendManageDto> selectManageListForChargePer(AttendDto attend) {
        return this.attendMapper.selectManageListForChargePer(attend);
    }

    @Override
    public int updateForApp(AppAttendEditDto attend) {
        int count = this.update(attend);
        if (attend.getPerIds() != null && attend.getPerIds().length > 0) {
            AttendPer attendPer = null;
            ArrayList<AttendPer> perList = new ArrayList<AttendPer>();
            for (String perId : attend.getPerIds()) {
                attendPer = new AttendPer();
                attendPer.setAttendId(attend.getId());
                attendPer.setComId(attend.getComId());
                attendPer.setId(this.idWorker.nextId());
                attendPer.setPerId(Long.parseLong(perId));
                attendPer.setCreateTime(DateUtils.getNowDate());
                attendPer.setCreateBy(attend.getCreateBy());
                attendPer.setIsDelete("0");
                attendPer.setUpdateBy(attend.getUpdateBy());
                attendPer.setUpdateTime(DateUtils.getNowDate());
                perList.add(attendPer);
            }
            this.attendPerMapper.saveBatch(perList);
        }
        if (attend.getShiftList() != null && attend.getShiftList().size() > 0) {
            Long deptId = null;
            if (StrUtil.isNotEmpty((CharSequence)attend.getCreateBy())) {
                PerOrgRelation perOrgRelation = this.perOrgRelationMapper.findByPerId(Long.parseLong(attend.getCreateBy()));
                deptId = perOrgRelation.getOrgId();
            }
            for (AttendShift attendShift : attend.getShiftList()) {
                attendShift.setAttendId(attend.getId());
                attendShift.setShiftType(attend.getShiftType());
                this.attendShiftService.validateData(attendShift);
                attendShift.setCreateTime(DateUtils.getNowDate());
                attendShift.setUpdateTime(DateUtils.getNowDate());
                attendShift.setCreateBy(attend.getCreateBy());
                attendShift.setUpdateBy(attend.getUpdateBy());
                attendShift.setId(this.idWorker.nextId());
                attendShift.setIsDelete("0");
                attendShift.setDeptId(deptId);
                if ("2".equals(attend.getShiftType())) {
                    attendShift.setShiftHour(null);
                    attendShift.setEndTime(null);
                    attendShift.setNeedRest("0");
                }
                if (!"0".equals(attendShift.getNeedRest())) continue;
                attendShift.setRestStart(null);
                attendShift.setRestEnd(null);
                attendShift.setRestHour(0.0);
            }
            this.attendShiftMapper.saveBatch(attend.getShiftList());
        }
        if (attend.getAddressList() != null && "0".equals(attend.getClockType())) {
            for (AttendAddress attendAddress : attend.getAddressList()) {
                attendAddress.setIsDelete("0");
                if (attendAddress.getId() == null) {
                    attendAddress.setId(this.idWorker.nextId());
                    attendAddress.setCreateBy(attend.getCreateBy());
                    attendAddress.setCreateTime(attend.getCreateTime());
                }
                attendAddress.setUpdateBy(attend.getCreateBy());
                attendAddress.setUpdateTime(attend.getCreateTime());
                attendAddress.setAttendId(attend.getId());
            }
            this.attendAddressMapper.saveBatch(attend.getAddressList());
        }
        if (attend.getWifiList() != null && "1".equals(attend.getClockType())) {
            for (AttendWifi attendWifi : attend.getWifiList()) {
                attendWifi.setIsDelete("0");
                if (attendWifi.getId() == null) {
                    attendWifi.setId(this.idWorker.nextId());
                    attendWifi.setCreateBy(attend.getCreateBy());
                    attendWifi.setCreateTime(attend.getCreateTime());
                }
                attendWifi.setUpdateBy(attend.getCreateBy());
                attendWifi.setUpdateTime(attend.getCreateTime());
                attendWifi.setAttendId(attend.getId());
            }
            this.attendWifiMapper.saveBatch(attend.getWifiList());
        }
        return count;
    }

    @Override
    public int update(Attend attend) {
        Attend dbAttend = this.attendMapper.findbyName(attend.getAttendName());
        if (dbAttend != null && !dbAttend.getId().equals(attend.getId())) {
            throw new BusinessException("\u3010" + attend.getAttendName() + "\u3011\u8be5\u8003\u52e4\u5957\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\uff01");
        }
        if (attend.getId() == null) {
            attend.setCreateTime(DateUtils.getNowDate());
            attend.setId(this.idWorker.nextId());
            attend.setIsDelete("0");
            if (StrUtil.isEmpty((CharSequence)attend.getActive())) {
                attend.setActive("0");
            }
        } else {
            List<Attend> attends = this.attendMapper.findUsedList(Convert.toStrArray((String)attend.getId().toString()));
            Iterator<Attend> iterator = attends.iterator();
            if (iterator.hasNext()) {
                Attend existAttend = iterator.next();
                throw new BusinessException("\u3010" + attend.getAttendName() + "\u3011\u8be5\u8003\u52e4\u5957\u5728\u4f7f\u7528\u4e2d\uff0c\u4e0d\u80fd\u4fee\u6539\uff01");
            }
            dbAttend = this.attendMapper.findById(attend.getId());
            BeanUtils.copyPropertiesIgnore((Object)((Object)attend), (Object)((Object)dbAttend), (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)((Object)dbAttend), (Object)((Object)attend), (Boolean)false);
        }
        attend.setUpdateTime(DateUtils.getNowDate());
        if (attend.getChargeIds() != null && attend.getChargeIds().length > 0) {
            List<AttendCharge> chargeList = this.attendChargeMapper.findByAttendId(attend.getId());
            Map chargeMap = chargeList.stream().collect(Collectors.toMap(AttendCharge::getPerId, Function.identity()));
            Map chargeIdMap = Arrays.stream(attend.getChargeIds()).collect(Collectors.toMap(String::toString, Function.identity()));
            ArrayList<AttendCharge> saveList = new ArrayList<AttendCharge>();
            AttendCharge saveCharge = null;
            for (String chargeId : attend.getChargeIds()) {
                if (chargeMap.get(Long.parseLong(chargeId)) != null) continue;
                saveCharge = new AttendCharge();
                saveCharge.setIsDelete("0");
                saveCharge.setAttendId(attend.getId());
                saveCharge.setPerId(Long.parseLong(chargeId));
                saveCharge.setCreateTime(DateUtils.getNowDate());
                saveCharge.setCreateBy(attend.getUpdateBy());
                saveCharge.setUpdateTime(DateUtils.getNowDate());
                saveCharge.setUpdateBy(attend.getUpdateBy());
                saveList.add(saveCharge);
            }
            for (AttendCharge attendCharge : chargeList) {
                if (chargeIdMap.get(attendCharge.getPerId().toString()) != null) continue;
                attendCharge.setIsDelete("1");
                attendCharge.setUpdateBy(attend.getUpdateBy());
                attendCharge.setUpdateTime(DateUtils.getNowDate());
                saveList.add(attendCharge);
            }
            if (saveList.size() > 0) {
                this.attendChargeMapper.saveBatch(saveList);
            }
        }
        return this.attendMapper.save(attend);
    }

    @Override
    public int deleteByIds(String ids) {
        List<Attend> attends = this.attendMapper.findByArrIds(Convert.toStrArray((String)ids));
        for (Attend attend : attends) {
            if (!"1".equals(attend.getActive())) continue;
            throw new BusinessException("\u3010" + attend.getAttendName() + "\u3011\u8be5\u8003\u52e4\u5957\u542f\u7528\u4e2d\uff0c\u4e0d\u80fd\u5220\u9664\uff01");
        }
        attends = this.attendMapper.findUsedList(Convert.toStrArray((String)ids));
        Iterator<Attend> iterator = attends.iterator();
        if (iterator.hasNext()) {
            Attend attend;
            attend = iterator.next();
            throw new BusinessException("\u3010" + attend.getAttendName() + "\u3011\u8be5\u8003\u52e4\u5957\u5728\u4f7f\u7528\u4e2d\uff0c\u4e0d\u80fd\u5220\u9664\uff01");
        }
        return this.attendMapper.deleteByIds(Convert.toStrArray((String)ids));
    }
}

