/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.webservice.police.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.log.BjRestLogDao;
import com.bcxin.ars.dao.sb.BackgroundApprovalDao;
import com.bcxin.ars.dto.sb.BackgroundApprovalDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.PersonBaseInfo;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.model.log.BjRestLog;
import com.bcxin.ars.model.sb.BackgroundApproval;
import com.bcxin.ars.model.sb.Personcertificate;
import com.bcxin.ars.service.ConfigService;
import com.bcxin.ars.service.sys.SysareaService;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.redis.RedisUtil;
import com.bcxin.ars.webservice.impl.SNBackGroupCensorServiceImpl;
import com.bcxin.ars.webservice.police.SecurityInterfaceService;
import com.bcxin.ars.webservice.police.enums.ResultType;
import com.bcxin.ars.webservice.util.SubStringUtil;
import com.founderinternation.datacenter.datadownload.client.DataDownLoadFactory;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="securityInterfaceService_450000")
public class GXSecurityInterfaceService
implements SecurityInterfaceService {
    private static Logger logger = LoggerFactory.getLogger(SNBackGroupCensorServiceImpl.class);
    @Autowired
    private BjRestLogDao bjRestLogDao;
    @Autowired
    private ConfigService configService;
    @Autowired
    private SysareaService sysareaService;
    @Autowired
    private BackgroundApprovalDao backgroundApprovalDao;
    private static final String url = "http://10.151.151.83:8080/dataexchangeserver/innetApiPayload";
    public static final String GX_APINAME_CZ = "gxtqdsj_R-450000230000-00002892";
    public static final String GX_APINAME_ZT = "gxtqdsj_R-450000230000-00001622";
    public static final String GX_SENDER_ID = "94934D2A-9B28-4A1B-9C0A-A20E767BF3E1";
    public static final String GX_AUTHCODE = "YzBkNzRiOWQtMWRiOC00MjkzLTlhYjUtNzdkMDBlNDVjOTZh";
    @Value(value="${ZAFLAG}")
    private String ZAFLAG;
    @Autowired
    private RedisUtil redisUtil;

    private String call(List<String> idnums, List<String> parafs) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("areaCode", "450100000000");
        params.put("qqdwdm", "\u5357\u5b81\u5e02\u516c\u5b89\u5c40");
        params.put("qqdwmc", "450100000000");
        params.put("qqr", "450100210000");
        params.put("qqrsfzh", "450100210000");
        params.put("messageSequence", UUID.randomUUID());
        params.put("condition", " CERT_NO in (" + SubStringUtil.getStr(idnums) + ") and PERSON_STAT_NAME='\u6709\u6548'");
        params.put("parafs", parafs);
        params.put("maxReturnNum", "200");
        paramMap.put("authCode", GX_AUTHCODE);
        paramMap.put("apiName", GX_APINAME_CZ);
        paramMap.put("params", JSON.toJSONString(params));
        logger.error("\u5e7f\u897f\u4eba\u53e3\u4fe1\u606f\u7ba1\u7406\u7cfb\u7edf-\u5e38\u4f4f\u4eba\u53e3\u4fe1\u606f\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(paramMap));
        logger.error("\u5e7f\u897f\u4eba\u53e3\u4fe1\u606f\u7ba1\u7406\u7cfb\u7edf-\u5e38\u4f4f\u4eba\u53e3\u4fe1\u606f\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)url);
        String result = this.postWithJson(url, paramMap);
        logger.error("\u5e7f\u897f\u4eba\u53e3\u4fe1\u606f\u7ba1\u7406\u7cfb\u7edf-\u5e38\u4f4f\u4eba\u53e3\u4fe1\u606f\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)result);
        return result;
    }

    @Override
    public void censorPerson(List<SecurityPerson> personList) {
        List<String> idnumList = personList.stream().map(SecurityPerson::getIdNumber).collect(Collectors.toList());
        Map<String, PersonBaseInfo> personMap = this.getPersonInfo(idnumList, ResultType.NAME);
        Map<String, PersonBaseInfo> wfMap = this.isKeyPersons(idnumList);
        Map<String, PersonBaseInfo> dtMap = this.isEscapedPerson(idnumList);
        for (SecurityPerson securityPerson : personList) {
            BackgroundApprovalDto dto = new BackgroundApprovalDto();
            dto.setIdNumber(securityPerson.getIdNumber());
            dto.setRealName(securityPerson.getRealName());
            dto.setBusinessid(securityPerson.getId());
            dto.setBusinesstype("15");
            dto.setAuthState(securityPerson.getIdentityAuthState());
            securityPerson.setBackgroundApprovals(this.censor(dto, personMap.get(securityPerson.getIdNumber()), wfMap.get(securityPerson.getIdNumber()), dtMap.get(securityPerson.getIdNumber())));
        }
    }

    @Override
    public void censoRenrollQualification(List<Personcertificate> personList) {
        List<String> idnumList = personList.stream().map(Personcertificate::getCardnumber).collect(Collectors.toList());
        Map<String, PersonBaseInfo> personMap = this.getPersonInfo(idnumList, ResultType.PERSON);
        Map<String, PersonBaseInfo> wfMap = this.isKeyPersons(idnumList);
        Map<String, PersonBaseInfo> dtMap = this.isEscapedPerson(idnumList);
        for (Personcertificate personcertificate : personList) {
            BackgroundApprovalDto dto = new BackgroundApprovalDto();
            dto.setBusinessid(personcertificate.getId());
            dto.setBusinesstype("5");
            dto.setIdNumber(personcertificate.getCardnumber());
            dto.setRealName(personcertificate.getName());
            PersonBaseInfo personBaseInfo = personMap.get(personcertificate.getCardnumber());
            if (personBaseInfo != null && StringUtil.isNotEmpty((String)personBaseInfo.getAddress())) {
                personcertificate.setPopulationAddress(personBaseInfo.getAddress());
            }
            personcertificate.setBackgroundApprovals(this.censor(dto, personBaseInfo, wfMap.get(personcertificate.getCardnumber()), dtMap.get(personcertificate.getCardnumber())));
        }
    }

    @Override
    public void censorNewPerson(List<SecurityPerson> personList) {
    }

    @Override
    public void censorNewQualification(List<Personcertificate> personList) {
    }

    public List<BackgroundApproval> censor(BackgroundApprovalDto dto, PersonBaseInfo czPerson, PersonBaseInfo dtPerson, PersonBaseInfo wfPerson) {
        ArrayList<BackgroundApproval> list = new ArrayList<BackgroundApproval>();
        try {
            BackgroundApproval backgroundApproval = new BackgroundApproval();
            backgroundApproval.setActive(Boolean.valueOf(true));
            backgroundApproval.setCreateTime(new Date());
            backgroundApproval.setUpdateTime(new Date());
            backgroundApproval.setApprovaldate(new Date());
            backgroundApproval.setBusinesstype(dto.getBusinesstype());
            backgroundApproval.setBusinessid(dto.getBusinessid());
            BackgroundApproval cz_BackgroundApproval = backgroundApproval.clone();
            cz_BackgroundApproval.setLibraryType("1");
            BackgroundApproval dt_BackgroundApproval = cz_BackgroundApproval.clone();
            dt_BackgroundApproval.setLibraryType("3");
            BackgroundApproval wf_BackgroundApproval = cz_BackgroundApproval.clone();
            dt_BackgroundApproval.setLibraryType("4");
            if (czPerson != null) {
                if (StringUtil.isNotEmpty((String)czPerson.getName()) && dto.getRealName().equals(czPerson.getName())) {
                    cz_BackgroundApproval.setApprovalreason("\u4e3b\u9879\u4fe1\u606f\u7b26\u5408");
                    cz_BackgroundApproval.setApprovalstate("003");
                    cz_BackgroundApproval.setRgapprovalstate("003");
                } else {
                    cz_BackgroundApproval.setApprovalreason("\u59d3\u540d\u4fe1\u606f\u6709\u8bef");
                    cz_BackgroundApproval.setApprovalstate("004");
                    cz_BackgroundApproval.setRgapprovalstate("004");
                }
            } else {
                cz_BackgroundApproval.setApprovalreason("\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728");
                cz_BackgroundApproval.setApprovalstate("004");
                cz_BackgroundApproval.setRgapprovalstate("004");
            }
            list.add(cz_BackgroundApproval);
            if (dtPerson != null) {
                dt_BackgroundApproval.setApprovalreason("\u5728\u9003\u4eba\u5458");
                dt_BackgroundApproval.setApprovalstate("004");
                dt_BackgroundApproval.setRgapprovalstate("004");
            } else {
                dt_BackgroundApproval.setApprovalreason("\u65e0\u5728\u9003\u8bb0\u5f55");
                dt_BackgroundApproval.setApprovalstate("003");
                dt_BackgroundApproval.setRgapprovalstate("003");
            }
            list.add(dt_BackgroundApproval);
            if (wfPerson != null) {
                wf_BackgroundApproval.setApprovalreason("\u6709\u8fdd\u6cd5\u72af\u7f6a\u8bb0\u5f55");
                wf_BackgroundApproval.setApprovalstate("004");
                wf_BackgroundApproval.setRgapprovalstate("004");
            } else {
                wf_BackgroundApproval.setApprovalreason("\u65e0\u8fdd\u6cd5\u72af\u7f6a\u8bb0\u5f55");
                wf_BackgroundApproval.setApprovalstate("003");
                wf_BackgroundApproval.setRgapprovalstate("003");
            }
            list.add(wf_BackgroundApproval);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage(), (Throwable)e);
        }
        if (!"15".equals(dto.getBusinesstype()) && list != null && list.size() > 0) {
            this.backgroundApprovalDao.delete(dto);
            this.backgroundApprovalDao.batchSave(list);
        }
        return list;
    }

    @Override
    public Map<String, PersonBaseInfo> getPersonInfo(List<String> idnums, ResultType resultType) {
        HashMap<String, PersonBaseInfo> personList = new HashMap<String, PersonBaseInfo>();
        String code = "";
        if (this.ZAFLAG != null && this.ZAFLAG.equals("1")) {
            for (int i = 0; i < 3; ++i) {
                String totalRows;
                JSONObject result;
                ArrayList<String> parafs = new ArrayList<String>();
                parafs.add("NAME");
                parafs.add("CERT_NO");
                switch (resultType) {
                    case NAME: {
                        break;
                    }
                    case PHOTO: {
                        parafs.add("PHOTO");
                        break;
                    }
                    case PERSON: {
                        parafs.add("DOMIC_ADDR_NAME");
                        break;
                    }
                    default: {
                        parafs.add("PHOTO");
                        parafs.add("DOMIC_ADDR_NAME");
                    }
                }
                String requestResult = this.call(idnums, parafs);
                BjRestLog log = new BjRestLog();
                log.setResttype(GX_APINAME_CZ);
                if (!resultType.equals((Object)ResultType.PHOTO) && !resultType.equals((Object)ResultType.ALL)) {
                    log.setResponseContext(requestResult);
                }
                log.setRequestContext(JSON.toJSONString(idnums));
                log.setCreateTime(new Date());
                log.setActive(Boolean.valueOf(true));
                log.setUpdateTime(new Date());
                log.setUpdateBy("system");
                this.bjRestLogDao.save(log);
                if (requestResult != null && !requestResult.equals("") && "0".equals((result = JSON.parseObject((String)requestResult)).get((Object)"code")) && "200".equals((result = JSON.parseObject((String)result.get((Object)"result").toString())).get((Object)"status").toString()) && result.get((Object)"data") != null && Long.parseLong(totalRows = (result = JSON.parseObject((String)result.get((Object)"data").toString())).get((Object)"totalRows").toString()) > 0L) {
                    JSONArray results = JSONArray.parseArray((String)result.get((Object)"results").toString());
                    PersonBaseInfo person = null;
                    for (Object o : results) {
                        result = (JSONObject)o;
                        person = new PersonBaseInfo();
                        if (result.get((Object)"NAME") != null) {
                            person.setName(result.get((Object)"NAME").toString());
                        }
                        if (result.get((Object)"CERT_NO") != null) {
                            person.setIdnum(result.get((Object)"CERT_NO").toString());
                        }
                        if (result.get((Object)"DOMIC_ADDR_NAME") != null) {
                            person.setAddress(result.get((Object)"DOMIC_ADDR_NAME").toString());
                        }
                        if (result.get((Object)"PHOTO") != null) {
                            person.setPhoto(result.get((Object)"PHOTO").toString());
                        }
                        personList.put(person.getIdnum(), person);
                    }
                }
                if (!"000".equals(code)) {
                    continue;
                }
                break;
            }
        } else {
            code = "000";
        }
        if (!"000".equals(code)) {
            throw new ArsException("\u9655\u897f\u4eba\u53e3\u5e93\u8c03\u7528\u5f02\u5e38\uff01");
        }
        return personList;
    }

    @Override
    public Map<String, PersonBaseInfo> getNewPersonInfo(List<String> idnums) {
        return null;
    }

    private Map<String, PersonBaseInfo> isKeyPerson(List<String> idnums) {
        HashMap<String, PersonBaseInfo> personList = new HashMap<String, PersonBaseInfo>();
        try {
            DataDownLoadFactory dataDownLoadFactory = DataDownLoadFactory.getInstance();
            if (dataDownLoadFactory == null) {
                logger.error("DataDownLoadFactory\u5f02\u5e38");
            }
            String ip = "10.236.17.18";
            String port = "8212";
            String methodName = "QueryJzZdry";
            String tableCode = "010112";
            String senderId = GX_SENDER_ID;
            String condition = " SFZH in (" + SubStringUtil.getStr(idnums) + ") and YXX = '1' ";
            String[] fileds = new String[]{"XM", "ZDRYLBBJ"};
            int totalCount = 1;
            int waittime = 0;
            String result = dataDownLoadFactory.getFromRemote(ip, port, methodName, tableCode, senderId, condition, fileds, totalCount, waittime);
            logger.error("\u5e7f\u897f\u3010\u8b66\u7efc-\u91cd\u70b9\u4eba\u5458\u3011\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)result);
            long start = System.currentTimeMillis();
            int sum = 0;
            boolean isHadData = false;
            if ("success".equals(result) && (dataDownLoadFactory.getResultQueue() != null || !dataDownLoadFactory.isClose())) {
                while (!dataDownLoadFactory.getResultQueue().isEmpty() || !dataDownLoadFactory.isClose()) {
                    Object[] resultstr = (Object[])dataDownLoadFactory.getResultQueue().poll();
                    if (resultstr == null) {
                        Thread.sleep(1L);
                        continue;
                    }
                    isHadData = true;
                    System.out.println("sum:" + ++sum * 10000);
                    if (resultstr.length != 2 || resultstr[0] == null || resultstr[1] == null) continue;
                    List list = (List)resultstr[1];
                }
                logger.error("\u6570\u636e\u7ed3\u679c\u961f\u5217\uff1a" + isHadData);
                long end = System.currentTimeMillis();
                logger.error("\u8017\u65f6\uff1a" + (double)(end - start) / 1000.0 + " \u79d2");
                dataDownLoadFactory.closeSession();
                logger.error("\u8017\u65f6\uff1a" + (double)(System.currentTimeMillis() - start) / 1000.0 + " \u79d2");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage(), (Throwable)e);
            throw new ArsException("\u5e7f\u897f\u3010\u8b66\u7efc-\u91cd\u70b9\u4eba\u5458\u3011\u8c03\u7528\u5f02\u5e38\uff01\uff01");
        }
        return personList;
    }

    private Map<String, PersonBaseInfo> isKeyPersons(List<String> idnums) {
        HashMap<String, PersonBaseInfo> personList = new HashMap<String, PersonBaseInfo>();
        PersonBaseInfo person = null;
        for (String idnum : idnums) {
            if (!this.isKeyPerson(idnum)) continue;
            person = new PersonBaseInfo();
            person.setIdnum(idnum);
        }
        return personList;
    }

    private boolean isKeyPerson(String idnum) {
        try {
            DataDownLoadFactory dataDownLoadFactory = DataDownLoadFactory.getInstance();
            if (dataDownLoadFactory == null) {
                logger.error("DataDownLoadFactory\u5f02\u5e38");
            }
            String ip = "10.236.17.18";
            String port = "8212";
            String methodName = "QueryJzZdry";
            String tableCode = "010112";
            String senderId = GX_SENDER_ID;
            String condition = " SFZH ='" + idnum + "' and YXX = '1' ";
            String[] fileds = new String[]{"XM", "ZDRYLBBJ"};
            int totalCount = 1;
            int waittime = 0;
            String result = dataDownLoadFactory.getFromRemote(ip, port, methodName, tableCode, senderId, condition, fileds, totalCount, waittime);
            logger.error("\u5e7f\u897f\u3010\u8b66\u7efc-\u91cd\u70b9\u4eba\u5458\u3011\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)result);
            long start = System.currentTimeMillis();
            int sum = 0;
            boolean isHadData = false;
            if ("success".equals(result) && (dataDownLoadFactory.getResultQueue() != null || !dataDownLoadFactory.isClose())) {
                while (!dataDownLoadFactory.getResultQueue().isEmpty() || !dataDownLoadFactory.isClose()) {
                    Object[] resultstr = (Object[])dataDownLoadFactory.getResultQueue().poll();
                    if (resultstr == null) {
                        Thread.sleep(1L);
                        continue;
                    }
                    isHadData = true;
                    ++sum;
                    logger.error("\u5e7f\u897f\u3010\u8b66\u7efc-\u91cd\u70b9\u4eba\u5458\u3011\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)resultstr));
                    if (resultstr.length != 2 || resultstr[0] == null || resultstr[1] == null) continue;
                    List list = (List)resultstr[1];
                }
                logger.error("\u6570\u636e\u7ed3\u679c\u961f\u5217\uff1a" + isHadData);
                long end = System.currentTimeMillis();
                logger.error("\u8017\u65f6\uff1a" + (double)(end - start) / 1000.0 + " \u79d2");
                dataDownLoadFactory.closeSession();
                logger.error("\u8017\u65f6\uff1a" + (double)(System.currentTimeMillis() - start) / 1000.0 + " \u79d2");
            }
            return isHadData;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage(), (Throwable)e);
            throw new ArsException("\u5e7f\u897f\u3010\u8b66\u7efc-\u91cd\u70b9\u4eba\u5458\u3011\u8c03\u7528\u5f02\u5e38\uff01\uff01");
        }
    }

    private Map<String, PersonBaseInfo> isEscapedPerson(List<String> idnums) {
        HashMap<String, PersonBaseInfo> personList = new HashMap<String, PersonBaseInfo>();
        try {
            String totalRows;
            JSONObject result;
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            HashMap<String, Object> params = new HashMap<String, Object>();
            ArrayList<String> parafs = new ArrayList<String>();
            parafs.add("NAME");
            parafs.add("CERT_NO");
            parafs.add("UNDO_ORGA_PSAG_CODE");
            parafs.add("UNDO_JUDGE_FLAG");
            params.put("areaCode", "450100000000");
            params.put("qqdwdm", "\u5357\u5b81\u5e02\u516c\u5b89\u5c40");
            params.put("qqdwmc", "450100000000");
            params.put("qqr", "450100210000");
            params.put("qqrsfzh", "450100210000");
            params.put("messageSequence", UUID.randomUUID());
            params.put("condition", " CERT_NO in (" + SubStringUtil.getStr(idnums) + ")");
            params.put("parafs", parafs);
            params.put("maxReturnNum", "20");
            paramMap.put("authCode", GX_AUTHCODE);
            paramMap.put("apiName", GX_APINAME_ZT);
            paramMap.put("params", JSON.toJSONString(params));
            logger.error("\u5211\u4fa6\u4fe1\u606f\u4e13\u4e1a\u5e94\u7528\u7cfb\u7edf-\u5168\u56fd\u5728\u9003\u4eba\u5458\u4fe1\u606f\u8868\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(paramMap));
            logger.error("\u5211\u4fa6\u4fe1\u606f\u4e13\u4e1a\u5e94\u7528\u7cfb\u7edf-\u5168\u56fd\u5728\u9003\u4eba\u5458\u4fe1\u606f\u8868\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)url);
            String resultStr = this.postWithJson(url, paramMap);
            logger.error("\u5211\u4fa6\u4fe1\u606f\u4e13\u4e1a\u5e94\u7528\u7cfb\u7edf-\u5168\u56fd\u5728\u9003\u4eba\u5458\u4fe1\u606f\u8868\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)resultStr);
            BjRestLog log = new BjRestLog();
            log.setResttype(GX_APINAME_ZT);
            log.setResponseContext(resultStr);
            log.setRequestContext(JSON.toJSONString(idnums));
            log.setCreateTime(new Date());
            log.setActive(Boolean.valueOf(true));
            log.setUpdateTime(new Date());
            log.setUpdateBy("system");
            this.bjRestLogDao.save(log);
            if (StringUtil.isNotEmpty((String)resultStr) && "0".equals((result = JSON.parseObject((String)resultStr)).get((Object)"code")) && "200".equals((result = JSON.parseObject((String)result.get((Object)"result").toString())).get((Object)"status").toString()) && result.get((Object)"data") != null && Long.parseLong(totalRows = (result = JSON.parseObject((String)result.get((Object)"data").toString())).get((Object)"totalRows").toString()) > 0L) {
                JSONArray results = JSONArray.parseArray((String)result.get((Object)"results").toString());
                PersonBaseInfo person = null;
                for (Object o : results) {
                    result = (JSONObject)o;
                    person = new PersonBaseInfo();
                    if (result.get((Object)"NAME") != null) {
                        person.setName(result.get((Object)"NAME").toString());
                    }
                    if (result.get((Object)"CERT_NO") != null) {
                        person.setIdnum(result.get((Object)"CERT_NO").toString());
                    }
                    personList.put(person.getIdnum(), person);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage(), (Throwable)e);
            throw new ArsException("\u5211\u4fa6\u4fe1\u606f\u4e13\u4e1a\u5e94\u7528\u7cfb\u7edf-\u5168\u56fd\u5728\u9003\u4eba\u5458\u4fe1\u606f\u8c03\u7528\u5f02\u5e38\uff01\uff01");
        }
        return personList;
    }

    private String postWithJson(String requestUrl, Map<String, Object> paramMap) {
        String returnValue = "";
        CloseableHttpClient httpClient = HttpClients.createDefault();
        BasicResponseHandler responseHandler = new BasicResponseHandler();
        try {
            httpClient = HttpClients.createDefault();
            HttpPost httpPost = new HttpPost(requestUrl);
            RequestConfig.Builder requestConfig = RequestConfig.custom();
            requestConfig.setConnectTimeout(30000);
            requestConfig.setConnectionRequestTimeout(30000);
            requestConfig.setSocketTimeout(30000);
            StringEntity requestEntity = new StringEntity(JSON.toJSONString(paramMap), "utf-8");
            requestEntity.setContentEncoding("UTF-8");
            httpPost.setHeader("Content-type", "application/json");
            httpPost.setEntity((HttpEntity)requestEntity);
            httpPost.setConfig(requestConfig.build());
            returnValue = (String)httpClient.execute((HttpUriRequest)httpPost, (ResponseHandler)responseHandler);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
            throw new ArsException(requestUrl + "\uff1a\u63a5\u53e3\u8c03\u7528\u5f02\u5e38\uff01");
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return returnValue;
    }

    public static void main(String[] args) {
        ArrayList<String> idnums = new ArrayList<String>();
        idnums.add("1");
        idnums.add("1");
        idnums.add("1");
        idnums.add("1");
        StringBuilder idnumStr = new StringBuilder();
        for (String idnum : idnums) {
            idnumStr.append(idnum + ",");
        }
        idnumStr.substring(0, idnumStr.lastIndexOf(","));
        System.out.println(idnumStr.substring(0, idnumStr.lastIndexOf(",")));
        System.out.println(URLDecoder.decode("\\u6ca1\\u6709\\u67e5\\u8be2\\u5230\\u76f8\\u5173\\u4fe1\\u606f"));
    }
}

