package com.bcxin.ars.webservice.police.impl;

import com.alibaba.fastjson.JSON;
import com.bcxin.ars.dao.log.BjRestLogDao;
import com.bcxin.ars.dao.sb.BackgroundApprovalDao;
import com.bcxin.ars.dto.sb.BackgroundApprovalDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.PersonBaseInfo;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.model.log.BjRestLog;
import com.bcxin.ars.model.sb.BackgroundApproval;
import com.bcxin.ars.model.sb.Personcertificate;
import com.bcxin.ars.service.ConfigService;
import com.bcxin.ars.service.sys.SysareaService;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.redis.RedisUtil;
import com.bcxin.ars.webservice.impl.SNBackGroupCensorServiceImpl;
import com.bcxin.ars.webservice.police.SecurityInterfaceService;
import com.bcxin.ars.webservice.police.enums.ResultType;
import com.bcxin.ars.webservice.util.SubStringUtil;
import com.dragonsoft.node.adapter.comm.RbspCall;
import com.dragonsoft.node.adapter.comm.RbspConsts;
import com.dragonsoft.node.adapter.comm.RbspService;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.dom4j.tree.DefaultElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.io.ByteArrayInputStream;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

import static com.bcxin.ars.webservice.police.enums.ResultType.*;

/**
 * @Auther linqinglin
 * @date 2021/7/1 21:57
 */
@Service("securityInterfaceService_640000")
public class NXSecurityInterfaceService implements SecurityInterfaceService {

    /***
     * 日志
     */
    private static Logger logger = LoggerFactory.getLogger(SNBackGroupCensorServiceImpl.class);
    @Autowired
    private BjRestLogDao bjRestLogDao;

    @Value("${ZAFLAG}")
    private String ZAFLAG;

    @Value("${ZAURL}")
    private String ZAURL;

    @Autowired
    private ConfigService configService;

    @Autowired
    private SysareaService sysareaService;

    @Autowired
    private BackgroundApprovalDao backgroundApprovalDao;

    @Autowired
    private RedisUtil redisUtil;

    private String call(String requestID, String serviceID, List<String> idnums,String[] requiredItems,
                        String DataObjectCode,String InfoCodeMode ,String idType){
        String result = StringUtil.EMPTY;
        String key = DateUtil.getCurrentDate(DateUtil.FORMAT11)+"_"+serviceID;
        String count = redisUtil.get(key);
        if(StringUtil.isNotEmpty(count)){
            Long total = Long.parseLong(count);
            Long max = 8000L;
            try {
                String configValue = configService.getValueByKey(Constants.POLICE_INTERFACE_MAX);
                max = Long.parseLong(configValue);
            }catch (Exception e){

            }
            if (total >= max){
                return result;
            }
        }

        //数据保留7天
        redisUtil.getCount(key,7L);
        RbspService service = new RbspService(requestID, serviceID);
        //用户信息
        service.setUserCardId("asdfasd");
        service.setUserDept("0100");
        service.setUserName("ptjian");
        RbspCall call = service.createCall();
        call.setUrl(ZAURL);
        call.setMethod(RbspConsts.METHOD_QUERY);
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("DataObjectCode", DataObjectCode);
        params.put("InfoCodeMode", InfoCodeMode);
        //按身份证号查
        params.put("Condition", idType+ " in (" + SubStringUtil.getStr(idnums) + ")");
        //返回字段：身份证号、照片、姓名、性别、文化程度、民族、籍贯省县
        params.put("RequiredItems", requiredItems);
        logger.error("请求地址：{}",ZAURL);
        logger.error("请求参数：{}",JSON.toJSONString(params));
        result = call.invoke(params);
        logger.error("返回结果：{}",result);
        return result;
    }
    private String call(String requestID, String serviceID, String idnum,String[] requiredItems,
                        String DataObjectCode,String InfoCodeMode ,String idType){
        String result = StringUtil.EMPTY;
        String key = DateUtil.getCurrentDate(DateUtil.FORMAT11)+"_"+serviceID;
        String count = redisUtil.get(key);
        if(StringUtil.isNotEmpty(count)){
            Long total = Long.parseLong(count);
            Long max = 8000L;
            try {
                String configValue = configService.getValueByKey(Constants.POLICE_INTERFACE_MAX);
                max = Long.parseLong(configValue);
            }catch (Exception e){

            }
            if (total >= max){
                return result;
            }
        }

        //数据保留7天
        redisUtil.getCount(key,7L);
        RbspService service = new RbspService(requestID, serviceID);
        //用户信息
        service.setUserCardId("asdfasd");
        service.setUserDept("0100");
        service.setUserName("ptjian");
        RbspCall call = service.createCall();
        call.setUrl(ZAURL);
        call.setMethod(RbspConsts.METHOD_QUERY);
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("DataObjectCode", DataObjectCode);
        params.put("InfoCodeMode", InfoCodeMode);
        //按身份证号查
        params.put("Condition", idType+ "='" + idnum + "')");
        //返回字段：身份证号、照片、姓名、性别、文化程度、民族、籍贯省县
        params.put("RequiredItems", requiredItems);
        logger.error("请求地址：{}",ZAURL);
        logger.error("请求参数：{}",JSON.toJSONString(params));
        result = call.invoke(params);
        logger.error("返回结果：{}",result);
        return result;
    }

    @Override
    public  Map<String,PersonBaseInfo> getPersonInfo(List<String> idnums, ResultType resultType) {
        return getPersonInfo(Constants.NX_CZ_REQUESTID,Constants.NX_CZ_SERVICEID_INFO,idnums,
                resultType,Constants.NX_CZINFO_DataObjectCode,"002","GMSFHM");
    }

    @Override
    public Map<String, PersonBaseInfo> getNewPersonInfo(List<String> idnums) {
        return null;
    }

    /**
     * 保安员背景筛查
     * @param personList
     */
    @Override
    public void censorPerson(List<SecurityPerson> personList) {
        List<String> idnumList= personList.stream().map(SecurityPerson::getIdNumber).collect(Collectors.toList());
        Map<String,PersonBaseInfo> personMap = getPersonInfo(idnumList, ResultType.NAME);
        Map<String,PersonBaseInfo> xdMap = getPersonInfo(Constants.NX_XD_REQUESTID,Constants.NX_XD_SERVICEID,idnumList,
                ResultType.NAME,Constants.NX_ZDRY_DataObjectCode,"002","SFZH");
        Map<String,PersonBaseInfo> wfMap = getPersonInfo(Constants.NX_WF_REQUESTID,Constants.NX_WF_SERVICEID,idnumList,
                ResultType.NAME,Constants.NX_ZDRY_DataObjectCode,"002","SFZH");
        Map<String,PersonBaseInfo> dtMap = getPersonInfo(Constants.NX_DT_REQUESTID,Constants.NX_DT_SERVICEID,idnumList,
                ResultType.NAME,Constants.NX_ZDRY_DataObjectCode,"002","SFZH");

        for (SecurityPerson securityPerson : personList) {
            BackgroundApprovalDto dto = new BackgroundApprovalDto();
            //身份证号
            dto.setIdNumber(securityPerson.getIdNumber());
            //姓名
            dto.setRealName(securityPerson.getRealName());
            //主键
            dto.setBusinessid(securityPerson.getId());
            //问题人员
            dto.setBusinesstype(Constants.BAY_FZR);

            dto.setAuthState(securityPerson.getIdentityAuthState());

            securityPerson.setBackgroundApprovals(censor(dto,personMap.get(securityPerson.getIdNumber()),xdMap.get(securityPerson.getIdNumber()),wfMap.get(securityPerson.getIdNumber()),dtMap.get(securityPerson.getIdNumber())));
        }
    }

    /**
     * 资格证报名背景筛查
     * @param personList
     */
    @Override
    public void censoRenrollQualification(List<Personcertificate> personList) {
        List<String> idnumList= personList.stream().map(Personcertificate::getCardnumber).collect(Collectors.toList());
        Map<String,PersonBaseInfo> personMap = getPersonInfo(idnumList, PERSON);
        Map<String,PersonBaseInfo> xdMap = getPersonInfo(Constants.NX_XD_REQUESTID,Constants.NX_XD_SERVICEID,idnumList,
                ResultType.NAME,Constants.NX_ZDRY_DataObjectCode,"002","SFZH");
        Map<String,PersonBaseInfo> wfMap = getPersonInfo(Constants.NX_WF_REQUESTID,Constants.NX_WF_SERVICEID,idnumList,
                ResultType.NAME,Constants.NX_ZDRY_DataObjectCode,"002","SFZH");
        Map<String,PersonBaseInfo> dtMap = getPersonInfo(Constants.NX_DT_REQUESTID,Constants.NX_DT_SERVICEID,idnumList,
                ResultType.NAME,Constants.NX_ZDRY_DataObjectCode,"002","SFZH");

        for (Personcertificate personcertificate : personList) {
            BackgroundApprovalDto dto = new BackgroundApprovalDto();
            dto.setBusinessid(personcertificate.getId());
            dto.setBusinesstype(Constants.BAYZ);
            dto.setIdNumber(personcertificate.getCardnumber());
            dto.setRealName(personcertificate.getName());
            PersonBaseInfo personBaseInfo = personMap.get(personcertificate.getCardnumber());
            if (personBaseInfo != null && StringUtil.isNotEmpty(personBaseInfo.getAddress())) {
                personcertificate.setPopulationAddress(personBaseInfo.getAddress());
            }
            personcertificate.setBackgroundApprovals(censor(dto,personBaseInfo,xdMap.get(personcertificate.getCardnumber()),wfMap.get(personcertificate.getCardnumber()),dtMap.get(personcertificate.getCardnumber())));

        }

    }

    @Override
    public void censorNewPerson(List<SecurityPerson> personList) {

    }

    @Override
    public void censorNewQualification(List<Personcertificate> personList) {

    }

    /****
     * 背景筛查
     * @param dto 业务信息
     */
    public List<BackgroundApproval> censor(BackgroundApprovalDto dto,PersonBaseInfo czPerson,PersonBaseInfo xdPerson,PersonBaseInfo wfPerson,PersonBaseInfo dtPerson) {
        List<BackgroundApproval> list = new ArrayList<>();
        try {
            BackgroundApproval backgroundApproval = new BackgroundApproval();
            backgroundApproval.setActive(true);
            backgroundApproval.setCreateTime(new Date());
            backgroundApproval.setUpdateTime(new Date());
            backgroundApproval.setApprovaldate(new Date());
            backgroundApproval.setBusinesstype(dto.getBusinesstype());
            backgroundApproval.setBusinessid(dto.getBusinessid());

            BackgroundApproval cz_BackgroundApproval = backgroundApproval.clone();
            BackgroundApproval xd_BackgroundApproval = cz_BackgroundApproval.clone();

            xd_BackgroundApproval.setLibraryType(Constants.LIBRARYTYPE_XD);
            BackgroundApproval dt_BackgroundApproval = cz_BackgroundApproval.clone();
            dt_BackgroundApproval.setLibraryType(Constants.LIBRARYTYPE_DT);
            BackgroundApproval wf_BackgroundApproval = cz_BackgroundApproval.clone();
            dt_BackgroundApproval.setLibraryType(Constants.LIBRARYTYPE_WF);
            if(czPerson != null){
                if(StringUtil.isNotEmpty(czPerson.getName()) && dto.getRealName().equals(czPerson.getName())){
                    cz_BackgroundApproval.setApprovalreason("主项信息符合");
                    cz_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_TG);
                    cz_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_TG);
                }else{
                    //姓名信息不匹配
                    cz_BackgroundApproval.setApprovalreason(Constants.LIBRARYTYPE_CZ_FAIL_MESSAGE);
                    cz_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_BTG);
                    cz_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_BTG);
                }
            }else{
                cz_BackgroundApproval.setApprovalreason(Constants.LIBRARYTYPE_CZ_FAIL);
                cz_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_BTG);
                cz_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_BTG);
            }
            list.add(cz_BackgroundApproval);

            if(xdPerson != null){
                xd_BackgroundApproval.setApprovalreason("吸毒人员");
                xd_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_BTG);
                xd_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_BTG);
            }else{
                xd_BackgroundApproval.setApprovalreason("无吸毒记录");
                xd_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_TG);
                xd_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_TG);
            }
            list.add(xd_BackgroundApproval);
            if(dtPerson != null){
                dt_BackgroundApproval.setApprovalreason("在逃人员");
                dt_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_BTG);
                dt_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_BTG);
            }else{
                dt_BackgroundApproval.setApprovalreason("无在逃记录");
                dt_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_TG);
                dt_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_TG);
            }
            list.add(dt_BackgroundApproval);
            if(wfPerson != null){
                wf_BackgroundApproval.setApprovalreason("有违法犯罪记录");
                wf_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_BTG);
                wf_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_BTG);
            }else{
                wf_BackgroundApproval.setApprovalreason("无违法犯罪记录");
                wf_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_TG);
                wf_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_TG);
            }
            list.add(wf_BackgroundApproval);
        }catch (Exception e){
            e.printStackTrace();
            logger.error(e.getMessage(),e);
        }
        //问题人员无须保存
        if(!Constants.BAY_FZR.equals(dto.getBusinesstype()) && list != null && list.size() > 0) {
            //如果有记录的话，删除以前记录信息
            backgroundApprovalDao.delete(dto);
            //批量保存
            backgroundApprovalDao.batchSave(list);
        }

        return list;
    }

    public  Map<String,PersonBaseInfo> getPersonInfo(String requestID, String serviceID, List<String> idnums,
                                                     ResultType resultType,String DataObjectCode,String InfoCodeMode,
                                                     String idType) {
        Map<String,PersonBaseInfo> personList = new HashMap<>();
        String code = "";
        if(ZAFLAG!=null && ZAFLAG.equals(Constants.ZAFLAG_YES)) {
            //人口库调用会异常或超时，循环三次，三次还是异常或超时，则获取失败
            for(int i = 0; i< Constants.ZAFLAG_COUNT; i++) {
                String[] requiredItems = null;
                switch (resultType){
                    case NAME:
                        requiredItems= new String[]{idType,Constants.INFO_XM};
                        break;
                    case PHOTO:
                        requiredItems= new String[]{idType,Constants.INFO_XM};
                        break;
                    case PERSON:
                        requiredItems= new String[]{idType,Constants.INFO_XM,Constants.INFO_JGSSX,Constants.INFO_ZZ};
                        break;
                    default:
                        requiredItems= new String[]{idType,Constants.INFO_XM,Constants.INFO_JGSSX,Constants.INFO_ZZ};
                        break;
                }

                String requestResult = call(requestID,serviceID,idnums,requiredItems,Constants.NX_CZINFO_DataObjectCode,"002",idType);
                //增加日志
                BjRestLog log = new BjRestLog();
                log.setResttype(serviceID);

                if(!resultType.equals(PHOTO) && !resultType.equals(ALL)) {
                    log.setResponseContext(requestResult);
                }
                log.setRequestContext(JSON.toJSONString(idnums));
                //创建时间
                log.setCreateTime(new Date());
                //有效标记
                log.setActive(true);
                //更新时间
                log.setUpdateTime(new Date());
                //更新者
                log.setUpdateBy(Constants.APPROVAL_SYSTEM);
                bjRestLogDao.save(log);
                //如果不为空则没有数据
                if (requestResult != null && !requestResult.equals("")) {
                    try {
                        String pattern = "\\s{2,}";
                        Pattern r = Pattern.compile(pattern);
                        Matcher m = r.matcher(requestResult);
                        requestResult = m.replaceAll("");
                        SAXReader reader = new SAXReader();
                        Document doc = reader.read(new ByteArrayInputStream(requestResult.getBytes("UTF-8")));
                        Element root = doc.getRootElement();
                        Element valueElement = root.element("Method").element("Items").element("Item").element("Value");
                        //valueElement节点为空的话，请求人口库异常
                        if (valueElement != null) {
                            List<Element> list = valueElement.elements();
                            //获取执行返回编码
                            if(list!=null &&  list.size()>0){
                                Element e = list.get(0);
                                code = e.element("Data").getText();
                            }
                            //获取查询结果
                            if (list != null && list.size() > 2) {
                                PersonBaseInfo person = null;
                                for (int j = 2; j < list.size(); j++) {
                                    Element e = list.get(j);
                                    person = new PersonBaseInfo();
                                    switch (resultType){
                                        case NAME:
                                            getPersonName(person,e.content());
                                            break;
                                        case PHOTO:
                                            getPersonPhoto(person,e.content());
                                            break;
                                        case PERSON:
                                            getPerson(person,e.content());
                                            break;
                                        default:
                                            getAll(person,e.content());
                                            break;
                                    }
                                    personList.put(person.getIdnum(),person);
                                }
                            }
                        }
                    } catch (Exception e) {
                        logger.error("人口库获取异常：");
                        logger.error(e.getMessage(), e);
                        e.printStackTrace();
                    }
                }
                //如果执行成功则返回
                if(Constants.ZAFLAG_CODE_SUCCESS.equals(code)){
                    break;
                }
            }
        }else{
            code = Constants.ZAFLAG_CODE_SUCCESS;
        }
        //如果执行成功则返回
        if(!Constants.ZAFLAG_CODE_SUCCESS.equals(code)){
            throw new ArsException("宁夏人口库调用异常！");
        }

        return personList;
    }

    private void getPersonName(PersonBaseInfo person,List contents) {
        person.setIdnum(((DefaultElement)contents.get(0)).getText());
        person.setName(((DefaultElement)contents.get(1)).getText());
    }

    private void getPersonPhoto(PersonBaseInfo person,List contents) {
        getPersonName(person,contents);
        person.setPhoto(getPhoto(person.getIdnum(),person.getName()));
    }

    private void getPerson(PersonBaseInfo person,List contents) {
        getPersonName(person,contents);
        String address = ((DefaultElement)contents.get(3)).getText();
        //户籍地址，增加   从八大库获取户籍地址，解决保安员证上面的“户籍地址”是不合规问题，从八大库获取合规的户籍信息
        String areaAdd = sysareaService.findByCodeForFullName(((DefaultElement)contents.get(2)).getText());
        address = areaAdd + address.replace(areaAdd, "") ;
        person.setAddress(address);
    }

    private void getAll(PersonBaseInfo person,List contents){
        getPerson(person,contents);
        person.setPhoto(getPhoto(person.getIdnum(),person.getName()));
    }


    private Map<String,PersonBaseInfo> getTest(ResultType resultType){
        Map<String,PersonBaseInfo> personList = new HashMap<>();
        String requestResult = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><RBSPMessage>    <Version/>    <ServiceID>S10-00000006</ServiceID>    <TimeStamp/>    <Validity/>    <Security>        <Signature Algorithm=\"\"/>        <CheckCode Algorithm=\"\"/>        <Encrypt/>    </Security>    <Method>        <Name>Query</Name>        <Items>            <Item>                <Value Type=\"arrayOfArrayOf_string\">                    <Row>                        <Data>000</Data>                    </Row>                    <Row>                        <Data>XM</Data>                    </Row>                </Value>            </Item>        </Items>    </Method></RBSPMessage>";


        String pattern = "\\s{2,}";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(requestResult);
        requestResult = m.replaceAll("");

        if (requestResult != null && !requestResult.equals("")) {
            try {
                SAXReader reader = new SAXReader();
                Document doc = reader.read(new ByteArrayInputStream(requestResult.getBytes("UTF-8")));
                Element root = doc.getRootElement();
                Element valueElement = root.element("Method").element("Items").element("Item").element("Value");
                //valueElement节点为空的话，请求人口库异常
                if (valueElement != null) {
                    List<Element> list = valueElement.elements();
                    //获取执行返回编码
                    if(list!=null &&  list.size()>0){
                        Element e = list.get(0);
                    }
                    //获取查询结果
                    if (list != null && list.size() > 2) {
                        PersonBaseInfo person = null;
                        for (int j = 2; j < list.size(); j++) {
                            Element e = list.get(j);
                            person = new PersonBaseInfo();
                            switch (resultType){
                                case NAME:
                                    getPersonName(person,e.content());
                                    break;
                                case PHOTO:
                                    getPersonPhoto(person,e.content());
                                    break;
                                case PERSON:
                                    getPerson(person,e.content());
                                    break;
                                default:
                                    getAll(person,e.content());
                                    break;
                            }
                            personList.put(person.getIdnum(),person);
                        }

                    }
                }
            } catch (Exception e) {
                logger.error("人口库获取异常：");
                logger.error(e.getMessage(), e);
                e.printStackTrace();
            }
        }
        return personList;
    }

    public static void main(String[] args) {
        NXSecurityInterfaceService securityInterfaceService = new NXSecurityInterfaceService();
        Map<String,PersonBaseInfo> personList = securityInterfaceService.getTest(PERSON);

        System.out.println(JSON.toJSONString(personList));
    }

    public String getPhoto(String idNumber,String name) {
        String strResult = "";
        String code = "";
        int errorCount = 0;
        if (ZAFLAG != null && ZAFLAG.equals(Constants.ZAFLAG_YES)) {
            //人口库调用会异常或超时，循环三次，三次还是异常或超时，则获取失败
            for (int i = 0; i < 3; i++) {
                String result = call(Constants.NX_CZ_REQUESTID, Constants.NX_CZ_SERVICEID_PHOTO,idNumber,
                        new String[]{Constants.INFO_XP},Constants.NX_CZPHOTO_DataObjectCode,"001",
                        "GMSFHM");
                //增加日志
                BjRestLog log = new BjRestLog();
                log.setResttype(Constants.NX_CZ_SERVICEID_PHOTO);
                log.setRequestContext(idNumber);
                //创建时间
                log.setCreateTime(new Date());
                //有效标记
                log.setActive(true);
                //更新时间
                log.setUpdateTime(new Date());
                //更新者
                log.setUpdateBy(Constants.APPROVAL_SYSTEM);
                bjRestLogDao.save(log);
                if (StringUtil.isNotEmpty(result)) {
                    try {
                        SAXReader reader = new SAXReader();
                        org.dom4j.Document doc = reader.read(new ByteArrayInputStream(result.getBytes(Constants.CHARSETUTF8)));
                        Element root = doc.getRootElement();
                        Element valueElement = root.element("Method").element("Items").element("Item").element("Value");
                        if (valueElement != null) {
                            List<Element> list = valueElement.elements();
                            //获取执行返回编码
                            if (list != null && list.size() > 0) {
                                Element e = list.get(0);
                                code = e.element("Data").getText();
                            }
                            if (list != null && list.size() > 2) {
                                Element e = list.get(2);
                                strResult = e.element("Data").getText();
                            }
                        } else {
                            //异常次数加1
                            errorCount++;
                        }
                    } catch (Exception e) {
                        logger.error("身份证号：" + idNumber);
                        logger.error("人口库获取异常：" + result);
                        logger.error(e.getMessage(), e);
                        //异常次数加1
                        errorCount++;
                    }
                } else {
                    logger.error("人口库获取异常,没有返回值,身份证号：" + idNumber);
                    //异常次数加1
                    errorCount++;
                }
                //如果执行成功则返回
                if (Constants.ZAFLAG_CODE_SUCCESS.equals(code)) {
                    break;
                }
            }
            if (errorCount == 3) {
                throw new ArsException("调用公安部接口异常！！");
            }
        }
        return strResult;
    }
}
