/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.webservice.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.log.BjRestLogDao;
import com.bcxin.ars.dto.sb.BackgroundApprovalDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.PersonBaseInfo;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.model.log.BjRestLog;
import com.bcxin.ars.model.sb.BackgroundApproval;
import com.bcxin.ars.service.ConfigService;
import com.bcxin.ars.service.SecurityPersonService;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.RSACoder;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.redis.RedisUtil;
import com.bcxin.ars.webservice.BackGroupCensorService;
import com.bcxin.ars.webservice.dto.GXTokenDto;
import com.bcxin.ars.webservice.impl.BackGroupCensorServiceImpl;
import com.xiaoleilu.hutool.http.HttpRequest;
import com.xiaoleilu.hutool.http.HttpResponse;
import com.xiaoleilu.hutool.http.HttpUtil;
import com.xiaoleilu.hutool.http.Method;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="backGroupCensorService_450000")
public class GXBackGroupCensorServiceImpl
extends BackGroupCensorServiceImpl
implements BackGroupCensorService {
    private static Logger logger = LoggerFactory.getLogger(GXBackGroupCensorServiceImpl.class);
    @Autowired
    private BjRestLogDao bjRestLogDao;
    @Autowired
    private SecurityPersonDao securityPersonDao;
    @Autowired
    private ConfigService configService;
    @Autowired
    private SecurityPersonService securityPersonService;
    @Autowired
    private RedisUtil redisUtil;
    private static final String REDIS_TOKEN_KEY = "gx_censor_token";
    private static final String URL_TOKEN = "http://71.4.151.23:8080/api/oauth2/oauth/token";
    private static final String URL_COMPARISON = "http://71.4.151.23:8080/api/importantPersonnel/importantPersonnel/";
    private static String URL_VALIDATE = "http://10.148.67.119:9088/gxryhy/sfhc/integrityValidate.action";
    private static final String PWD_PUBLIC_KEY = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCWA1dKytyglYlK4nTprfKEeECTHsNBmxn0GkdW6/xlsKIXCPKDFtmYjNqIqq5K8+qNyvnIVEymxapLQqkLev4eee9kdqfkvU9QnLm64Ut4YWxo3ewBfygT0ALOKuuG0ItVGrRBwJdPfTI4SoJidCTBI7lOIoHYIRYomi5ijyXQJQIDAQAB";

    @Override
    public String getPhoto(String idnum, String name) {
        try {
            SecurityPerson person = this.securityPersonService.findByIdCard(idnum);
            if (person != null) {
                if (StringUtil.isNotEmpty((String)person.getIdPhoto())) {
                    return person.getIdPhoto();
                }
                return person.getPhoto();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
            throw new ArsException("\u83b7\u53d6\u4eba\u53e3\u5e93\u7167\u7247\u4fe1\u606f\u5931\u8d25\uff01");
        }
        return "";
    }

    @Override
    public PersonBaseInfo getPopulationInfo(String idnum, boolean needPhoto) {
        PersonBaseInfo personBaseInfo = null;
        try {
            SecurityPerson person = this.securityPersonService.findByIdCard(idnum);
            if (person != null) {
                personBaseInfo = new PersonBaseInfo();
                personBaseInfo.setIdnum(person.getIdNumber());
                personBaseInfo.setName(person.getRealName());
                if (needPhoto) {
                    if (StringUtil.isNotEmpty((String)person.getIdPhoto())) {
                        personBaseInfo.setPhoto(person.getIdPhoto());
                    } else {
                        personBaseInfo.setPhoto(person.getPhoto());
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
            throw new ArsException("\u83b7\u53d6\u4eba\u53e3\u5e93\u4fe1\u606f\u5931\u8d25\uff01");
        }
        return personBaseInfo;
    }

    @Override
    public List<BackgroundApproval> censorFromBase(BackgroundApprovalDto dto, boolean needCZ) {
        Long businessid = dto.getBusinessid();
        String businesstype = dto.getBusinesstype();
        String idNumber = dto.getIdNumber();
        String name = dto.getRealName();
        ArrayList<BackgroundApproval> list = new ArrayList<BackgroundApproval>();
        try {
            BackgroundApproval cz_BackgroundApproval = new BackgroundApproval();
            cz_BackgroundApproval.setActive(Boolean.valueOf(true));
            cz_BackgroundApproval.setCreateTime(new Date());
            cz_BackgroundApproval.setUpdateTime(new Date());
            cz_BackgroundApproval.setBusinessid(businessid);
            cz_BackgroundApproval.setApprovaldate(new Date());
            cz_BackgroundApproval.setBusinesstype(businesstype);
            BackgroundApproval tempBackgroundApproval = cz_BackgroundApproval.clone();
            if (needCZ) {
                boolean policeInterface = true;
                if (!"1".equals(dto.getAuthState())) {
                    SecurityPerson person;
                    if ("5".equals(businesstype) && (person = this.securityPersonDao.findByIdCardAndActive(idNumber)) != null && "1".equals(person.getIdentityAuthState())) {
                        policeInterface = false;
                    }
                } else {
                    policeInterface = false;
                }
                if (policeInterface) {
                    this.gxCensorCZ(idNumber, name, cz_BackgroundApproval);
                } else {
                    cz_BackgroundApproval.setApprovalreason("\u4e3b\u9879\u4fe1\u606f\u7b26\u5408");
                    cz_BackgroundApproval.setApprovalstate("003");
                    cz_BackgroundApproval.setRgapprovalstate("003");
                }
                list.add(cz_BackgroundApproval);
            }
            this.isKeyPerson(list, idNumber, tempBackgroundApproval.clone());
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage(), (Throwable)e);
            throw new ArsException("\u67e5\u8be2\u4eba\u53e3\u5e93\u5f02\u5e38\uff01");
        }
        return list;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void gxCensorCZ(String idnum, String name, BackgroundApproval cz_BackgroundApproval) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        BasicResponseHandler responseHandler = new BasicResponseHandler();
        try {
            String comparisonResult;
            JSONObject resultObj;
            String key = DateUtil.getCurrentDate((String)"yyyyMMdd") + "_GXMATCH";
            String count = this.redisUtil.get(key);
            if (StringUtil.isNotEmpty((String)count)) {
                Long total = Long.parseLong(count);
                Long max = 8000L;
                try {
                    String configValue = this.configService.getValueByKey("POLICE_INTERFACE_MAX");
                    max = Long.parseLong(configValue);
                }
                catch (Exception configValue) {
                    // empty catch block
                }
                if (total >= max) {
                    logger.error("\u5e7f\u897f\u4eba\u53e3\u5e93\u6bd4\u5bf9\uff0c\u8bf7\u6c42\u6b21\u6570\u8d85\u8fc7\u6700\u5927\u6b21\u6570:{}", (Object)max);
                    return;
                }
            }
            this.redisUtil.getCount(key, 7L);
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("sh_name", name);
            paramMap.put("sh_sfz", idnum);
            paramMap.put("qiyebianma", "baoanbcx");
            paramMap.put("shid", "baoanbcx");
            paramMap.put("sh_zhaopian", "/9j/4AA");
            HashMap<String, HashMap<String, String>> requestParamMap = new HashMap<String, HashMap<String, String>>();
            requestParamMap.put("param", paramMap);
            logger.error("\u5e7f\u897f\u4eba\u53e3\u5e93\u6bd4\u5bf9\uff0c\u8bf7\u6c42\u5730\u5740:{}", (Object)URL_VALIDATE);
            logger.error("\u5e7f\u897f\u4eba\u53e3\u5e93\u6bd4\u5bf9\uff0c\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString(requestParamMap));
            httpClient = HttpClients.createDefault();
            HttpPost httpPost = new HttpPost(URL_VALIDATE);
            RequestConfig.Builder requestConfig = RequestConfig.custom();
            requestConfig.setConnectTimeout(30000);
            requestConfig.setConnectionRequestTimeout(30000);
            requestConfig.setSocketTimeout(30000);
            StringEntity requestEntity = new StringEntity(JSON.toJSONString(requestParamMap), "utf-8");
            requestEntity.setContentEncoding("UTF-8");
            httpPost.setHeader("Content-type", "application/json");
            httpPost.setConfig(requestConfig.build());
            httpPost.setEntity((HttpEntity)requestEntity);
            String result = (String)httpClient.execute((HttpUriRequest)httpPost, (ResponseHandler)responseHandler);
            logger.error("\u5e7f\u897f\u4eba\u53e3\u5e93\u6bd4\u5bf9\uff0c\u8fd4\u56de\u7ed3\u679c:{}", (Object)result);
            BjRestLog log = new BjRestLog();
            log.setResttype("GXMATCH");
            log.setResponseContext(result);
            log.setRequestContext(JSON.toJSONString(requestParamMap));
            log.setCreateTime(new Date());
            log.setActive(Boolean.valueOf(true));
            log.setUpdateTime(new Date());
            log.setUpdateBy("system");
            this.bjRestLogDao.save(log);
            if (!StringUtil.isNotEmpty((String)result) || (resultObj = JSON.parseObject((String)result)).get((Object)"shjg") == null) return;
            switch (comparisonResult = resultObj.get((Object)"shjg").toString()) {
                case "11": {
                    if (resultObj.get((Object)"msg") == null || resultObj.get((Object)"msg").toString().contains("\u59d3\u540d\u4e0e\u8bc1\u4ef6\u53f7\u7801\u4e0d\u5339\u914d")) {
                        cz_BackgroundApproval.setApprovalreason("\u59d3\u540d\u4fe1\u606f\u6709\u8bef");
                        cz_BackgroundApproval.setApprovalstate("004");
                        cz_BackgroundApproval.setRgapprovalstate("004");
                        return;
                    } else {
                        cz_BackgroundApproval.setApprovalreason("\u4e3b\u9879\u4fe1\u606f\u7b26\u5408");
                        cz_BackgroundApproval.setApprovalstate("003");
                        cz_BackgroundApproval.setRgapprovalstate("003");
                        return;
                    }
                }
                case "20": {
                    cz_BackgroundApproval.setApprovalreason("\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728");
                    cz_BackgroundApproval.setApprovalstate("004");
                    cz_BackgroundApproval.setRgapprovalstate("004");
                    return;
                }
                default: {
                    cz_BackgroundApproval.setApprovalreason("\u4e3b\u9879\u4fe1\u606f\u7b26\u5408");
                    cz_BackgroundApproval.setApprovalstate("003");
                    cz_BackgroundApproval.setRgapprovalstate("003");
                    return;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
            throw new ArsException("\u5e7f\u897f\u4eba\u53e3\u5e93\u6bd4\u5bf9\u5931\u8d25");
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void isKeyPerson(List<BackgroundApproval> list, String idnum, BackgroundApproval backgroundApproval) {
        block24: {
            try {
                JSONObject resultObj;
                String key = DateUtil.getCurrentDate((String)"yyyyMMdd") + "_GXCOMPARISON";
                String count = this.redisUtil.get(key);
                if (StringUtil.isNotEmpty((String)count)) {
                    Long total = Long.parseLong(count);
                    Long max = 8000L;
                    try {
                        String configValue = this.configService.getValueByKey("POLICE_INTERFACE_MAX");
                        max = Long.parseLong(configValue);
                    }
                    catch (Exception configValue) {
                        // empty catch block
                    }
                    if (total >= max) {
                        logger.error("\u5e7f\u897f\u91cd\u70b9\u4eba\u6bd4\u5bf9\uff0c\u8bf7\u6c42\u6b21\u6570\u8d85\u8fc7\u6700\u5927\u6b21\u6570:{}", (Object)max);
                        return;
                    }
                }
                String url = URL_COMPARISON + idnum;
                String token = this.getToken(false);
                logger.error("\u5e7f\u897f\u91cd\u70b9\u4eba\u6bd4\u5bf9\uff0c\u8bf7\u6c42\u5730\u5740:{}", (Object)url);
                HttpResponse response = ((HttpRequest)HttpUtil.createRequest((Method)Method.POST, (String)url).timeout(30000).header("Authorization", token)).execute();
                String result = response.body();
                logger.error("\u5e7f\u897f\u91cd\u70b9\u4eba\u6bd4\u5bf9\uff0c\u8fd4\u56de\u7ed3\u679c:{}", (Object)result);
                BjRestLog log = new BjRestLog();
                log.setResttype("GXCOMPARISON");
                log.setResponseContext(result);
                log.setRequestContext(idnum);
                log.setCreateTime(new Date());
                log.setActive(Boolean.valueOf(true));
                log.setUpdateTime(new Date());
                log.setUpdateBy("system");
                this.bjRestLogDao.save(log);
                if (!StringUtil.isNotEmpty((String)result) || (resultObj = JSON.parseObject((String)result)).get((Object)"code") == null) break block24;
                if ("200".equals(resultObj.get((Object)"code").toString())) {
                    String data;
                    BackgroundApproval xd_BackgroundApproval = backgroundApproval.clone();
                    xd_BackgroundApproval.setLibraryType("2");
                    BackgroundApproval dt_BackgroundApproval = backgroundApproval.clone();
                    dt_BackgroundApproval.setLibraryType("3");
                    BackgroundApproval wf_BackgroundApproval = backgroundApproval.clone();
                    wf_BackgroundApproval.setLibraryType("4");
                    boolean xd = false;
                    boolean dt = false;
                    boolean wf = false;
                    StringBuilder content = new StringBuilder();
                    if (resultObj.get((Object)"data") != null && !"00".equals(data = resultObj.get((Object)"data").toString())) {
                        String[] datas;
                        for (String s : datas = data.split(",")) {
                            if ("03".equals(s)) {
                                dt = true;
                                continue;
                            }
                            if ("04".equals(s)) {
                                xd = true;
                                continue;
                            }
                            if ("05".equals(s)) {
                                wf = true;
                                content.append("\u5211\u4e8b\u72af\u7f6a\u524d\u79d1\u4eba\u5458\u62a5\u8b66\u3001");
                                continue;
                            }
                            if ("06".equals(s)) {
                                wf = true;
                                content.append("\u8087\u4e8b\u8087\u7978\u7cbe\u795e\u75c5\u4eba\u3001");
                                continue;
                            }
                            if ("07".equals(s)) {
                                wf = true;
                                content.append("\u91cd\u70b9\u4e0a\u8bbf\u4eba\u5458\u3001");
                                continue;
                            }
                            if ("01".equals(s)) {
                                wf = true;
                                content.append("\u6d89\u6050\u4eba\u5458\u3001");
                                continue;
                            }
                            if (!"02".equals(s)) continue;
                            wf = true;
                            content.append("\u6d89\u7a33\u4eba\u5458\u3001");
                        }
                    }
                    if (xd) {
                        xd_BackgroundApproval.setApprovalreason("\u5438\u6bd2\u4eba\u5458");
                        xd_BackgroundApproval.setApprovalstate("004");
                        xd_BackgroundApproval.setRgapprovalstate("004");
                    } else {
                        xd_BackgroundApproval.setApprovalreason("\u65e0\u5438\u6bd2\u8bb0\u5f55");
                        xd_BackgroundApproval.setApprovalstate("003");
                        xd_BackgroundApproval.setRgapprovalstate("003");
                    }
                    if (dt) {
                        dt_BackgroundApproval.setApprovalreason("\u5728\u9003\u4eba\u5458");
                        dt_BackgroundApproval.setApprovalstate("004");
                        dt_BackgroundApproval.setRgapprovalstate("004");
                    } else {
                        dt_BackgroundApproval.setApprovalreason("\u65e0\u5728\u9003\u8bb0\u5f55");
                        dt_BackgroundApproval.setApprovalstate("003");
                        dt_BackgroundApproval.setRgapprovalstate("003");
                    }
                    if (wf) {
                        wf_BackgroundApproval.setApprovalreason(content.substring(0, content.length() - 1));
                        wf_BackgroundApproval.setApprovalstate("004");
                        wf_BackgroundApproval.setRgapprovalstate("004");
                    } else {
                        wf_BackgroundApproval.setApprovalreason("\u65e0\u8fdd\u6cd5\u72af\u7f6a\u8bb0\u5f55");
                        wf_BackgroundApproval.setApprovalstate("003");
                        wf_BackgroundApproval.setRgapprovalstate("003");
                    }
                    list.add(xd_BackgroundApproval);
                    list.add(dt_BackgroundApproval);
                    list.add(wf_BackgroundApproval);
                    break block24;
                }
                if ("401".equals(resultObj.get((Object)"code").toString())) {
                    this.getToken(true);
                    this.isKeyPerson(list, idnum, backgroundApproval);
                    break block24;
                }
                try {
                    throw new ArsException("\u5e7f\u897f\u91cd\u70b9\u4eba\u6bd4\u5bf9\u63a5\u53e3\u5f02\u5e38,\u8bf7\u8054\u7cfb\u63a5\u53e3\u8d1f\u8d23\u4eba:" + resultObj.get((Object)"message").toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error(e.getMessage());
                    throw new ArsException("\u5e7f\u897f\u91cd\u70b9\u4eba\u6bd4\u5bf9\u83b7\u53d6token\u5931\u8d25");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error(e.getMessage(), (Throwable)e);
                throw new ArsException("\u5e7f\u897f\u3010\u5e7f\u897f\u91cd\u70b9\u4eba\u6bd4\u5bf9\u3011\u8c03\u7528\u5f02\u5e38\uff01\uff01");
            }
        }
    }

    private synchronized String getToken(boolean refresh) {
        String token = this.redisUtil.get(REDIS_TOKEN_KEY);
        if (refresh || StringUtil.isEmpty((String)token)) {
            try {
                HashMap<String, String> paramMap = new HashMap<String, String>();
                paramMap.put("username", "bcxzdr");
                paramMap.put("password", RSACoder.encrypt((String)"bcxzdr123", (String)PWD_PUBLIC_KEY));
                paramMap.put("grant_type", "password");
                logger.error("\u5e7f\u897f\u91cd\u70b9\u4eba\u6bd4\u5bf9\u83b7\u53d6token\uff0c\u8bf7\u6c42\u5730\u5740:{}", (Object)URL_TOKEN);
                logger.error("\u5e7f\u897f\u91cd\u70b9\u4eba\u6bd4\u5bf9\u83b7\u53d6token\uff0c\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString(paramMap));
                HttpResponse response = ((HttpRequest)((HttpRequest)HttpUtil.createRequest((Method)Method.POST, (String)URL_TOKEN).form(paramMap).timeout(30000).header("Content-Type", "application/x-www-form-urlencoded")).header("Authorization", "Basic YWRtaW46UklmZmY3WFpYTEZDR2hHM0lOZm5KRis0NjN2WTFnd25PTHgrSWlQYUtQK0lnV0k5aUR5c0VTS0JERDJGNkVxWVZXVS9GVTA2cnNDeE1IWFgvMWJCazN4dk9TR0NtWEJ3d0dsSUNJclg4VFEvdHBmRkU5M2NjZmkrakdEQ2lLOHFWbmRhUG5TaU1yYk00cUZud25TeGF5amp6SDVrSlZkcVZ2YnJSWVZLL3NVPQ==")).execute();
                String result = response.body();
                logger.error("\u5e7f\u897f\u91cd\u70b9\u4eba\u6bd4\u5bf9\u83b7\u53d6token\uff0c\u8fd4\u56de\u7ed3\u679c:{}", (Object)result);
                if (!StringUtil.isNotEmpty((String)result)) {
                    throw new ArsException("\u5e7f\u897f\u91cd\u70b9\u4eba\u6bd4\u5bf9\u83b7\u53d6token\u5931\u8d25:" + result);
                }
                JSONObject data = JSON.parseObject((String)result);
                token = data.get((Object)"access_token").toString();
                this.redisUtil.set(REDIS_TOKEN_KEY, token, 1740);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error(e.getMessage());
                throw new ArsException("\u5e7f\u897f\u91cd\u70b9\u4eba\u6bd4\u5bf9\u83b7\u53d6token\u5931\u8d25");
            }
        }
        logger.error("\u8bf7\u6c42token:{}", (Object)token);
        return token;
    }

    public static void main(String[] args) throws Exception {
        System.out.println(RSACoder.encrypt((String)"bcxzdr123", (String)PWD_PUBLIC_KEY));
        String result = "{\"requestId\":\"56c84a85-48fe-47b1-bde8-ab7a45b63526\",\"success\":true,\"code\":\"200\",\"message\":\"OK\",\"data\":{\"access_token\":\"Bearer\u00a0eyJhbGciOiJSUzI1NiJ9.eyJ\",\"sub\":\"88888\",\"expire\":\"2020-08-10\u00a016:25:12\",\"userType\":\"superAdmin\",\"depart\":\"45\",\"userName\":\"88888\",\"userId\":\"1\"}}";
        System.out.println(result);
        if (StringUtil.isNotEmpty((String)result)) {
            GXTokenDto tokenDto = (GXTokenDto)JSON.parseObject((String)result, GXTokenDto.class);
            System.out.println(tokenDto);
            JSONObject resultObj = JSON.parseObject((String)result);
            if (resultObj.get((Object)"code") != null && "200".equals(resultObj.get((Object)"code").toString())) {
                JSONObject data = JSON.parseObject((String)resultObj.get((Object)"data").toString());
                System.out.println(data.get((Object)"access_token").toString());
            }
        }
    }
}

