package com.bcxin.ars.rest.util;

import org.apache.shiro.authz.UnauthorizedException;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ArsExceptionHandler implements HandlerExceptionResolver {
	
//	private Logger logger = Logger.getLogger(ArsExceptionHandler.class);

	public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        if(ex instanceof UnauthorizedException){  
            ModelAndView mv = new ModelAndView("redirect:/refuse.json");  
            return mv;  
        }
        ex.printStackTrace();
//        logger.error(ex);
        ModelAndView mv = new ModelAndView("error");
        mv.addObject("successful", false);
        mv.addObject("code", "");
        mv.addObject("msg", ex.getMessage());
        mv.addObject("data", ex.toString().replaceAll("\n", "<br/>"));
        return mv;  
    }  
	
}
