package com.bcxin.ars.rest.app;

import com.bcxin.ars.hbase.HBaseService;
import com.bcxin.ars.model.task.TaskTrack;
import com.bcxin.ars.rest.dto.AppAjaxResult;
import com.bcxin.ars.service.task.TaskTrackService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.Resource;
import java.util.List;
import java.util.UUID;

@Controller
@RequestMapping("app/task")
public class AppTaskController {
	private static final Logger logger = LoggerFactory.getLogger(AppTaskController.class);
	@Autowired
	private HBaseService hBaseService;
	/**
	 * 记录任务轨迹
	 * @param appResult
	 * @return
	 */
	@RequestMapping("updateTrack")
	public @ResponseBody AppAjaxResult updateTrack(AppAjaxResult appResult) {
		AppAjaxResult result = new AppAjaxResult();
		try { 
			TaskTrack track = appResult.getDecodeData(TaskTrack.class);
			if(track.getLongitude() != null && track.getLongitude().trim().length() > 0
					&& track.getLatitude() != null && track.getLatitude().trim().length() > 0) {
				track.setUuid(UUID.randomUUID().toString());
				hBaseService.save(track);
				result.setSuccessful(true);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			result.setSuccessful(false);
			result.setMsg(e.getMessage());
		}
		return result;
	}
	/**
	 * 获取任务轨迹
	 * @return
	 */
	@RequestMapping("findTrackList/{feedbackId}")
	public @ResponseBody AppAjaxResult findTrackList(@PathVariable("feedbackId")Long feedbackId) {
		AppAjaxResult result = new AppAjaxResult();
		try {
			List<TaskTrack> trackList = hBaseService.findByFeedbackId(feedbackId);
			result.setSuccessful(true);
			result.setEncodeData(trackList);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			result.setSuccessful(false);
			result.setMsg(e.getMessage());
		}
		return result;
	}

}
