package com.bcxin.ars.timer.personcertificate;

import com.bcxin.ars.model.Config;
import com.bcxin.ars.service.sb.PersoncertificateService;
import com.bcxin.ars.service.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

/**
 * 自动背景筛查
 */
@Service
public class AutoUpdateCensorStatusForOldData {
	
	private Logger logger = LoggerFactory.getLogger(AutoUpdateCensorStatusForOldData.class);

	@Autowired
	private PersoncertificateService personcertificateService;

	@Value("${timeFlag}")
	private String timeFlag = "";

	@Autowired
	private ConfigUtils configUtils;

	public void run() {
		logger.info("begin to update CensorStatus for importOldData...");

		String bg_switch = configUtils.getValueByKey("bg_switch");
		if("0".equals(bg_switch)){
			return;
		}

		Config config = configUtils.getConfigByKey("police");
		if (config.getValue().equals("1") && timeFlag.equals("true")) {
			personcertificateService.autoUpdateCensorForImportOldData();
		}
		logger.info("update CensorStatus for importOldData done.");
	}
	
}
