package com.bcxin.ars.timer.ministerial;

import com.abcxin.smart.validator.annotation.JobLogAnnotation;
import com.alibaba.fastjson.JSONArray;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.enums.MinisterialDataType;
import com.bcxin.ars.model.sys.MinisterialLog;
import com.bcxin.ars.service.sys.MinisterialLogService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.MinisterialUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.webservice.XxbaBaseDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 数据定时上报部级接口
 * @author linqinglin
 * @date 2021/03/04 0004 14:36
 */
@Service
public class MinisterialAutoService {

    private Logger logger = LoggerFactory.getLogger(MinisterialAutoService.class);


    @Autowired
    private MinisterialLogService ministerialLogService;

    @Autowired
    private MinisterialUtil ministerialUtil;

    @Autowired
    private ConfigUtils configUtils;

    private boolean lock = false;

    @JobLogAnnotation(getJobClazz = MinisterialAutoService.class)
    public void run(){
        if(lock){
            return;
        }
        lock = true;
        try{
            if (configUtils.isIntranet() && configUtils.timeFlag.equals("true")) {
                syncRun();
            }
        }catch (Exception e){

        }finally {
            lock = false;
        }
    }

    private void syncRun(){
        String ministerial_limit = configUtils.getValueByKey(Constants.MINISTERIAL_LIMIT);
        int limit = 3;
        try{
            limit = Integer.parseInt(ministerial_limit);
        }catch (Exception e){

        }
        for (MinisterialDataType dataType : MinisterialDataType.values()) {
            try {
                List<Map> list = ministerialLogService.getBusinessDatas(dataType,limit);
                if(list == null || list.size() < 1){
                    //无值
                    continue;
                }
                //System.out.println(JSONArray.toJSONString(list));
                List dataList = JSONArray.parseArray(JSONArray.toJSONString(list),dataType.getDataClazz());
                for (Object o : dataList) {
                    try {
                        AjaxResult result = ministerialUtil.send(dataType, o);
                        if(result.isSuccessful()) {
                            MinisterialLog log = new MinisterialLog();
                            log.setBusinessType(dataType.getCode());
                            if (result.getData() != null) {
                                log.setSerialNo(result.getData().toString());
                                log.setState("0");
                            }
                            log.setActive(true);
                            log.setCreateTime(new Date());
                            log.setUpdateTime(new Date());
                            log.setBusinessId(((XxbaBaseDto)o).getId());
                            ministerialLogService.save(log);
                        }
                        Thread.sleep(1000);
                    }catch (Exception e){
                        logger.error(e.getMessage(),e);
                        e.printStackTrace();
                    }
                }
                Thread.sleep(5000);
            } catch (Exception e) {
                logger.error(e.getMessage(),e);
                e.printStackTrace();
            } finally {
            }
        }

    }

}
