/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.timer.problemPerson;

import cn.hutool.core.thread.ThreadUtil;
import com.abcxin.smart.validator.annotation.JobLogAnnotation;
import com.bcxin.ars.dao.ProblemLogDao;
import com.bcxin.ars.dao.sb.InvestorDao;
import com.bcxin.ars.dao.sb.ManagementInfoDao;
import com.bcxin.ars.dto.sb.BackgroundApprovalDto;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.ProblemLog;
import com.bcxin.ars.model.sb.BackgroundApproval;
import com.bcxin.ars.service.bean.factory.BackGroupCensorServiceBeanFactory;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.webservice.BackGroupCensorService;
import com.bcxin.ars.webservice.util.BJProblemDetailUtil;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ManageInfoProblemServiceJob {
    private Logger logger = LoggerFactory.getLogger(ManageInfoProblemServiceJob.class);
    @Autowired
    private ManagementInfoDao managementInfoDao;
    @Autowired
    private InvestorDao investorDao;
    @Autowired
    private ProblemLogDao problemLogDao;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private static BackGroupCensorService backGroupCensorService;
    @Autowired
    private BJProblemDetailUtil bjProblemDetailUtil;
    @Value(value="${ZAFLAG}")
    private String ZAFLAG;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JobLogAnnotation(getJobClazz=ManageInfoProblemServiceJob.class)
    public synchronized void run() {
        Config config;
        if (backGroupCensorService == null) {
            backGroupCensorService = BackGroupCensorServiceBeanFactory.getBackGroupCensorServiceBean();
        }
        if ("1".equals((config = this.configUtils.getConfigByKey("police")).getValue()) && this.ZAFLAG != null && "1".equals(this.ZAFLAG)) {
            try {
                List list = this.problemLogDao.findUnCensor();
                final CountDownLatch countDownLatch = ThreadUtil.newCountDownLatch((int)list.size());
                ThreadPoolExecutor threadPoolExecutor = ThreadUtil.newExecutor((int)15, (int)15);
                for (final ProblemLog problemLog : list) {
                    threadPoolExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                BackgroundApprovalDto dto = new BackgroundApprovalDto();
                                dto.setIdNumber(problemLog.getIdnum());
                                dto.setRealName(problemLog.getName());
                                dto.setBusinessid(problemLog.getId());
                                dto.setBusinesstype("15");
                                List backgroundApprovals = backGroupCensorService.censor(dto);
                                problemLog.setBackgroundApprovals(backgroundApprovals);
                                problemLog.setCensorStatusError(Boolean.valueOf(false));
                            }
                            catch (Exception e) {
                                problemLog.setCensorStatusError(Boolean.valueOf(true));
                                ManageInfoProblemServiceJob.this.logger.error(e.getMessage(), (Throwable)e);
                            }
                            finally {
                                countDownLatch.countDown();
                            }
                        }
                    });
                }
                try {
                    countDownLatch.await();
                }
                catch (InterruptedException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                    e.printStackTrace();
                    Thread.currentThread().interrupt();
                }
                finally {
                    threadPoolExecutor.shutdown();
                }
                final CopyOnWriteArrayList successList = new CopyOnWriteArrayList();
                final CountDownLatch countDownLatch1 = ThreadUtil.newCountDownLatch((int)list.size());
                ThreadPoolExecutor threadPoolExecutor1 = ThreadUtil.newExecutor((int)15, (int)15);
                for (final ProblemLog problemLog : list) {
                    threadPoolExecutor1.execute(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                Boolean result = false;
                                StringBuffer problemtype = new StringBuffer();
                                if (problemLog.getBackgroundApprovals() != null && problemLog.getBackgroundApprovals().size() > 0) {
                                    for (BackgroundApproval backgroundApproval : problemLog.getBackgroundApprovals()) {
                                        if (!"004".equals(backgroundApproval.getApprovalstate())) continue;
                                        problemtype.append(backgroundApproval.getApprovalreason()).append(",");
                                        result = true;
                                    }
                                }
                                if (!problemLog.getCensorStatusError().booleanValue()) {
                                    if (result.booleanValue()) {
                                        problemtype.deleteCharAt(problemtype.length() - 1);
                                        problemLog.setProblem(problemtype.toString());
                                        if ("\u59d3\u540d\u4fe1\u606f\u6709\u8bef".equals(problemtype.toString()) || "\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728".equals(problemtype.toString())) {
                                            problemLog.setProblemType("1");
                                        } else if (problemtype.toString().indexOf("\u5728\u9003") >= 0) {
                                            problemLog.setProblemType("2");
                                        } else {
                                            problemLog.setProblemType("3");
                                        }
                                    }
                                    if (!"1".equals(problemLog.getProblemType())) {
                                        problemLog.setContent(ManageInfoProblemServiceJob.this.bjProblemDetailUtil.checkPersonInfo(problemLog.getIdnum()));
                                    }
                                    successList.add(problemLog);
                                }
                            }
                            catch (Exception e) {
                                ManageInfoProblemServiceJob.this.logger.error(e.getMessage(), (Throwable)e);
                                e.printStackTrace();
                            }
                            finally {
                                countDownLatch1.countDown();
                            }
                        }
                    });
                }
                try {
                    countDownLatch1.await();
                }
                catch (InterruptedException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
                threadPoolExecutor1.shutdown();
                if (successList != null && successList.size() > 0) {
                    this.problemLogDao.saveBatch(successList);
                }
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                e.printStackTrace();
            }
        }
    }
}

