/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.timer.person;

import cn.hutool.core.thread.ThreadUtil;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.PersonBaseImg;
import com.bcxin.ars.model.PersonBaseInfo;
import com.bcxin.ars.model.sys.JobRunLog;
import com.bcxin.ars.service.PersonBaseInfoService;
import com.bcxin.ars.service.impl.BaseService;
import com.bcxin.ars.service.sys.JobRunLogService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.GetPersonImgUtil;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AutoPersonBaseInfoBlob
extends BaseService {
    private Logger logger = LoggerFactory.getLogger(AutoPersonBaseInfoBlob.class);
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private PersonBaseInfoService personBaseInfoService;
    @Autowired
    private JobRunLogService jobRunLogService;
    @Value(value="${timeFlag}")
    private String timeFlag = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Config config = this.configUtils.getConfigByKey("police");
        if (config.getValue().equals("0") && this.timeFlag.equals("true")) {
            JobRunLog log = new JobRunLog();
            log.setCreateTime(new Date());
            log.setActive(Boolean.valueOf(true));
            log.setUpdateBy("jobSystem");
            long startTime = System.currentTimeMillis();
            String fzrq = DateUtil.getCurrentDate((String)"yyyy-MM") + "-26";
            List list = this.personBaseInfoService.createData(fzrq);
            if (list.size() > 0) {
                final CountDownLatch workCount = ThreadUtil.newCountDownLatch((int)list.size());
                ThreadPoolExecutor threadPoolExecutor = ThreadUtil.newExecutor((int)15, (int)15);
                for (final PersonBaseImg img : list) {
                    threadPoolExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                PersonBaseInfo info = AutoPersonBaseInfoBlob.this.personBaseInfoService.findByIdNum(img.getCYRSFZJHM());
                                if (info != null) {
                                    img.setZP(GetPersonImgUtil.getStringImage((String)GetPersonImgUtil.GetImageStr((String)AutoPersonBaseInfoBlob.this.getResourcePath(info.getImgPath()))));
                                    AutoPersonBaseInfoBlob.this.personBaseInfoService.updateImgBlob(img);
                                }
                            }
                            catch (Exception e) {
                                AutoPersonBaseInfoBlob.this.logger.error(e.getMessage(), (Throwable)e);
                                e.printStackTrace();
                            }
                            finally {
                                workCount.countDown();
                            }
                        }
                    });
                }
                try {
                    workCount.await();
                }
                catch (InterruptedException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                finally {
                    threadPoolExecutor.shutdown();
                }
            }
            long endTime = System.currentTimeMillis();
            log.setUpdateTime(new Date());
            log.setJobName(AutoPersonBaseInfoBlob.class.getName());
            log.setRunTime(new Date());
            log.setRunTimeLength(endTime - startTime + "ms");
            this.jobRunLogService.insert(log);
        }
    }
}

