/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.timer.gradeclass;

import com.bcxin.ars.model.sys.JobRunLog;
import com.bcxin.ars.service.sb.GradeClassService;
import com.bcxin.ars.service.sys.JobRunLogService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.timer.gradePerson.AutoGradePersonCensorStatus;
import com.bcxin.ars.util.StringUtil;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AutoGradeClass {
    private static final Logger logger = LoggerFactory.getLogger(AutoGradeClass.class);
    @Value(value="${timeFlag}")
    private String timeFlag = "";
    @Autowired
    private JobRunLogService jobRunLogService;
    @Autowired
    private GradeClassService gradeClassService;
    @Autowired
    private ConfigUtils configUtils;

    public void run() {
        if (this.configUtils.isIntranet() && this.timeFlag.equals("true")) {
            JobRunLog log = new JobRunLog();
            log.setCreateTime(new Date());
            log.setActive(Boolean.valueOf(true));
            log.setUpdateBy("jobSystem");
            long startTime = System.currentTimeMillis();
            try {
                String hour = this.configUtils.getValueByKey("GRADE_HOUR_AUTOAPPROVAL");
                if (StringUtil.isEmpty((String)hour)) {
                    hour = "48";
                }
                this.gradeClassService.autoUpdateApprovalState(hour);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                log.setExceptionMsg(e.toString());
            }
            long endTime = System.currentTimeMillis();
            log.setUpdateTime(new Date());
            log.setJobName(AutoGradePersonCensorStatus.class.getName());
            log.setRunTime(new Date());
            log.setRunTimeLength(endTime - startTime + "ms");
            this.jobRunLogService.insert(log);
        }
    }
}

