/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.timer.dataSync;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.ConfigDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.sys.JobRunLog;
import com.bcxin.ars.service.sys.JobRunLogService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.DataSyncContantsUtil;
import com.bcxin.ars.service.util.DataSyncUtil;
import com.bcxin.ars.util.DateUtil;
import java.io.File;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataSyncO2IService {
    private Logger logger = LoggerFactory.getLogger(DataSyncO2IService.class);
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private ConfigDao configDao;
    @Autowired
    private DataSyncUtil dataSyncUtil;
    @Autowired
    private DataSyncContantsUtil dataSyncContantsUtil;
    @Autowired
    private JobRunLogService jobRunLogService;
    private boolean lock = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block10: {
            if (this.lock) {
                return;
            }
            this.lock = true;
            try {
                if (!"true".equals(this.configUtils.timeFlag)) break block10;
                if (!"1".equals(this.configUtils.getValueByKey("DATASYNC_SWITCH"))) {
                    return;
                }
                JobRunLog log = new JobRunLog();
                log.setCreateTime(new Date());
                log.setActive(Boolean.valueOf(true));
                log.setUpdateBy("jobSystem");
                long startTime = System.currentTimeMillis();
                try {
                    if (this.configUtils.isIntranet()) {
                        this.readDSFile();
                    } else {
                        this.createDataFile();
                    }
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                    log.setExceptionMsg(e.toString());
                }
                long endTime = System.currentTimeMillis();
                log.setUpdateTime(new Date());
                log.setJobName(DataSyncO2IService.class.getName());
                log.setRunTime(new Date());
                log.setRunTimeLength(endTime - startTime + "ms");
                this.jobRunLogService.insert(log);
            }
            finally {
                this.lock = false;
            }
        }
    }

    private void readDSFile() {
        Date now = new Date();
        Config lastDateConfig = this.configDao.findByKey("lastDate");
        if (lastDateConfig != null) {
            String lastDate = lastDateConfig.getValue();
            List dates = DateUtil.getBetweenDates((Date)DateUtil.convertStringToDate((String)lastDate), (Date)now);
            dates.add(now);
            for (Date date : dates) {
                String dirFilePath = this.dataSyncContantsUtil.ftpOutFolder + DateUtil.convertDateToString((Date)date, (String)"yyyy-MM-dd");
                File dirFile = new File(dirFilePath);
                if (!dirFile.exists()) break;
                File[] files = dirFile.listFiles();
                boolean errorFlag = false;
                for (int i = 0; i < files.length; ++i) {
                    File file = files[i];
                    if (!file.getName().endsWith(".zip") || !file.getName().startsWith(this.configUtils.getDataSyncStartFileName(DataSyncAnnotation.class))) continue;
                    try {
                        this.dataSyncUtil.readDSFile(DataSyncAnnotation.class, file);
                        continue;
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage(), (Throwable)e);
                        errorFlag = true;
                    }
                }
                if (errorFlag) continue;
                Config updateConfig = new Config();
                updateConfig.setKey("lastDate");
                updateConfig.setValue(DateUtil.convertDateToString((Date)date, (String)"yyyy-MM-dd"));
                this.configUtils.updateForKey(updateConfig);
            }
        }
    }

    private void createDataFile() {
        DataSynchronizationSearchDto searchDto = new DataSynchronizationSearchDto();
        searchDto.setPaging(false);
        Config lastDateConfig = this.configUtils.getConfigByKey("lastDateTime");
        if (lastDateConfig == null || DateUtil.convertDateToString((Date)new Date(), (String)"yyyy-MM-dd").equals(lastDateConfig.getValue())) {
            searchDto.setStartDate(DateUtil.getYesterdayTime());
        } else {
            searchDto.setStartDate(lastDateConfig.getValue());
        }
        searchDto.setEndDate(DateUtil.getTomorrowTime());
        this.dataSyncUtil.createDSFile(DataSyncAnnotation.class, searchDto, this.dataSyncContantsUtil.ftpOutFolder + DateUtil.getCurrentDate() + File.separator);
        Config updateConfig = new Config();
        updateConfig.setKey("lastDateTime");
        updateConfig.setValue(DateUtil.getDateStrAfterMinute((int)-5));
        updateConfig.setUpdateTime(new Date());
        this.configUtils.updateForKey(updateConfig);
    }
}

