/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.thirdtrain;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.IdcardUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bcxin.ars.dao.ThirdTrainBackgroundDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.ThirdTrainBackgroundPageSearchDto;
import com.bcxin.ars.model.ThirdTrainBackground;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.ThirdTrainBackgroundService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdWorker;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.JwtUtil;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class ThirdTrainBackgroundServiceImpl
implements ThirdTrainBackgroundService {
    Logger logger = LoggerFactory.getLogger(ThirdTrainBackgroundServiceImpl.class);
    @Autowired
    private ThirdTrainBackgroundDao thirdTrainBackgroundDao;
    @Autowired
    private IdWorker idWorker;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private ArsUtil arsUtil;

    public int delete(ThirdTrainBackground thirdTrainBackground) {
        User currentUser = this.arsUtil.getCurrentUser();
        thirdTrainBackground.setUpdateTime(new Date());
        thirdTrainBackground.setUpdateBy(currentUser.getUsername());
        return this.thirdTrainBackgroundDao.delete(thirdTrainBackground);
    }

    public int save(ThirdTrainBackground thirdTrainBackground) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (thirdTrainBackground.getId() == null) {
            thirdTrainBackground.setCreateTime(new Date());
        } else {
            ThirdTrainBackground dbThirdTrainBackground = this.thirdTrainBackgroundDao.findById(thirdTrainBackground.getId());
            BeanUtils.copyPropertiesIgnore((Object)thirdTrainBackground, (Object)dbThirdTrainBackground, (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)dbThirdTrainBackground, (Object)thirdTrainBackground, (Boolean)false);
        }
        thirdTrainBackground.setActive(Boolean.valueOf(true));
        thirdTrainBackground.setUpdateBy(currentUser.getUsername());
        thirdTrainBackground.setUpdateTime(new Date());
        thirdTrainBackground.setUpdateflag(Boolean.valueOf(true));
        thirdTrainBackground.setUserid(currentUser.getId());
        thirdTrainBackground.setAreaCode(currentUser.getPolice().getAreacode());
        return this.thirdTrainBackgroundDao.save(thirdTrainBackground);
    }

    public ThirdTrainBackground findById(Long id) {
        return this.thirdTrainBackgroundDao.findById(id);
    }

    public void searchForPage(ThirdTrainBackgroundPageSearchDto dto, AjaxPageResponse page) {
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        this.thirdTrainBackgroundDao.searchForPage(dto, page);
    }

    public void importBatch(List<ThirdTrainBackground> list) {
        List dbList = this.thirdTrainBackgroundDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            for (ThirdTrainBackground thirdTrainBackground : list) {
                thirdTrainBackground.setUpdateflag(Boolean.valueOf(false));
                try {
                    if (this.configUtils.isIntranet()) continue;
                    thirdTrainBackground.setUpdateTime(DateUtil.dateAdd((int)6, (Date)thirdTrainBackground.getUpdateTime(), (int)1));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.thirdTrainBackgroundDao.saveBatch(list);
        }
    }

    public List<ThirdTrainBackground> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return this.thirdTrainBackgroundDao.searchForDataSynchronization(dto);
    }

    public List<ThirdTrainBackground> findDSOutList(String startDate) {
        return this.thirdTrainBackgroundDao.findDSOutList(startDate);
    }

    public List<ThirdTrainBackground> findByBatchId(List<ThirdTrainBackground> list) {
        return this.thirdTrainBackgroundDao.findByBatchId(list);
    }

    public void updateSelective(ThirdTrainBackground thirdTrainBackground) {
        User currentUser = this.arsUtil.getCurrentUser();
        thirdTrainBackground.setUpdateTime(new Date());
        thirdTrainBackground.setUpdateBy(currentUser.getUsername());
        this.thirdTrainBackgroundDao.updateSelective(thirdTrainBackground);
    }

    public AjaxResult commitPeopleBackgroundScreening(String thirdTrainBackgrounds) {
        AjaxResult ajaxResult = new AjaxResult();
        String subject = JwtUtil.parseJWT((String)thirdTrainBackgrounds).getSubject();
        List thirdTrainBackgroundList = JSON.parseArray((String)subject, ThirdTrainBackground.class);
        HashMap resultData = Maps.newHashMap();
        User currentUser = this.arsUtil.getCurrentUser();
        Long userid = currentUser.getId();
        ArrayList validParamSuccess = Lists.newArrayList();
        Date now = new Date();
        for (ThirdTrainBackground thirdTrainBackground : thirdTrainBackgroundList) {
            if (!this.validParams(thirdTrainBackground) || this.thirdTrainBackgroundDao.selectCount(thirdTrainBackground) > 0) {
                resultData.put(thirdTrainBackground.getIdNumber(), false);
                continue;
            }
            thirdTrainBackground.setUserid(userid);
            thirdTrainBackground.setUpdateBy(currentUser.getUsername());
            thirdTrainBackground.setActive(Boolean.valueOf(true));
            thirdTrainBackground.setCreateTime(now);
            thirdTrainBackground.setUpdateTime(now);
            thirdTrainBackground.setId(Long.valueOf(this.idWorker.nextId()));
            validParamSuccess.add(thirdTrainBackground);
        }
        if (CollectionUtil.isEmpty((Collection)validParamSuccess)) {
            ajaxResult.setData((Object)JwtUtil.createJWT((String)JSON.toJSONString((Object)resultData)));
            ajaxResult.setSuccessful(true);
            return ajaxResult;
        }
        this.thirdTrainBackgroundDao.saveBatch((List)validParamSuccess);
        validParamSuccess.forEach(item -> resultData.put(item.getIdNumber(), true));
        ajaxResult.setData((Object)JwtUtil.createJWT((String)JSON.toJSONString((Object)resultData)));
        ajaxResult.setSuccessful(true);
        return ajaxResult;
    }

    public AjaxResult listPeopleBackgroundScreening(String thirdTrainBackground) {
        AjaxResult ajaxResult = new AjaxResult();
        String subject = JwtUtil.parseJWT((String)thirdTrainBackground).getSubject();
        ThirdTrainBackground thirdTrainBackgroundSearch = (ThirdTrainBackground)JSON.parseObject((String)subject, ThirdTrainBackground.class);
        User currentUser = this.arsUtil.getCurrentUser();
        thirdTrainBackgroundSearch.setUserid(currentUser.getId());
        List result = this.thirdTrainBackgroundDao.listPeopleBackgroundScreening(thirdTrainBackgroundSearch);
        HashMap resultData = Maps.newHashMap();
        result.forEach(item -> resultData.put(item.getIdNumber(), item.getScreeningResults()));
        ajaxResult.setSuccessful(true);
        ajaxResult.setData((Object)JwtUtil.createJWT((String)JSON.toJSONString((Object)resultData, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue})));
        return ajaxResult;
    }

    private boolean validParams(ThirdTrainBackground thirdTrainBackground) {
        String businessId = thirdTrainBackground.getBusinessId();
        String businessType = thirdTrainBackground.getBusinessType();
        String idNumber = thirdTrainBackground.getIdNumber();
        String realName = thirdTrainBackground.getRealName();
        if (StringUtil.isBlank((CharSequence)businessId)) {
            return false;
        }
        if (StringUtil.isBlank((CharSequence)businessType)) {
            return false;
        }
        if (StringUtil.isBlank((CharSequence)idNumber)) {
            return false;
        }
        if (!IdcardUtil.isValidCard((String)idNumber)) {
            return false;
        }
        return !StringUtil.isBlank((CharSequence)realName);
    }
}

